/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.util;

import com.github.yzqdev.pet_home.util.ItemMobTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ClientMobTooltip
implements ClientTooltipComponent {
    private final Component name;
    private final CompoundTag entityTag;
    private final String id;

    public ClientMobTooltip(ItemMobTooltip itemMobTooltip) {
        CompoundTag tag = itemMobTooltip.compoundTag();
        String id = tag.getString("id");
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
        this.id = id;
        this.name = type.getDescription();
        this.entityTag = tag;
    }

    public int getHeight() {
        return 75;
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.name), 50);
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        int width = this.getWidth(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = (double)System.currentTimeMillis() / 25.0 % 360.0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(rot));
        pose.mul((Quaternionfc)rotation);
        guiGraphics.enableScissor(pX, posY - 60, pX + width, posY);
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        String id = this.entityTag.getString("id");
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
        LivingEntity livingEntity = (LivingEntity)type.create((Level)world);
        if (livingEntity != null) {
            livingEntity.setOnGround(true);
            livingEntity.load(this.entityTag);
            InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)posX, (float)posY, (float)25.0f, (Vector3f)new Vector3f(), (Quaternionf)pose, null, (LivingEntity)livingEntity);
            guiGraphics.disableScissor();
        }
    }
}

