/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.util;

import com.github.yzqdev.pet_home.PetHomeConfig;
import com.github.yzqdev.pet_home.util.Constants;
import com.github.yzqdev.pet_home.util.GlobalUtil;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class FriendlyFireCommon {
    public static final TagKey<Item> BYPASS_PET = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"bypass_pet"));
    public static final TagKey<Item> BYPASS_ALL = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"bypass_all_protection"));
    public static final TagKey<EntityType<?>> GENERAL_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GlobalUtil.res("general_protection"));
    public static final TagKey<EntityType<?>> PLAYER_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GlobalUtil.res("player_protection"));
    public static final TagKey<EntityType<?>> BYPASSED_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GlobalUtil.res("bypassed_entity_types"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)PetHomeConfig.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)PetHomeConfig.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)PetHomeConfig.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)PetHomeConfig.reflectDamage);
    }

    public static boolean preventAttack(Entity target, DamageSource source, float amount) {
        boolean preventDamage;
        Entity attacker = source.getEntity();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (PetHomeConfig.displayHitWarning) {
                player.displayClientMessage((Component)Component.literal((String)"").withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.getName()}).withStyle(ChatFormatting.WHITE)), true);
            }
        }
        return preventDamage;
    }

    public static boolean isProtected(Entity victim, Entity attacker, float amount) {
        AgeableMob agable;
        UUID ownerId;
        ItemStack heldItem;
        if (PetHomeConfig.noProtectionEntity.contains(victim.getType())) {
            return false;
        }
        if (victim == null || attacker == null || attacker.isCrouching()) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            v0 = attackerLiving.getMainHandItem();
        } else {
            v0 = heldItem = ItemStack.EMPTY;
        }
        if (PetHomeConfig.canHurtAllItem.contains(heldItem.getItem())) {
            return false;
        }
        if (PetHomeConfig.otherShouldProtectionEntity.contains(victim.getType())) {
            return true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (PetHomeConfig.playerCantHurtEntity.contains(victim.getType())) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(victim)) != null && !PetHomeConfig.canHurtPetItem.contains(heldItem.getItem())) {
            if (PetHomeConfig.protectPetsFromOwner && ownerId.equals(attacker.getUUID())) {
                if (PetHomeConfig.reflectDamage) {
                    attacker.hurt(attacker.level().damageSources().generic(), amount);
                }
                return true;
            }
            if (PetHomeConfig.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        if (PetHomeConfig.protectTeamMembers && FriendlyFireCommon.isOnProtectedTeam(attacker, victim)) {
            return true;
        }
        return PetHomeConfig.protectChildren && attacker instanceof Player && !(victim instanceof Enemy) && victim instanceof AgeableMob && (agable = (AgeableMob)victim).isBaby() && !attacker.isCrouching();
    }

    public static boolean isOnProtectedTeam(Entity attacker, Entity victim) {
        PlayerTeam attackerTeam = FriendlyFireCommon.getEffectiveTeam(attacker);
        PlayerTeam victimTeam = FriendlyFireCommon.getEffectiveTeam(victim);
        return attackerTeam != null && victimTeam != null && attackerTeam.isAlliedTo((Team)victimTeam) && victimTeam.isAlliedTo((Team)attackerTeam) && (!PetHomeConfig.respectTeamRules || !victimTeam.isAllowFriendlyFire());
    }

    @Nullable
    public static PlayerTeam getEffectiveTeam(Entity entity) {
        OwnableEntity ownable;
        PlayerTeam directTeam = entity.getTeam();
        if (directTeam == null && entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwnerUUID() != null) {
            ServerLevel server;
            GameProfile fetchResult;
            if (ownable.getOwner() != null) {
                return ownable.getOwner().getTeam();
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (fetchResult = (GameProfile)(server = (ServerLevel)level).getServer().getProfileCache().get(ownable.getOwnerUUID()).orElse(null)) != null) {
                return entity.level().getScoreboard().getPlayersTeam(fetchResult.getName());
            }
        }
        return directTeam;
    }

    @Nullable
    public static UUID getOwner(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.getOwnerUUID();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.getOwnerUUID();
        }
        return null;
    }
}

