/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LogUtil {
    private static final Marker INFO_MARKER = MarkerManager.getMarker((String)"INFO");
    private static final Marker DEBUG_MARKER = MarkerManager.getMarker((String)"DEBUG");
    private static final Marker WARN_MARKER = MarkerManager.getMarker((String)"WARN");
    private static final Marker ERROR_MARKER = MarkerManager.getMarker((String)"ERROR");

    public static void info(Class<?> clazz, String message, Object ... params) {
        LogUtil.getLogger(clazz).log(Level.INFO, INFO_MARKER, LogUtil.formatMessage(clazz, message), params);
    }

    public static void debug(Class<?> clazz, String message, Object ... params) {
        LogUtil.getLogger(clazz).log(Level.DEBUG, DEBUG_MARKER, LogUtil.formatMessage(clazz, message), params);
    }

    public static void warn(Class<?> clazz, String message, Object ... params) {
        LogUtil.getLogger(clazz).log(Level.WARN, WARN_MARKER, LogUtil.formatMessage(clazz, message), params);
    }

    public static void error(Class<?> clazz, String message, Object ... params) {
        LogUtil.getLogger(clazz).log(Level.ERROR, ERROR_MARKER, LogUtil.formatMessage(clazz, message), params);
    }

    public static void error(Class<?> clazz, String message, Throwable throwable) {
        LogUtil.getLogger(clazz).log(Level.ERROR, ERROR_MARKER, LogUtil.formatMessage(clazz, message), throwable);
    }

    private static Logger getLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz);
    }

    private static String formatMessage(Class<?> clazz, String message) {
        return String.format("[%s] %s", clazz.getSimpleName(), message);
    }

    public static void debugIfEnabled(Class<?> clazz, String message, Object ... params) {
        Logger logger = LogUtil.getLogger(clazz);
        if (logger.isDebugEnabled()) {
            LogUtil.debug(clazz, message, params);
        }
    }
}

