/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.util;

import com.github.yzqdev.pet_home.ModConstants;
import com.github.yzqdev.pet_home.datagen.ModEnchantments;
import com.github.yzqdev.pet_home.network.PropertiesMessage;
import com.github.yzqdev.pet_home.server.entity.HighlightedBlockEntity;
import com.github.yzqdev.pet_home.server.entity.ModifedToBeTameable;
import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import com.github.yzqdev.pet_home.util.CitadelEntityData;
import com.github.yzqdev.pet_home.util.IComandableMob;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.PacketDistributor;

public class TameableUtils {
    private static final String ENCHANTMENT_TAG = "StoredPetEnchantments";
    private static final String COLLAR_TAG = "HasPetCollar";
    private static final String IMMUNITY_TIME_TAG = "PetImmunityTimer";
    private static final String FROZEN_TIME_TAG = "PetFrozenTime";
    private static final String ATTACK_TARGET_ENTITY = "PetAttackTarget";
    private static final String SHADOW_PUNCH_TIMES = "PetShadowPunchTimes";
    private static final String SHADOW_PUNCH_COOLDOWN = "PetShadowPunchCooldown";
    private static final String PSYCHIC_WALL_COOLDOWN = "PetPsychicWallCooldown";
    private static final String INTIMIDATION_COOLDOWN = "PetIntimidationCooldown";
    private static final String SHADOW_PUNCH_STRIKING = "PetShadowPunchStriking";
    private static final String JUKEBOX_FOLLOWER_UUID = "PetJukeboxFollowerUUID";
    private static final String JUKEBOX_FOLLOWER_DISC = "PetJukeboxFollowerDisc";
    private static final String BLAZING_PROTECTION_BARS = "PetBlazingProtectionBars";
    private static final String BLAZING_PROTECTION_COOLDOWN = "PetBlazingProtectionCooldown";
    private static final String HEALING_AURA_TIME = "PetHealingAuraTime";
    private static final String Sonic_boom_TIME = "PetSonicBoomTime";
    private static final String HEALING_AURA_IMPULSE = "PetHealingAuraImpulse";
    private static final String HAS_PET_BED = "HasPetBed";
    private static final String PET_BED_X = "PetBedX";
    private static final String PET_BED_Y = "PetBedY";
    private static final String PET_BED_Z = "PetBedZ";
    private static final String PET_BED_DIMENSION = "PetBedDimension";
    private static final String FALL_DISTANCE_SYNC = "SyncedFallDistance";
    private static final String ZOMBIE_PET = "ZombiePet";
    private static final String SAFE_PET_HEALTH = "SafePetHealth";
    private static final String COLLAR_SWAP_COOLDOWN = "CollarSwapCooldown";
    private static final ResourceLocation HEALTH_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"health_boost");
    private static final ResourceLocation SPEED_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"speed_boost");
    private static final ResourceLocation ARMOR_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"armor_boost");
    private static final ResourceLocation RESISTANCE_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"resistance_boost");
    private static final ResourceLocation SPEED_BOOST_AQUATIC_LAND_UUID = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"speed_boost_aqua");

    public static UUID getOwnerUUIDOf(Entity entity) {
        if (entity instanceof ModifedToBeTameable) {
            return ((ModifedToBeTameable)entity).getTameOwnerUUID();
        }
        if (entity instanceof TamableAnimal) {
            return ((TamableAnimal)entity).getOwnerUUID();
        }
        return null;
    }

    public static boolean hasCollar(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.contains(COLLAR_TAG) && tag.getBoolean(COLLAR_TAG);
    }

    public static boolean shouldUnloadToLantern(LivingEntity tameable) {
        if (tameable instanceof IComandableMob) {
            IComandableMob commandableMob = (IComandableMob)tameable;
            return commandableMob.getCommand() == 2;
        }
        CompoundTag tag = new CompoundTag();
        tameable.addAdditionalSaveData(tag);
        int command = -1;
        for (String s : tag.getAllKeys()) {
            if (!s.endsWith("Command") || !tag.contains(s, 1)) continue;
            command = tag.getInt(s);
        }
        if (command != -1) {
            return command == 1;
        }
        if (tameable instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)tameable;
            return !animal.isOrderedToSit();
        }
        return false;
    }

    public static double getSafePetHealth(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getDouble(SAFE_PET_HEALTH);
    }

    public static void setSafePetHealth(LivingEntity enchanted, double health) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putDouble(SAFE_PET_HEALTH, health);
        TameableUtils.sync(enchanted, tag);
    }

    public static boolean isTamed(Entity entity) {
        return entity instanceof ModifedToBeTameable && ((ModifedToBeTameable)entity).isTame() || entity instanceof TamableAnimal && ((TamableAnimal)entity).isTame();
    }

    public static boolean isPetOf(Player player, Entity entity) {
        return entity != null && (entity.isAlliedTo((Entity)player) || TameableUtils.hasSameOwnerAsOneWay(entity, (Entity)player));
    }

    private static boolean hasSameOwnerAsOneWay(Entity tameable, Entity target) {
        ModifedToBeTameable axolotl;
        TamableAnimal tamed;
        if (tameable instanceof TamableAnimal && (tamed = (TamableAnimal)tameable).getOwner() != null) {
            TamableAnimal otherPet;
            ModifedToBeTameable axolotl2;
            if (target instanceof ModifedToBeTameable && (axolotl2 = (ModifedToBeTameable)target).getTameOwner() != null && tamed.getOwner().equals((Object)axolotl2.getTameOwner())) {
                return true;
            }
            if (target instanceof TamableAnimal && (otherPet = (TamableAnimal)target).getOwner() != null && tamed.getOwner().equals((Object)otherPet.getOwner())) {
                return true;
            }
            return tamed.getOwner().equals((Object)target);
        }
        if (tameable instanceof ModifedToBeTameable && (axolotl = (ModifedToBeTameable)tameable).getTameOwner() != null) {
            ModifedToBeTameable otherPet;
            TamableAnimal tamed2;
            if (tameable instanceof TamableAnimal && (tamed2 = (TamableAnimal)tameable).getOwner() != null && tamed2.getOwner().equals((Object)axolotl.getTameOwner())) {
                return true;
            }
            if (target instanceof ModifedToBeTameable && (otherPet = (ModifedToBeTameable)target).getTameOwner() != null && axolotl.getTameOwner().equals((Object)otherPet.getTameOwner())) {
                return true;
            }
            return axolotl.getTameOwner().equals((Object)target);
        }
        return false;
    }

    @Nullable
    public static BlockPos getPetBedPos(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        if (tag.getBoolean(HAS_PET_BED) && tag.contains(PET_BED_X) && tag.contains(PET_BED_Y) && tag.contains(PET_BED_Z)) {
            return new BlockPos(tag.getInt(PET_BED_X), tag.getInt(PET_BED_Y), tag.getInt(PET_BED_Z));
        }
        return null;
    }

    public static void setPetBedPos(LivingEntity enchanted, BlockPos petBed) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putBoolean(HAS_PET_BED, true);
        tag.putInt(PET_BED_X, petBed.getX());
        tag.putInt(PET_BED_Y, petBed.getY());
        tag.putInt(PET_BED_Z, petBed.getZ());
        TameableUtils.sync(enchanted, tag);
    }

    public static void removePetBedPos(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putBoolean(HAS_PET_BED, false);
        TameableUtils.sync(enchanted, tag);
    }

    public static String getPetBedDimension(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return !tag.contains(PET_BED_DIMENSION) ? "minecraft:overworld" : tag.getString(PET_BED_DIMENSION);
    }

    public static void setPetBedDimension(LivingEntity enchanted, String dimension) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putString(PET_BED_DIMENSION, dimension);
        TameableUtils.sync(enchanted, tag);
    }

    public static Entity getOwnerOf(Entity entity) {
        if (entity instanceof ModifedToBeTameable) {
            return ((ModifedToBeTameable)entity).getTameOwner();
        }
        if (entity instanceof TamableAnimal) {
            return ((TamableAnimal)entity).getOwner();
        }
        return null;
    }

    public static int getBlazingProtectionBars(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(BLAZING_PROTECTION_BARS);
    }

    public static int getBlazingProtectionCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(BLAZING_PROTECTION_COOLDOWN);
    }

    public static void setBlazingProtectionCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(BLAZING_PROTECTION_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static void setBlazingProtectionBars(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(BLAZING_PROTECTION_BARS, time);
        TameableUtils.sync(enchanted, tag);
    }

    private static void sync(LivingEntity entity, CompoundTag tag) {
        CitadelEntityData.setCitadelTag(entity, tag);
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PropertiesMessage(ModConstants.entityDataTagUpdate, tag, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new PropertiesMessage(ModConstants.entityDataTagUpdate, tag, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void clearEnchants(LivingEntity entity) {
        TameableUtils.setEnchantmentTag(entity, new ListTag());
    }

    private static void setEnchantmentTag(LivingEntity enchanted, ListTag enchants) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        Map<ResourceLocation, Integer> prevEnchants = TameableUtils.getEnchants(enchanted);
        tag.put(ENCHANTMENT_TAG, (Tag)enchants);
        tag.putInt(COLLAR_SWAP_COOLDOWN, 20);
        tag.putBoolean(COLLAR_TAG, true);
        TameableUtils.sync(enchanted, tag);
        TameableUtils.onUpdateEnchants(prevEnchants, enchanted);
    }

    private static boolean isWaterCreature(LivingEntity enchanted) {
        return enchanted.getType().getCategory() == MobCategory.WATER_CREATURE || enchanted.getType().getCategory() == MobCategory.UNDERGROUND_WATER_CREATURE || enchanted.getType().getCategory() == MobCategory.WATER_AMBIENT;
    }

    private static void onUpdateEnchants(@Nullable Map<ResourceLocation, Integer> prevEnchants, LivingEntity enchanted) {
        int healthExtra = TameableUtils.getEnchantLevel(enchanted, ModEnchantments.HEALTH_BOOST);
        int speedExtra = TameableUtils.getEnchantLevel(enchanted, ModEnchantments.SPEEDSTER);
        int toughExtra = TameableUtils.getEnchantLevel(enchanted, ModEnchantments.TOUGH);
        boolean amphib = TameableUtils.hasEnchant(enchanted, ModEnchantments.AMPHIBIOUS) && !enchanted.isInWaterOrBubble() && TameableUtils.isWaterCreature(enchanted);
        AttributeInstance health = enchanted.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance speed = enchanted.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeInstance armor = enchanted.getAttribute(Attributes.ARMOR);
        AttributeInstance resistance = enchanted.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        Registry enchantReg = enchanted.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        if (TameableUtils.hasEnchant(enchanted, ModEnchantments.IMMATURITY_CURSE) || prevEnchants != null && prevEnchants.containsKey(ModEnchantments.IMMATURITY_CURSE.registry())) {
            enchanted.setPose(Pose.FALL_FLYING);
            AgeableMob ageable = (AgeableMob)enchanted;
            ageable.setBaby(true);
            enchanted.refreshDimensions();
        }
        if (armor != null && resistance != null) {
            AttributeModifier armorBoost = new AttributeModifier(ARMOR_BOOST_UUID, (double)(toughExtra * 3), AttributeModifier.Operation.ADD_VALUE);
            AttributeModifier resBoost = new AttributeModifier(RESISTANCE_BOOST_UUID, (double)(toughExtra * 3), AttributeModifier.Operation.ADD_VALUE);
            if (toughExtra > 0) {
                if (armor.hasModifier(armorBoost.id())) {
                    armor.removeModifier(armorBoost);
                    armor.addPermanentModifier(armorBoost);
                } else {
                    armor.addPermanentModifier(armorBoost);
                }
                if (resistance.hasModifier(resBoost.id())) {
                    resistance.removeModifier(resBoost);
                    resistance.addPermanentModifier(resBoost);
                } else {
                    resistance.addPermanentModifier(resBoost);
                }
            } else {
                armor.removeModifier(ARMOR_BOOST_UUID);
                resistance.removeModifier(RESISTANCE_BOOST_UUID);
            }
        }
        if (health != null) {
            AttributeModifier healthBoostPetUpgrade = new AttributeModifier(HEALTH_BOOST_UUID, (double)(healthExtra * 10), AttributeModifier.Operation.ADD_VALUE);
            if (healthExtra > 0) {
                if (health.hasModifier(healthBoostPetUpgrade.id())) {
                    health.removeModifier(healthBoostPetUpgrade);
                    health.addPermanentModifier(healthBoostPetUpgrade);
                } else {
                    health.addPermanentModifier(healthBoostPetUpgrade);
                }
            } else {
                health.removeModifier(healthBoostPetUpgrade);
            }
        }
        if (speed != null) {
            AttributeModifier speedsterPetUpgrade = new AttributeModifier(SPEED_BOOST_UUID, (double)((float)speedExtra * 0.075f), AttributeModifier.Operation.ADD_VALUE);
            if (speedExtra > 0) {
                if (speed.hasModifier(speedsterPetUpgrade.id())) {
                    speed.removeModifier(speedsterPetUpgrade);
                    speed.addPermanentModifier(speedsterPetUpgrade);
                } else {
                    speed.addPermanentModifier(speedsterPetUpgrade);
                }
            } else {
                speed.removeModifier(speedsterPetUpgrade);
            }
            AttributeModifier speed_aqua = new AttributeModifier(SPEED_BOOST_AQUATIC_LAND_UUID, (double)0.13f, AttributeModifier.Operation.ADD_VALUE);
            if (amphib) {
                if (speed.hasModifier(speed_aqua.id())) {
                    speed.removeModifier(speed_aqua);
                    speed.addPermanentModifier(speed_aqua);
                } else {
                    speed.addPermanentModifier(speed_aqua);
                }
            } else {
                speed.removeModifier(speed_aqua);
            }
        }
    }

    public static boolean hasEnchant(LivingEntity entity, ResourceKey<Enchantment> enchantment) {
        return TameableUtils.getEnchantLevel(entity, enchantment) > 0;
    }

    public static int getEnchantLevel(LivingEntity entity, ResourceKey<Enchantment> enchantment) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        if (listtag != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                ResourceLocation location = ResourceLocation.parse((String)compoundtag.getString("id"));
                if (!enchantment.location().equals((Object)location)) continue;
                return compoundtag.getInt("lvl");
            }
        }
        return 0;
    }

    @Nullable
    private static ListTag getEnchantmentList(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(entity);
        if (tag.contains(ENCHANTMENT_TAG)) {
            return tag.getList(ENCHANTMENT_TAG, 10);
        }
        return null;
    }

    public static List<Component> getEnchantDescriptions(LivingEntity entity) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"message.pet_home.enchantments").withStyle(ChatFormatting.GOLD)));
        Map<ResourceLocation, Integer> map = TameableUtils.getEnchants(entity);
        if (map != null) {
            for (Map.Entry<ResourceLocation, Integer> entry : map.entrySet()) {
                boolean isCurse = entry.getKey().getPath().contains("curse");
                list.add((Component)Component.translatable((String)("enchantment." + entry.getKey().getNamespace() + "." + entry.getKey().getPath())).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)("enchantment.level." + String.valueOf(entry.getValue())))).withStyle(isCurse ? ChatFormatting.RED : ChatFormatting.AQUA));
            }
        }
        return list;
    }

    public static Map<ResourceLocation, Integer> getEnchants(LivingEntity entity) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        if (listtag == null) {
            return null;
        }
        HashMap<ResourceLocation, Integer> enchants = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            ResourceLocation res = ResourceLocation.parse((String)compoundtag.getString("id"));
            enchants.put(res, compoundtag.getInt("lvl"));
        }
        return enchants;
    }

    public static CompoundTag storeEnchantment(@Nullable ResourceLocation pId, int pLevel) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("id", String.valueOf(pId));
        compoundtag.putShort("lvl", (short)pLevel);
        return compoundtag;
    }

    public static void addEnchant(LivingEntity entity, ItemEnchantments itemEnchantments) {
        ListTag listTag = new ListTag();
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            ResourceLocation en = ((Holder)entry.getKey()).getKey().location();
            CompoundTag compound = TameableUtils.storeEnchantment(en, entry.getIntValue());
            listTag.add((Object)compound);
        }
        TameableUtils.setEnchantmentTag(entity, listTag);
    }

    public static boolean hasSameOwnerAs(LivingEntity tameable, Entity target) {
        return TameableUtils.hasSameOwnerAsOneWay((Entity)tameable, target) || TameableUtils.hasSameOwnerAsOneWay(target, (Entity)tameable);
    }

    public static void xpTransfer(LivingEntity living) {
        for (ExperienceOrb experienceorb : living.level().getEntitiesOfClass(ExperienceOrb.class, living.getBoundingBox().inflate(3.0))) {
            Vec3 vec3 = new Vec3(living.getX() - experienceorb.getX(), living.getY() + (double)living.getEyeHeight() / 2.0 - experienceorb.getY(), living.getZ() - experienceorb.getZ());
            double d0 = vec3.lengthSqr();
            if (d0 < 2.0) {
                Entity owner = TameableUtils.getOwnerOf((Entity)living);
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.giveExperiencePoints(experienceorb.value);
                }
                experienceorb.discard();
            }
            if (!(d0 < 64.0)) continue;
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            experienceorb.setDeltaMovement(experienceorb.getDeltaMovement().add(vec3.normalize().scale(d1 * d1 * 0.5)));
        }
    }

    public static void absorbExpOrbs(LivingEntity living) {
        if (living.getHealth() < living.getMaxHealth() && !living.level().isClientSide) {
            for (ExperienceOrb experienceorb : living.level().getEntitiesOfClass(ExperienceOrb.class, living.getBoundingBox().inflate(3.0))) {
                if (living.getHealth() >= living.getMaxHealth()) break;
                Vec3 vec3 = new Vec3(living.getX() - experienceorb.getX(), living.getY() + (double)living.getEyeHeight() / 2.0 - experienceorb.getY(), living.getZ() - experienceorb.getZ());
                double d0 = vec3.lengthSqr();
                if (d0 < 2.0 && !living.isDeadOrDying()) {
                    float h = living.getHealth() + (float)experienceorb.value;
                    living.setHealth(h);
                    if (h - living.getMaxHealth() > 0.0f) {
                        experienceorb.value = (int)Math.floor(h - living.getMaxHealth());
                        break;
                    }
                    experienceorb.discard();
                }
                if (!(d0 < 64.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 8.0;
                experienceorb.setDeltaMovement(experienceorb.getDeltaMovement().add(vec3.normalize().scale(d1 * d1 * 0.5)));
            }
        }
    }

    public static int getHealingAuraTime(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(HEALING_AURA_TIME);
    }

    public static void setHealingAuraTime(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(HEALING_AURA_TIME, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static long getSonicboomAuraTime(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getLong(Sonic_boom_TIME);
    }

    public static void setSonicboomAuraTime(LivingEntity enchanted, long time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putLong(Sonic_boom_TIME, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static boolean getHealingAuraImpulse(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getBoolean(HEALING_AURA_IMPULSE);
    }

    public static void setHealingAuraImpulse(LivingEntity enchanted, boolean impulse) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putBoolean(HEALING_AURA_IMPULSE, impulse);
        TameableUtils.sync(enchanted, tag);
    }

    public static List<LivingEntity> getAuraHealables(LivingEntity pet) {
        Predicate<Entity> hurtAndOnTeam = animal -> TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)pet) && animal.distanceTo((Entity)pet) < 4.0f && ((LivingEntity)animal).getHealth() < ((LivingEntity)animal).getMaxHealth();
        return pet.level().getEntitiesOfClass(LivingEntity.class, pet.getBoundingBox().inflate(4.0, 4.0, 4.0), EntitySelector.NO_SPECTATORS.and(hurtAndOnTeam));
    }

    public static int getPsychicWallCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(PSYCHIC_WALL_COOLDOWN);
    }

    public static void setPsychicWallCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(PSYCHIC_WALL_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static void attractAnimals(LivingEntity attractor, int max) {
        if ((attractor.tickCount + attractor.getId()) % 8 == 0) {
            Predicate<Entity> notOnTeam = animal -> !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)attractor) && animal.distanceTo((Entity)attractor) > 3.0f + attractor.getBbWidth() * 1.6f;
            List list = attractor.level().getEntitiesOfClass(Animal.class, attractor.getBoundingBox().inflate(16.0, 8.0, 16.0), EntitySelector.NO_SPECTATORS.and(notOnTeam));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)attractor).distanceToSqr(arg_0)));
            for (int i = 0; i < Math.min(max, list.size()); ++i) {
                Animal e = (Animal)list.get(i);
                e.setTarget(null);
                e.setLastHurtByMob(null);
                e.getNavigation().moveTo((Entity)attractor, 1.1);
            }
        }
    }

    public static int getPetAttackTargetID(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return !tag.contains(ATTACK_TARGET_ENTITY) ? -1 : tag.getInt(ATTACK_TARGET_ENTITY);
    }

    @Nullable
    public static Entity getPetAttackTarget(LivingEntity enchanted) {
        int i = TameableUtils.getPetAttackTargetID(enchanted);
        return i == -1 ? null : enchanted.level().getEntity(i);
    }

    public static void setPetAttackTarget(LivingEntity enchanted, int id) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(ATTACK_TARGET_ENTITY, id);
        TameableUtils.sync(enchanted, tag);
    }

    public static void aggroRandomMonsters(LivingEntity attractor) {
        if ((attractor.tickCount + attractor.getId()) % 400 == 0) {
            Predicate<Entity> notOnTeamAndMonster = animal -> animal instanceof Enemy && !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)attractor) && animal.distanceTo((Entity)attractor) > 3.0f + attractor.getBbWidth() * 1.6f;
            List list = attractor.level().getEntitiesOfClass(Mob.class, attractor.getBoundingBox().inflate(20.0, 8.0, 20.0), EntitySelector.NO_SPECTATORS.and(notOnTeamAndMonster));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)attractor).distanceToSqr(arg_0)));
            if (!list.isEmpty()) {
                ((Mob)list.get(0)).setTarget(attractor);
            }
        }
    }

    public static int getIntimidationCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(INTIMIDATION_COOLDOWN);
    }

    public static void setIntimidationCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(INTIMIDATION_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static void scareRandomMonsters(LivingEntity scary, int level) {
        boolean interval;
        boolean bl = interval = (scary.tickCount + scary.getId()) % Math.max(140, 600 - level * 200) == 0;
        if (interval || scary.hurtTime == 4 || TameableUtils.getIntimidationCooldown(scary) > 0) {
            Predicate<Entity> notOnTeamAndMonster = animal -> animal instanceof Monster && !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)scary) && animal.distanceTo((Entity)scary) > 3.0f + scary.getBbWidth() * 1.6f;
            List list = scary.level().getEntitiesOfClass(PathfinderMob.class, scary.getBoundingBox().inflate((double)(10 * level), (double)(8 * level), (double)(10 * level)), EntitySelector.NO_SPECTATORS.and(notOnTeamAndMonster));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)scary).distanceToSqr(arg_0)));
            if (!list.isEmpty()) {
                if (TameableUtils.getIntimidationCooldown(scary) > 0 && !interval) {
                    TameableUtils.setIntimidationCooldown(scary, TameableUtils.getIntimidationCooldown(scary) - 1);
                } else {
                    Vec3 rots = ((PathfinderMob)list.get(0)).getEyePosition().subtract(scary.getEyePosition()).normalize();
                    float f = Mth.sqrt((float)((float)(rots.x * rots.x + rots.z * rots.z)));
                    double yRot = Math.atan2(-rots.z, -rots.x) * 57.2957763671875 + 90.0;
                    double xRot = Math.atan2(-rots.y, f) * 57.2957763671875;
                    scary.level().addParticle((ParticleOptions)PHParticleRegistry.INTIMIDATION.get(), scary.getX(), scary.getY(), scary.getZ(), (double)scary.getId(), xRot, yRot);
                    TameableUtils.setIntimidationCooldown(scary, 70 * level);
                    if (scary instanceof Mob) {
                        ((Mob)scary).playAmbientSound();
                    }
                }
                for (PathfinderMob monster : list) {
                    Vec3 vec = LandRandomPos.getPosAway((PathfinderMob)monster, (int)(11 * level), (int)7, (Vec3)scary.position());
                    if (vec == null) continue;
                    monster.getNavigation().moveTo(vec.x, vec.y, vec.z, 1.5);
                }
            }
        }
    }

    public static boolean couldBeTamed(Entity entity) {
        return entity instanceof ModifedToBeTameable || entity instanceof TamableAnimal;
    }

    public static void destroyRandomPlants(LivingEntity living) {
        if ((living.tickCount + living.getId()) % 200 == 0) {
            int i;
            int range = 2;
            ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
            ArrayList<BlockPos> grasses = new ArrayList<BlockPos>();
            BlockPos blockpos = living.blockPosition();
            int half = range / 2;
            RandomSource r = living.getRandom();
            int maxPlants = 2 + r.nextInt(2);
            int i2 = 0;
            while (i2 <= half && i2 >= -half) {
                int j = 0;
                while (j <= range && j >= -range) {
                    int k = 0;
                    while (k <= range && k >= -range) {
                        BlockPos offset = blockpos.offset(j, i2, k);
                        BlockState state = living.level().getBlockState(offset);
                        if (!state.isAir() && r.nextInt(4) == 0) {
                            if (state.is(BlockTags.FLOWERS) || state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(BlockTags.CROPS)) {
                                plants.add(offset);
                            } else if (state.is(BlockTags.DIRT) && !state.is(Blocks.DIRT) && !state.is(Blocks.COARSE_DIRT) || state.is(Blocks.FARMLAND)) {
                                grasses.add(offset);
                            }
                        }
                        k = (k <= 0 ? 1 : 0) - k;
                    }
                    j = (j <= 0 ? 1 : 0) - j;
                }
                i2 = (i2 <= 0 ? 1 : 0) - i2;
            }
            for (BlockPos plant : plants) {
                living.level().setBlockAndUpdate(plant, Blocks.AIR.defaultBlockState());
                for (i = 0; i < 1 + r.nextInt(2); ++i) {
                    living.level().addParticle((ParticleOptions)PHParticleRegistry.BLIGHT.get(), (double)((float)plant.getX() + r.nextFloat()), (double)((float)plant.getY() + r.nextFloat()), (double)((float)plant.getZ() + r.nextFloat()), 0.0, (double)0.08f, 0.0);
                }
            }
            for (BlockPos dirt : grasses) {
                living.level().setBlockAndUpdate(dirt, r.nextBoolean() ? Blocks.COARSE_DIRT.defaultBlockState() : Blocks.DIRT.defaultBlockState());
                for (i = 0; i < 1 + r.nextInt(2); ++i) {
                    living.level().addParticle((ParticleOptions)PHParticleRegistry.BLIGHT.get(), (double)((float)dirt.getX() + r.nextFloat()), (double)(dirt.getY() + 1), (double)((float)dirt.getZ() + r.nextFloat()), 0.0, (double)0.08f, 0.0);
                }
            }
        }
    }

    public static void detectRandomOres(LivingEntity attractor, int interval, int range, int effectLength, int maxOres) {
        int tick = (attractor.tickCount + attractor.getId()) % interval;
        if (tick <= 30) {
            attractor.xRotO = attractor.getXRot();
            attractor.setXRot((float)Math.sin((float)tick * 0.6f) * 30.0f);
            Vec3 look = attractor.getEyePosition().add(attractor.getViewVector(1.0f).scale((double)attractor.getBbWidth()));
            for (int i = 0; i < 3; ++i) {
                double x = attractor.getRandomX(2.0);
                double y = attractor.position().y;
                double z = attractor.getRandomZ(2.0);
                attractor.level().addParticle((ParticleOptions)PHParticleRegistry.SNIFF.get(), x, y, z, look.x, look.y, look.z);
            }
        }
        if (tick == 30) {
            ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
            BlockPos blockpos = attractor.blockPosition();
            int half = range / 2;
            int i = 0;
            while (i <= half && i >= -half) {
                int j = 0;
                while (j <= range && j >= -range) {
                    int k = 0;
                    while (k <= range && k >= -range) {
                        BlockPos offset = blockpos.offset(j, i, k);
                        BlockState state = attractor.level().getBlockState(offset);
                        if (state.is(Tags.Blocks.ORES)) {
                            if (ores.size() >= maxOres) break;
                            ores.add(offset);
                        }
                        k = (k <= 0 ? 1 : 0) - k;
                    }
                    j = (j <= 0 ? 1 : 0) - j;
                }
                i = (i <= 0 ? 1 : 0) - i;
            }
            for (BlockPos ore : ores) {
                HighlightedBlockEntity highlight = (HighlightedBlockEntity)((EntityType)PHEntityRegistry.HIGHLIGHTED_BLOCK.get()).create(attractor.level());
                highlight.setPos(Vec3.atBottomCenterOf((Vec3i)ore));
                highlight.setLifespan(effectLength);
                highlight.setXRot(0.0f);
                highlight.setYRot(0.0f);
                attractor.level().addFreshEntity((Entity)highlight);
            }
        }
    }

    public static int getImmuneTime(LivingEntity enchanted) {
        if (TameableUtils.hasEnchant(enchanted, ModEnchantments.IMMUNITY_FRAME)) {
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
            return tag.getInt(IMMUNITY_TIME_TAG);
        }
        return 0;
    }

    public static void setImmuneTime(LivingEntity enchanted, int time) {
        if (TameableUtils.hasEnchant(enchanted, ModEnchantments.IMMUNITY_FRAME)) {
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
            tag.putInt(IMMUNITY_TIME_TAG, time);
            TameableUtils.sync(enchanted, tag);
        }
    }

    public static int getFrozenTime(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(FROZEN_TIME_TAG);
    }

    public static void setFrozenTimeTag(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(FROZEN_TIME_TAG, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static List<LivingEntity> getNearbyHealers(LivingEntity hurtOwner) {
        Predicate<Entity> healer = animal -> TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)hurtOwner) && TameableUtils.hasEnchant((LivingEntity)animal, ModEnchantments.HEALING_AURA) && TameableUtils.getHealingAuraTime((LivingEntity)animal) == 0;
        return hurtOwner.level().getEntitiesOfClass(LivingEntity.class, hurtOwner.getBoundingBox().inflate(16.0, 4.0, 16.0), EntitySelector.NO_SPECTATORS.and(healer));
    }

    public static float getFallDistance(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getFloat(FALL_DISTANCE_SYNC);
    }

    public static void setFallDistance(LivingEntity enchanted, float dist) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putFloat(FALL_DISTANCE_SYNC, dist);
        TameableUtils.sync(enchanted, tag);
    }

    public static int getShadowPunchCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getInt(SHADOW_PUNCH_COOLDOWN);
    }

    public static void setShadowPunchCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putInt(SHADOW_PUNCH_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static int[] getShadowPunchTimes(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getIntArray(SHADOW_PUNCH_TIMES);
    }

    public static void setShadowPunchTimes(LivingEntity enchanted, int[] times) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putIntArray(SHADOW_PUNCH_TIMES, times);
        TameableUtils.sync(enchanted, tag);
    }

    public static void setShadowPunchStriking(LivingEntity enchanted, int[] times) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        tag.putIntArray(SHADOW_PUNCH_STRIKING, times);
        TameableUtils.sync(enchanted, tag);
    }

    public static int[] getShadowPunchStriking(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag(enchanted);
        return tag.getIntArray(SHADOW_PUNCH_STRIKING);
    }

    public static boolean isValidTeleporter(LivingEntity owner, Mob animal) {
        if (TameableUtils.hasEnchant((LivingEntity)animal, ModEnchantments.TETHERED_TELEPORT)) {
            if (animal instanceof IComandableMob) {
                IComandableMob commandableMob = (IComandableMob)animal;
                return commandableMob.getCommand() == 2;
            }
            if (animal instanceof TamableAnimal) {
                TamableAnimal tame = (TamableAnimal)animal;
                return !tame.isOrderedToSit() && animal.distanceTo((Entity)owner) < 10.0f;
            }
        }
        return false;
    }

    public static void applyGlowingEffect(LivingEntity livingEntity, int enchantLevel) {
        int range = enchantLevel * 15;
        livingEntity.level().getEntitiesOfClass(LivingEntity.class, new AABB(livingEntity.getX() - (double)range, livingEntity.getY() - (double)range, livingEntity.getZ() - (double)range, livingEntity.getX() + (double)range, livingEntity.getY() + (double)range, livingEntity.getZ() + (double)range)).stream().filter(i -> i instanceof Enemy).forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20, 0)));
    }

    public static List<LivingEntity> getNearbyMobs(LivingEntity entity, double range) {
        AABB area = new AABB(entity.getX() - range, entity.getY() - range, entity.getZ() - range, entity.getX() + range, entity.getY() + range, entity.getZ() + range);
        return entity.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != entity && !(e instanceof Player));
    }

    public static void performSonicBook(LivingEntity maid, LivingEntity monster, ServerLevel serverLevel) {
        Set livings = TameableUtils.getNearbyMobs(maid, 5.0).stream().filter(i -> i instanceof Enemy).collect(Collectors.toSet());
        if (livings.size() > 3) {
            for (LivingEntity enemy : livings) {
                TameableUtils.sonicBoomAttack(maid, enemy, serverLevel);
            }
        } else {
            TameableUtils.sonicBoomAttack(maid, monster, serverLevel);
        }
    }

    public static void sonicBoomAttack(LivingEntity maid, LivingEntity monster, ServerLevel serverLevel) {
        Vec3 vec3 = maid.position().add(maid.getAttachments().get(EntityAttachment.WARDEN_CHEST, 0, maid.getYRot()));
        Vec3 vec32 = monster.getEyePosition().subtract(vec3);
        Vec3 vec33 = vec32.normalize();
        int i = Mth.floor((double)vec32.length()) + 7;
        for (int j = 1; j < i; ++j) {
            Vec3 vec34 = vec3.add(vec33.scale((double)j));
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, vec34.x, vec34.y, vec34.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        maid.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
        if (monster.hurt(serverLevel.damageSources().sonicBoom((Entity)maid), 10.0f)) {
            double d = 0.5 * (1.0 - monster.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            double e = 2.5 * (1.0 - monster.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            monster.push(vec33.x() * e, vec33.y() * d, vec33.z() * e);
        }
    }
}

