/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.worldgen;

import com.github.yzqdev.pet_home.PetHomeConfig;
import com.github.yzqdev.pet_home.PetHomeMod;
import com.github.yzqdev.pet_home.worldgen.PetshopStructurePoolElement;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageHouseManager {
    public static final List<ResourceLocation> VILLAGE_REPLACEMENT_POOLS = List.of(ResourceLocation.parse((String)"minecraft:village/plains/houses"), ResourceLocation.parse((String)"minecraft:village/desert/houses"), ResourceLocation.parse((String)"minecraft:village/savanna/houses"), ResourceLocation.parse((String)"minecraft:village/snowy/houses"), ResourceLocation.parse((String)"minecraft:village/taiga/houses"));
    private static final List<Pair<ResourceLocation, Consumer<StructureTemplatePool>>> REGISTRY = new ArrayList<Pair<ResourceLocation, Consumer<StructureTemplatePool>>>();

    public static StructureTemplatePool addToPool(StructureTemplatePool pool, StructurePoolElement element, int weight) {
        ObjectArrayList templates;
        if (weight > 0 && pool != null && !(templates = new ObjectArrayList((ObjectList)pool.templates)).contains((Object)element)) {
            for (int i = 0; i < weight; ++i) {
                templates.add((Object)element);
            }
            ArrayList<Pair> rawTemplates = new ArrayList<Pair>(pool.rawTemplates);
            rawTemplates.add(new Pair((Object)element, (Object)weight));
            pool.templates = templates;
            pool.rawTemplates = rawTemplates;
            PetHomeMod.LOGGER.info("Added to village structure pool");
        }
        return pool;
    }

    public static void addAllHouses(RegistryAccess registryAccess) {
        int weight = PetHomeConfig.petstoreVillageWeight;
        PetshopStructurePoolElement plains = new PetshopStructurePoolElement(ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"plains_petshop"), (Holder<StructureProcessorList>)StructurePoolElement.EMPTY);
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)ResourceLocation.parse((String)"minecraft:village/plains/houses"), arg_0 -> VillageHouseManager.lambda$addAllHouses$0((StructurePoolElement)plains, weight, arg_0)));
        PetshopStructurePoolElement desert = new PetshopStructurePoolElement(ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"desert_petshop"), (Holder<StructureProcessorList>)StructurePoolElement.EMPTY);
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)ResourceLocation.parse((String)"minecraft:village/desert/houses"), arg_0 -> VillageHouseManager.lambda$addAllHouses$1((StructurePoolElement)desert, weight, arg_0)));
        PetshopStructurePoolElement savanna = new PetshopStructurePoolElement(ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"savanna_petshop"), (Holder<StructureProcessorList>)StructurePoolElement.EMPTY);
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)ResourceLocation.parse((String)"minecraft:village/savanna/houses"), arg_0 -> VillageHouseManager.lambda$addAllHouses$2((StructurePoolElement)savanna, weight, arg_0)));
        PetshopStructurePoolElement snowy = new PetshopStructurePoolElement(ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"snowy_petshop"), (Holder<StructureProcessorList>)StructurePoolElement.EMPTY);
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)ResourceLocation.parse((String)"minecraft:village/snowy/houses"), arg_0 -> VillageHouseManager.lambda$addAllHouses$3((StructurePoolElement)snowy, weight, arg_0)));
        PetshopStructurePoolElement taiga = new PetshopStructurePoolElement(ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"taiga_petshop"), (Holder<StructureProcessorList>)StructurePoolElement.EMPTY);
        REGISTRY.add((Pair<ResourceLocation, Consumer<StructureTemplatePool>>)new Pair((Object)ResourceLocation.parse((String)"minecraft:village/taiga/houses"), arg_0 -> VillageHouseManager.lambda$addAllHouses$4((StructurePoolElement)taiga, weight, arg_0)));
        try {
            for (ResourceLocation villagePool : VILLAGE_REPLACEMENT_POOLS) {
                StructureTemplatePool pool = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL).getOptional(villagePool).orElse(null);
                if (pool == null) continue;
                for (Pair<ResourceLocation, Consumer<StructureTemplatePool>> pair : REGISTRY) {
                    if (!villagePool.equals(pair.getFirst())) continue;
                    ((Consumer)pair.getSecond()).accept(pool);
                }
            }
        }
        catch (Exception e) {
            PetHomeMod.LOGGER.error("Could not add village houses!");
            PetHomeMod.LOGGER.error(e.toString());
        }
    }

    private static /* synthetic */ void lambda$addAllHouses$4(StructurePoolElement taiga, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool(pool, taiga, weight);
    }

    private static /* synthetic */ void lambda$addAllHouses$3(StructurePoolElement snowy, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool(pool, snowy, weight);
    }

    private static /* synthetic */ void lambda$addAllHouses$2(StructurePoolElement savanna, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool(pool, savanna, weight);
    }

    private static /* synthetic */ void lambda$addAllHouses$1(StructurePoolElement desert, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool(pool, desert, weight);
    }

    private static /* synthetic */ void lambda$addAllHouses$0(StructurePoolElement plains, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool(pool, plains, weight);
    }
}

