/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome;

import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.enchantment.PetEnchantment;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pet_home", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PetHomeConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public final ForgeConfigSpec.BooleanValue trinaryCommandSystem;
    public final ForgeConfigSpec.BooleanValue tameableAxolotl;
    public final ForgeConfigSpec.BooleanValue tameableHorse;
    public final ForgeConfigSpec.BooleanValue tameableFox;
    public final ForgeConfigSpec.BooleanValue tameableRabbit;
    public final ForgeConfigSpec.BooleanValue tameableFrog;
    public final ForgeConfigSpec.BooleanValue swingThroughPets;
    public final ForgeConfigSpec.BooleanValue rottenApple;
    public final ForgeConfigSpec.BooleanValue petBedRespawns;
    public final ForgeConfigSpec.BooleanValue collarTag;
    public final ForgeConfigSpec.BooleanValue rabbitsScareRavagers;
    public final ForgeConfigSpec.BooleanValue animalTamerVillager;
    public final ForgeConfigSpec.IntValue petstoreVillageWeight;
    public final ForgeConfigSpec.BooleanValue petCurseEnchantmentsLootOnly;
    public final ForgeConfigSpec.DoubleValue sinisterCarrotLootChance;
    public final ForgeConfigSpec.DoubleValue bubblingLootChance;
    public final ForgeConfigSpec.DoubleValue vampirismLootChance;
    public final ForgeConfigSpec.DoubleValue voidCloudLootChance;
    public final ForgeConfigSpec.DoubleValue oreScentingLootChance;
    public final ForgeConfigSpec.DoubleValue muffledLootChance;
    public final ForgeConfigSpec.DoubleValue blazingProtectionLootChance;
    private static final ForgeConfigSpec.BooleanValue MOBCATCHER_ONLY_TAMABLE_ANIMAL = BUILDER.comment("Mob catcher only catches tamable animal").define("mobcatcherOnlyTamableAnimal", true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MOBCATCHER_BLACKLIST = BUILDER.comment("entities that can't be caught").defineListAllowEmpty("mobcatcherBlacklist", List.of("minecraft:painting"), PetHomeConfig::validateEntityTypesName);
    private static final ForgeConfigSpec.BooleanValue PROTECT_PETS_FROM_OWNER;
    private static final ForgeConfigSpec.BooleanValue PROTECT_PETS_FROM_PETS;
    private static final ForgeConfigSpec.BooleanValue PROTECT_CHILDREN;
    private static final ForgeConfigSpec.BooleanValue REFLECT_DAMAGE;
    private static final ForgeConfigSpec.BooleanValue DISPLAY_HIT_WARNING;
    private static final ForgeConfigSpec.BooleanValue PROTECT_TEAM_MEMBERS;
    private static final ForgeConfigSpec.BooleanValue RESPECT_TEAM_RULES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> CAN_HURT_PET_ITEM;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> CAN_HURT_ALL_ITEM;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> NO_PROTECTION_ENTITY;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> OTHER_SHOULD_PROTECT_ENTITY;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYER_CANT_HURT_ENTITY;
    private final Map<String, ForgeConfigSpec.BooleanValue> enabledEnchantments = new HashMap<String, ForgeConfigSpec.BooleanValue>();
    public static boolean mobcatcherOnlyTamableAnimal;
    public static Set<EntityType<?>> mobcatcherBlackList;
    public static boolean protectPetsFromPets;
    public static boolean protectChildren;
    public static boolean reflectDamage;
    public static boolean displayHitWarning;
    public static boolean protectPetsFromOwner;
    public static boolean protectTeamMembers;
    public static boolean respectTeamRules;
    public static Set<EntityType<?>> noProtectionEntity;
    public static Set<EntityType<?>> otherShouldProtectionEntity;
    public static Set<EntityType<?>> playerCantHurtEntity;
    public static Set<Item> canHurtPetItem;
    public static Set<Item> canHurtAllItem;

    private static boolean validateEntityTypesName(Object obj) {
        String itemName;
        if (obj instanceof String && BuiltInRegistries.f_256780_.m_7804_(ResourceLocation.parse((String)(itemName = (String)obj)))) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    public PetHomeConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.trinaryCommandSystem = builder.comment("true if wolves, cats, parrots, foxes, axolotls, etc can be set to wander, sit or follow").translation("trinary_command_system").define("trinary_command_system", true);
        this.tameableAxolotl = builder.comment("true if axolotls are fully tameable (axolotl must be tamed with tropical fish)").translation("tameable_axolotls").define("tameable_axolotls", true);
        this.tameableHorse = builder.comment("true if horses, donkeys, llamas, etc can be given enchants, beds, etc").translation("tameable_horse").define("tameable_horse", true);
        this.tameableFox = builder.comment("true if foxes are fully tameable (fox must be tamed via breeding)").translation("tameable_fox").define("tameable_fox", true);
        this.tameableRabbit = builder.comment("true if rabbits are fully tameable (rabbit must be tamed with carrots)").translation("tameable_rabbit").define("tameable_rabbit", true);
        this.tameableFrog = builder.comment("true if frogs are fully tameable (rabbit must be tamed with spider eyes)").translation("tameable_rabbit").define("tameable_frog", true);
        this.swingThroughPets = builder.comment("true if attacks do not register on pets from their owners and go through them to attack a mob behind them").translation("swing_through_pets").define("swing_through_pets", true);
        this.rottenApple = builder.comment("true if apples can turn into rotten apples if they despawn").translation("rotten_apple").define("rotten_apple", true);
        this.petBedRespawns = builder.comment("true if mobs can respawn in pet beds the next morning after they die").translation("pet_bed_respawns").define("pet_bed_respawns", true);
        this.collarTag = builder.comment("true if collar tag functionality are enabled. If this is disabled, there is no way to enchant mobs!").translation("collar_tags").define("collar_tags", true);
        this.rabbitsScareRavagers = builder.comment("true if rabbits scare ravagers like they used to do").translation("rabbits_scare_ravagers").define("rabbits_scare_ravagers", true);
        this.animalTamerVillager = builder.comment("true if animal tamer villagers are enabled. Their work station is a pet bed").translation("animal_tamer_villager").define("animal_tamer_villager", true);
        this.petstoreVillageWeight = builder.comment("the spawn weight of the pet store in villages, set to 0 to disable it entirely").translation("petstore_village_weight").defineInRange("petstore_village_weight", 17, 0, 1000);
        builder.pop();
        builder.push("loot");
        this.petCurseEnchantmentsLootOnly = builder.comment("true if pet curse enchantments should only appear in loot, and not the enchanting table.").translation("pet_curse_enchantments_loot_only").define("pet_curse_enchantments_loot_only", true);
        this.sinisterCarrotLootChance = builder.comment("percent chance of woodland mansion loot table containing sinister carrot:").translation("sinister_carrot_loot_chance").defineInRange("sinister_carrot_loot_chance", 0.3, 0.0, 1.0);
        this.bubblingLootChance = builder.comment("percent chance of burried treasure loot table containing Bubbling book:").translation("bubbling_loot_chance").defineInRange("bubbling_loot_chance", 0.65, 0.0, 1.0);
        this.vampirismLootChance = builder.comment("percent chance of woodland mansion loot table containing Vampire book:").translation("vampirism_loot_chance").defineInRange("vampirism_loot_chance", 0.22, 0.0, 1.0);
        this.voidCloudLootChance = builder.comment("percent chance of end city loot table containing Void Cloud book:").translation("void_cloud_loot_chance").defineInRange("void_cloud_loot_chance", 0.19, 0.0, 1.0);
        this.oreScentingLootChance = builder.comment("percent chance of mineshaft loot table containing Ore Scenting book:").translation("ore_scenting_loot_chance").defineInRange("ore_scenting_loot_chance", 0.15, 0.0, 1.0);
        this.muffledLootChance = builder.comment("percent chance of ancient city loot table containing Muffled book:").translation("muffled_loot_chance").defineInRange("muffled_loot_chance", 0.19, 0.0, 1.0);
        this.blazingProtectionLootChance = builder.comment("percent chance of nether fortress loot table containing Blazing Protection book:").translation("ore_scenting_loot_chance").defineInRange("blazing_protection_loot_chance", 0.2, 0.0, 1.0);
        builder.pop();
        builder.push("enchantments");
        try {
            for (Field f : DIEnchantmentRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof PetEnchantment)) continue;
                String registryName = ((PetEnchantment)((Object)obj)).getName();
                String name = registryName + "_enabled";
                this.enabledEnchantments.put(registryName, builder.comment("true if " + registryName.replace("_", " ") + " enchant is enabled, false if disabled").translation(name).define(name, true));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        builder.pop();
    }

    public boolean isEnchantEnabled(Enchantment enchantment) {
        return enchantment instanceof PetEnchantment && this.isEnchantEnabled(((PetEnchantment)enchantment).getName());
    }

    public boolean isEnchantEnabled(String enchantment) {
        ForgeConfigSpec.BooleanValue entry = this.enabledEnchantments.get(enchantment);
        return entry == null || (Boolean)entry.get() != false;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        mobcatcherBlackList = ((List)MOBCATCHER_BLACKLIST.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        mobcatcherOnlyTamableAnimal = (Boolean)MOBCATCHER_ONLY_TAMABLE_ANIMAL.get();
        respectTeamRules = (Boolean)RESPECT_TEAM_RULES.get();
        protectPetsFromOwner = (Boolean)PROTECT_PETS_FROM_OWNER.get();
        protectChildren = (Boolean)PROTECT_CHILDREN.get();
        protectPetsFromPets = (Boolean)PROTECT_PETS_FROM_PETS.get();
        reflectDamage = (Boolean)REFLECT_DAMAGE.get();
        displayHitWarning = (Boolean)DISPLAY_HIT_WARNING.get();
        protectTeamMembers = (Boolean)PROTECT_TEAM_MEMBERS.get();
        noProtectionEntity = ((List)NO_PROTECTION_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        otherShouldProtectionEntity = ((List)OTHER_SHOULD_PROTECT_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        playerCantHurtEntity = ((List)PLAYER_CANT_HURT_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        canHurtPetItem = ((List)CAN_HURT_PET_ITEM.get()).stream().map(i -> (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.parse((String)i))).collect(Collectors.toSet());
        canHurtAllItem = ((List)CAN_HURT_ALL_ITEM.get()).stream().map(i -> (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.parse((String)i))).collect(Collectors.toSet());
    }

    static {
        BUILDER.push("friendly_fire");
        PROTECT_PETS_FROM_OWNER = BUILDER.comment("owner cannot hurt pet").define("protectPetsFromOwner", true);
        PROTECT_PETS_FROM_PETS = BUILDER.comment("pet cannot hurt pet").define("protectPetsFromPets", true);
        PROTECT_CHILDREN = BUILDER.comment("protect children animal").define("protectChildren", true);
        REFLECT_DAMAGE = BUILDER.comment("protect pet from ownder").define("reflectDamage", false);
        DISPLAY_HIT_WARNING = BUILDER.comment("owner cannot hurt pet").define("displayHitWarning", true);
        PROTECT_TEAM_MEMBERS = BUILDER.comment("PROTECT_TEAM_MEMBERS").define("protectTeamMembers", true);
        RESPECT_TEAM_RULES = BUILDER.comment("RESPECT_TEAM_RULES").define("respectTeamRules", true);
        CAN_HURT_PET_ITEM = BUILDER.comment("can hurt pet item").defineListAllowEmpty("can_hurt_pet_item", List.of(), PetHomeConfig::validateItemName);
        CAN_HURT_ALL_ITEM = BUILDER.comment("can always hurt item").defineListAllowEmpty("can_hurt_all", List.of(), PetHomeConfig::validateItemName);
        NO_PROTECTION_ENTITY = BUILDER.comment("can always hurt").defineListAllowEmpty("no_protection_entity", List.of(), PetHomeConfig::validateEntityTypesName);
        OTHER_SHOULD_PROTECT_ENTITY = BUILDER.comment("other entities that can be protected").defineListAllowEmpty("other_should_protect_entity", List.of(), PetHomeConfig::validateEntityTypesName);
        PLAYER_CANT_HURT_ENTITY = BUILDER.comment("entities player cant hurt").defineListAllowEmpty("player_cant_hurt_entity", List.of(), PetHomeConfig::validateEntityTypesName);
        BUILDER.pop();
        protectPetsFromPets = true;
        protectChildren = true;
        protectPetsFromOwner = true;
        protectTeamMembers = true;
        respectTeamRules = true;
    }
}

