/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.client.model;

import com.github.yzqdev.pethome.client.model.AdvancedEntityModel;
import com.github.yzqdev.pethome.client.model.AdvancedModelBox;
import com.github.yzqdev.pethome.client.model.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ShadowHandModel
extends AdvancedEntityModel<LivingEntity> {
    private final AdvancedModelBox palm;
    private final AdvancedModelBox finger1;
    private final AdvancedModelBox finger2;
    private final AdvancedModelBox finger3;
    private final AdvancedModelBox thumb;

    public ShadowHandModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.palm = new AdvancedModelBox(this);
        this.palm.setRotationPoint(0.0f, 19.0f, 0.0f);
        this.setRotationAngle(this.palm, -0.5672f, 0.0f, 0.0f);
        this.palm.setTextureOffset(0, 0).addBox(-3.0f, -2.5f, -2.0f, 6.0f, 3.0f, 5.0f, 0.0f, false);
        this.finger1 = new AdvancedModelBox(this);
        this.finger1.setRotationPoint(3.0f, 0.0f, -1.0f);
        this.palm.addChild(this.finger1);
        this.setRotationAngle(this.finger1, 0.1745f, -0.3491f, 0.0f);
        this.finger1.setTextureOffset(0, 8).addBox(-2.0f, -2.0f, -6.0f, 2.0f, 2.0f, 7.0f, 0.0f, false);
        this.finger2 = new AdvancedModelBox(this);
        this.finger2.setRotationPoint(0.0f, 0.0f, -2.0f);
        this.palm.addChild(this.finger2);
        this.setRotationAngle(this.finger2, 0.1745f, 0.0f, 0.0f);
        this.finger2.setTextureOffset(14, 10).addBox(-1.0f, -2.0f, -6.7f, 2.0f, 2.0f, 7.0f, 0.0f, false);
        this.finger3 = new AdvancedModelBox(this);
        this.finger3.setRotationPoint(-3.0f, 0.0f, -1.0f);
        this.palm.addChild(this.finger3);
        this.setRotationAngle(this.finger3, 0.1745f, 0.3491f, 0.0f);
        this.finger3.setTextureOffset(14, 19).addBox(0.0f, -2.0f, -6.0f, 2.0f, 2.0f, 7.0f, 0.0f, false);
        this.thumb = new AdvancedModelBox(this);
        this.thumb.setRotationPoint(3.0f, 0.0f, 3.0f);
        this.palm.addChild(this.thumb);
        this.setRotationAngle(this.thumb, 0.1745f, -0.8727f, 0.0f);
        this.thumb.setTextureOffset(1, 17).addBox(-2.0f, -2.0f, -4.0f, 2.0f, 2.0f, 4.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    @Override
    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.palm, (Object)this.finger1, (Object)this.finger2, (Object)this.finger3, (Object)this.thumb);
    }

    @Override
    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.palm);
    }

    public void setupAnim(LivingEntity recallBallEntity, float limbSwing, float limbSwingAmount, float age, float yaw, float pitch) {
        this.resetToDefaultPose();
    }

    public void setRotationAngle(AdvancedModelBox AdvancedModelBox2, float x, float y, float z) {
        AdvancedModelBox2.rotateAngleX = x;
        AdvancedModelBox2.rotateAngleY = y;
        AdvancedModelBox2.rotateAngleZ = z;
    }

    public void animateShadowHand(float punch, int handIndex, int shadowHandCount, float ageInTicks) {
        this.resetToDefaultPose();
        boolean left = (float)handIndex >= (float)shadowHandCount / 2.0f;
        float leftMod = left ? -1.0f : 1.0f;
        punch = Mth.m_14036_((float)punch, (float)0.0f, (float)0.25f) * 4.0f;
        float still = 1.0f - punch;
        if (left) {
            this.thumb.setRotationPoint(-1.5f, 0.0f, 1.5f);
            this.setRotationAngle(this.thumb, 0.1745f, 0.8727f, 0.0f);
        } else {
            this.thumb.setRotationPoint(3.0f, 0.0f, 3.0f);
            this.setRotationAngle(this.thumb, 0.1745f, -0.8727f, 0.0f);
        }
        this.walk(this.palm, leftMod * 0.2f, 0.1f, false, (float)handIndex - 1.0f, 0.0f, ageInTicks, still);
        this.walk(this.finger1, leftMod * 0.2f, 0.2f, false, 1.0f + (float)handIndex, 0.2f, ageInTicks, still);
        this.walk(this.finger2, leftMod * 0.2f, 0.2f, false, 3.0f + (float)handIndex, 0.2f, ageInTicks, still);
        this.walk(this.finger3, leftMod * 0.2f, 0.2f, false, 5.0f + (float)handIndex, 0.2f, ageInTicks, still);
        this.swing(this.thumb, leftMod * 0.2f, 0.2f, false, 5.0f + (float)handIndex, leftMod * -0.2f, ageInTicks, still);
        this.progressRotationPrev(this.finger1, punch, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.finger2, punch, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.finger3, punch, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
        this.progressRotation(this.palm, punch, 0.0f, 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.thumb, punch, (float)Math.toRadians(90.0), 0.0f, (float)Math.toRadians(30.0) * leftMod, 1.0f);
        this.progressPositionPrev(this.finger1, punch, 0.0f, -2.0f, 0.5f, 1.0f);
        this.progressPositionPrev(this.finger2, punch, 0.0f, -2.0f, 0.5f, 1.0f);
        this.progressPositionPrev(this.finger3, punch, 0.0f, -2.0f, 0.5f, 1.0f);
        this.progressPositionPrev(this.thumb, punch, leftMod * 2.0f, -2.0f, -1.0f, 1.0f);
        this.progressPositionPrev(this.palm, punch, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

