/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.mixin;

import com.github.yzqdev.pethome.PetHomeMod;
import com.github.yzqdev.pethome.server.entity.IComandableMob;
import com.github.yzqdev.pethome.server.entity.IFrog;
import com.github.yzqdev.pethome.server.entity.ModifedToBeTameable;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.github.yzqdev.pethome.server.misc.DITagRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Frog.class})
public abstract class FrogMixin
extends Animal
implements ModifedToBeTameable,
IComandableMob,
IFrog {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean hasInitialDamage = false;

    protected FrogMixin(EntityType<? extends Animal> type, Level lvl) {
        super(type, lvl);
    }

    @Shadow
    public abstract Brain<Frog> m_6274_();

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/frog/Frog;defineSynchedData()V"})
    private void di_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/frog/Frog;tick()V"}, at={@At(value="TAIL")}, remap=true)
    private void di_tick(CallbackInfo ci) {
        if (!this.hasInitialDamage && this.isTame()) {
            this.hasInitialDamage = true;
            this.m_21051_(Attributes.f_22281_).m_22100_(3.0);
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/frog/Frog;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.m_128405_("DICommand", this.getCommand());
        compoundNBT.m_128379_("Tamed", this.isTame());
        if (this.getTameOwnerUUID() != null) {
            compoundNBT.m_128362_("Owner", this.getTameOwnerUUID());
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/frog/Frog;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        UUID uuid;
        this.setCommand(compoundNBT.m_128451_("DICommand"));
        this.setTame(compoundNBT.m_128471_("Tamed"));
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setTameOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    private void spawnTamingParticles(boolean smoke) {
        if (!this.m_9236_().f_46443_) {
            SimpleParticleType particleoptions = smoke ? ParticleTypes.f_123762_ : ParticleTypes.f_123750_;
            for (int i = 0; i < 7; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 3, d0, d1, d2, (double)0.03f);
            }
        }
    }

    @Override
    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    @Override
    public void setCommand(int i) {
        this.f_19804_.m_135381_(COMMAND, (Object)i);
    }

    @Override
    public boolean isTame() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    @Override
    public void setTame(boolean b) {
        this.f_19804_.m_135381_(TAMED, (Object)b);
    }

    @Override
    @Nullable
    public UUID getTameOwnerUUID() {
        return (Boolean)PetHomeMod.CONFIG.tameableFrog.get() != false ? (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null) : null;
    }

    @Override
    public void setTameOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public LivingEntity getTameOwner() {
        try {
            UUID uuid = this.getTameOwnerUUID();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public boolean isFollowingOwner() {
        return this.getCommand() == 2 && (Boolean)PetHomeMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isStayingStill() {
        return this.getCommand() == 1 && (Boolean)PetHomeMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isValidAttackTarget(LivingEntity target) {
        if (this.m_7307_((Entity)target)) {
            return false;
        }
        if (this.getTameOwner() != null && this.getTameOwner().m_21214_() != null && this.getTameOwner().m_21214_().equals((Object)target)) {
            return !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)target) && !this.m_7307_((Entity)target);
        }
        if (this.getTameOwner() != null && this.getTameOwner().m_21188_() != null && this.getTameOwner().m_21188_().equals((Object)target)) {
            return !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)target) && !this.m_7307_((Entity)target);
        }
        return false;
    }

    @Override
    public void sendCommandMessage(Player owner, int command, Component name) {
        owner.m_5661_((Component)Component.m_237110_((String)("message.pet_home.command_" + command), (Object[])new Object[]{name}), true);
    }

    private boolean isTamingItem(ItemStack stack) {
        return stack.m_204117_(DITagRegistry.TAME_FROGS_WITH);
    }

    @Override
    public boolean onFrogInteract(Player player, InteractionHand hand) {
        if (((Boolean)PetHomeMod.CONFIG.tameableFrog.get()).booleanValue()) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!this.isTame() && this.isTamingItem(itemStack)) {
                this.m_142075_(player, hand, itemStack);
                this.m_5634_(2.0f);
                this.m_5496_(SoundEvents.f_215692_, this.m_6121_(), this.m_6100_());
                if (!this.m_9236_().f_46443_) {
                    if (this.m_217043_().m_188503_(4) == 0) {
                        this.spawnTamingParticles(true);
                    } else {
                        this.spawnTamingParticles(false);
                        this.setTame(true);
                        this.setTameOwnerUUID(player.m_20148_());
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                        }
                    }
                }
                return true;
            }
            if (this.isTame() && itemStack.m_41720_() != Items.f_42447_) {
                if ((this.isTamingItem(itemStack) || itemStack.m_150930_(Items.f_42518_)) && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(2.0f);
                    this.m_5496_(SoundEvents.f_215692_, this.m_6121_(), this.m_6100_());
                    return true;
                }
                if (((Boolean)PetHomeMod.CONFIG.trinaryCommandSystem.get()).booleanValue()) {
                    player.m_21011_(hand, true);
                    this.playerSetCommand(player, this);
                    return false;
                }
            }
        }
        return false;
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/frog/Frog;customServerAiStep()V"})
    private void di_customServerAiStep(CallbackInfo ci) {
        if (this.isTame() && this.getTameOwner() != null) {
            if (this.getTameOwner().m_21214_() != null && this.getTameOwner().m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)this.getTameOwner().m_21214_())) {
                this.m_6710_(this.getTameOwner().m_21214_());
                this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)this.getTameOwner().m_21214_());
            }
            if (this.getTameOwner().m_21188_() != null && this.getTameOwner().m_21188_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)this.getTameOwner().m_21188_())) {
                this.m_6710_(this.getTameOwner().m_21188_());
                this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)this.getTameOwner().m_21188_());
            }
        }
    }
}

