/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.mixin;

import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.github.yzqdev.pethome.server.entity.ai.AmphibiousPathNavigation;
import com.github.yzqdev.pethome.server.entity.ai.AquaticMoveControl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    @Shadow
    protected MoveControl f_21342_;
    @Shadow
    protected PathNavigation f_21344_;
    private boolean hasWaterEnchantNavigator = false;
    private MoveControl prevMoveControl;
    private PathNavigation prevNavigation;

    @Shadow
    public abstract void m_21441_(BlockPathTypes var1, float var2);

    protected MobMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick()V"}, remap=true, at={@At(value="TAIL")})
    private void di_tick(CallbackInfo ci) {
        if (TameableUtils.isTamed((Entity)this) && !this.m_9236_().f_46443_) {
            if (TameableUtils.hasEnchant(this, DIEnchantmentRegistry.AMPHIBIOUS) && !(this instanceof Axolotl)) {
                if (!this.hasWaterEnchantNavigator && this.m_20072_()) {
                    this.m_21441_(BlockPathTypes.WATER, 0.0f);
                    this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
                    this.prevMoveControl = this.f_21342_;
                    this.prevNavigation = this.f_21344_;
                    this.f_21342_ = new AquaticMoveControl((Mob)this);
                    this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
                    this.hasWaterEnchantNavigator = true;
                }
                if (this.hasWaterEnchantNavigator && !this.m_20072_()) {
                    this.f_21342_ = this.prevMoveControl;
                    this.f_21344_ = this.prevNavigation;
                    this.hasWaterEnchantNavigator = false;
                }
            } else if (this.hasWaterEnchantNavigator) {
                this.f_21342_ = this.prevMoveControl;
                this.f_21344_ = this.prevNavigation;
                this.hasWaterEnchantNavigator = false;
            }
        }
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private void di_pickUpItem(ItemEntity item, CallbackInfo ci) {
        Entity owner;
        if (TameableUtils.isTamed((Entity)this) && TameableUtils.hasEnchant(this, DIEnchantmentRegistry.LINKED_INVENTORY) && (owner = TameableUtils.getOwnerOf((Entity)this)) instanceof Player) {
            ci.cancel();
            if (((Player)owner).m_36356_(item.m_32055_())) {
                item.m_146870_();
            } else {
                item.m_20359_(owner);
            }
        }
    }

    @Inject(method={"playAmbientSound()V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private void di_playAmbientSound(CallbackInfo ci) {
        if (TameableUtils.isTamed((Entity)this) && TameableUtils.hasEnchant(this, DIEnchantmentRegistry.MUFFLED)) {
            ci.cancel();
        }
    }
}

