/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.network;

import com.github.yzqdev.pethome.ModConstants;
import com.github.yzqdev.pethome.network.Networking;
import com.github.yzqdev.pethome.network.PacketBufferUtils;
import com.github.yzqdev.pethome.server.entity.CitadelEntityData;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PropertiesMessage {
    private String propertyID;
    private CompoundTag compound;
    private int entityID;

    public PropertiesMessage(String propertyID, CompoundTag compound, int entityID) {
        this.propertyID = propertyID;
        this.compound = compound;
        this.entityID = entityID;
    }

    public static void write(PropertiesMessage message, FriendlyByteBuf packetBuffer) {
        PacketBufferUtils.writeUTF8String((ByteBuf)packetBuffer, message.propertyID);
        PacketBufferUtils.writeTag((ByteBuf)packetBuffer, message.compound);
        packetBuffer.writeInt(message.entityID);
    }

    public static PropertiesMessage read(FriendlyByteBuf packetBuffer) {
        return new PropertiesMessage(PacketBufferUtils.readUTF8String((ByteBuf)packetBuffer), PacketBufferUtils.readTag((ByteBuf)packetBuffer), packetBuffer.readInt());
    }

    public static class Handler {
        public static void handle(PropertiesMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Networking.PROXY.handlePropertiesPacket(message.propertyID, message.compound, message.entityID);
                } else {
                    Entity e = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(message.entityID);
                    if (e instanceof LivingEntity && message.propertyID.equals(ModConstants.entityDataTagUpdate)) {
                        CitadelEntityData.setCitadelTag((LivingEntity)e, message.compound);
                    }
                }
            });
        }
    }
}

