/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server;

import com.github.yzqdev.pethome.PetHomeMod;
import com.github.yzqdev.pethome.server.block.DIBlockRegistry;
import com.github.yzqdev.pethome.server.block.PetBedBlock;
import com.github.yzqdev.pethome.server.block.PetBedBlockEntity;
import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.entity.ChainLightningEntity;
import com.github.yzqdev.pethome.server.entity.DIVillagerRegistry;
import com.github.yzqdev.pethome.server.entity.FollowingJukeboxEntity;
import com.github.yzqdev.pethome.server.entity.GiantBubbleEntity;
import com.github.yzqdev.pethome.server.entity.IComandableMob;
import com.github.yzqdev.pethome.server.entity.ModifedToBeTameable;
import com.github.yzqdev.pethome.server.entity.PHEntityRegistry;
import com.github.yzqdev.pethome.server.entity.PsychicWallEntity;
import com.github.yzqdev.pethome.server.entity.RecallBallEntity;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.github.yzqdev.pethome.server.item.DeedOfOwnershipItem;
import com.github.yzqdev.pethome.server.item.PHItemRegistry;
import com.github.yzqdev.pethome.server.misc.CollarTickTracker;
import com.github.yzqdev.pethome.server.misc.DIDamageTypes;
import com.github.yzqdev.pethome.server.misc.DIParticleRegistry;
import com.github.yzqdev.pethome.server.misc.DISoundRegistry;
import com.github.yzqdev.pethome.server.misc.DITagRegistry;
import com.github.yzqdev.pethome.server.misc.DIVillagePieceRegistry;
import com.github.yzqdev.pethome.server.misc.DIWorldData;
import com.github.yzqdev.pethome.server.misc.LanternRequest;
import com.github.yzqdev.pethome.server.misc.RespawnRequest;
import com.github.yzqdev.pethome.server.misc.trades.BuyingItemTrade;
import com.github.yzqdev.pethome.server.misc.trades.EnchantBookForEmeraldsWithoutPet;
import com.github.yzqdev.pethome.server.misc.trades.EnchantItemTrade;
import com.github.yzqdev.pethome.server.misc.trades.SellingItemTrade;
import com.github.yzqdev.pethome.server.misc.trades.SellingRandomEnchantedBook;
import com.github.yzqdev.pethome.util.FriendlyFireCommon;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.antlr.v4.runtime.misc.Triple;

@Mod.EventBusSubscriber(modid="pet_home", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    private static final UUID FROST_FANG_SLOW = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4cf");
    private static final TargetingConditions ZOMBIE_TARGET = TargetingConditions.m_148352_().m_26883_(32.0);
    public static List<Triple<Entity, ServerLevel, UUID>> teleportingPets = new ArrayList<Triple<Entity, ServerLevel, UUID>>();
    private static final Map<Level, CollarTickTracker> COLLAR_TICK_TRACKER_MAP = new HashMap<Level, CollarTickTracker>();

    public void init(FMLJavaModLoadingContext context) {
    }

    public void serverInit() {
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"pet_home", this::removeAllChunkTickets);
        DIVillagePieceRegistry.registerHouses();
    }

    private void removeAllChunkTickets(ServerLevel serverLevel, ForgeChunkManager.TicketHelper ticketHelper) {
        int i = 0;
        for (Map.Entry entry : ticketHelper.getEntityTickets().entrySet()) {
            ticketHelper.removeAllTickets((UUID)entry.getKey());
            ++i;
        }
        PetHomeMod.LOGGER.debug("Removed " + i + " chunkloading tickets");
    }

    public void clientInit() {
    }

    public void updateVisualDataForMob(Entity entity, int[] arr) {
    }

    public void updateEntityStatus(Entity entity, byte updateKind) {
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && TameableUtils.couldBeTamed((Entity)(living = (LivingEntity)entity))) {
            DIWorldData data;
            if (TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALTH_BOOST)) {
                living.m_21153_((float)Math.max((double)living.m_21223_(), TameableUtils.getSafePetHealth(living)));
            }
            if (living.m_6084_() && TameableUtils.isTamed((Entity)living) && (data = DIWorldData.get(living.m_9236_())) != null) {
                data.removeMatchingLanternRequests(living.m_20148_());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.m_9236_().f_46443_ && living.m_6084_() && TameableUtils.isTamed((Entity)living) && TameableUtils.shouldUnloadToLantern(living)) {
                UUID ownerUUID = TameableUtils.getOwnerUUIDOf(event.getEntity());
                String saveName = event.getEntity().m_8077_() ? event.getEntity().m_7770_().getString() : "";
                DIWorldData data = DIWorldData.get(living.m_9236_());
                if (data != null) {
                    LanternRequest request = new LanternRequest(living.m_20148_(), ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString(), ownerUUID, living.m_20183_(), event.getEntity().m_9236_().m_8044_(), saveName);
                    data.addLanternRequest(request);
                }
            }
            if (TameableUtils.couldBeTamed((Entity)living) && TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALTH_BOOST)) {
                TameableUtils.setSafePetHealth(living, living.m_21223_());
            }
        }
    }

    private boolean canTickCollar(Entity entity) {
        if (entity.m_9236_().f_46443_) {
            return true;
        }
        CollarTickTracker tracker = COLLAR_TICK_TRACKER_MAP.get(entity.m_9236_());
        return tracker == null || !tracker.isEntityBlocked(entity);
    }

    private void blockCollarTick(Entity entity) {
        CollarTickTracker tracker;
        if (!entity.m_9236_().f_46443_ && (tracker = COLLAR_TICK_TRACKER_MAP.get(entity.m_9236_())) == null) {
            tracker.addBlockedEntityTick(entity.m_20148_(), 5);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent tick) {
        if (!tick.level.f_46443_) {
            COLLAR_TICK_TRACKER_MAP.computeIfAbsent(tick.level, k -> new CollarTickTracker());
            CollarTickTracker tracker = COLLAR_TICK_TRACKER_MAP.get(tick.level);
            tracker.tick();
        }
        if (!tick.level.f_46443_ && tick.level instanceof ServerLevel) {
            for (Triple<Entity, ServerLevel, UUID> triple : teleportingPets) {
                Entity entity = (Entity)triple.a;
                ServerLevel endpointWorld = (ServerLevel)triple.b;
                UUID ownerUUID = (UUID)triple.c;
                entity.m_19877_();
                entity.m_284535_((Level)endpointWorld);
                Player player = endpointWorld.m_46003_(ownerUUID);
                if (player == null) continue;
                Entity teleportedEntity = entity.m_6095_().m_20615_((Level)endpointWorld);
                if (teleportedEntity != null) {
                    teleportedEntity.m_20361_(entity);
                    Vec3 toPos = player.m_20182_();
                    EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
                    AABB suffocationBox = new AABB((double)(-dimensions.f_20377_ / 2.0f), 0.0, (double)(-dimensions.f_20377_ / 2.0f), (double)(dimensions.f_20377_ / 2.0f), (double)dimensions.f_20378_, (double)(dimensions.f_20377_ / 2.0f));
                    while (!endpointWorld.m_45756_(entity, suffocationBox.m_82386_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_)) && toPos.f_82480_ < 300.0) {
                        toPos = toPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    teleportedEntity.m_7678_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_, entity.m_146908_(), entity.m_146909_());
                    teleportedEntity.m_5616_(entity.m_6080_());
                    teleportedEntity.f_19789_ = 0.0f;
                    teleportedEntity.m_20091_();
                    endpointWorld.m_7967_(teleportedEntity);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            teleportingPets.clear();
        }
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            Player player;
            Entity hit = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
            if (event.getProjectile().m_19749_() instanceof Player && TameableUtils.isPetOf(player = (Player)event.getProjectile().m_19749_(), hit)) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
            if (TameableUtils.isTamed(hit)) {
                AbstractArrow arrow;
                Entity entity = event.getEntity();
                if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
                    arrow.m_36767_((byte)0);
                    arrow.m_142687_(Entity.RemovalReason.DISCARDED);
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    return;
                }
                if (TameableUtils.hasEnchant((LivingEntity)hit, DIEnchantmentRegistry.DEFLECTION)) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    float xRot = event.getProjectile().m_146909_();
                    float yRot = event.getProjectile().f_19859_;
                    Vec3 vec3 = event.getProjectile().m_20182_().m_82546_(hit.m_20182_()).m_82541_().m_82490_((double)(hit.m_20205_() + 0.5f));
                    Vec3 vec32 = hit.m_20182_().m_82549_(vec3);
                    hit.m_9236_().m_7106_((ParticleOptions)DIParticleRegistry.DEFLECTION_SHIELD.get(), vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (double)xRot, (double)yRot, 0.0);
                    event.getProjectile().m_20256_(event.getProjectile().m_20184_().m_82490_(-0.2));
                    event.getProjectile().m_146922_(yRot + 180.0f);
                    event.getProjectile().m_146926_(xRot + 180.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemDespawnEvent(ItemExpireEvent event) {
        if (event.getEntity().m_32055_().m_41720_() == Items.f_42410_ && ((Boolean)PetHomeMod.CONFIG.rottenApple.get()).booleanValue()) {
            Random random = new Random();
            if (random.nextFloat() < 0.1f * (float)event.getEntity().m_32055_().m_41613_()) {
                event.getEntity().m_32055_().m_41774_(1);
                event.setExtraLife(10);
                ItemEntity rotten = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)PHItemRegistry.ROTTEN_APPLE.get()));
                event.getEntity().m_9236_().m_7967_((Entity)rotten);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        int frozenTime = TameableUtils.getFrozenTime(event.getEntity());
        if (TameableUtils.couldBeTamed((Entity)event.getEntity()) && this.canTickCollar((Entity)event.getEntity())) {
            int bars;
            int psychicWallLevel;
            LivingEntity targetX2;
            int oreLvl;
            int shepherdLvl;
            LivingEntity follower2;
            UUID uuid;
            LivingEntity punchingTarget;
            Mob mob;
            LivingEntity move2;
            int shadowHandsLevel;
            LivingEntity livingEntity;
            int i;
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.IMMUNITY_FRAME) && !event.getEntity().m_9236_().f_46443_ && (i = TameableUtils.getImmuneTime(event.getEntity())) > 0) {
                TameableUtils.setImmuneTime(event.getEntity(), i - 1);
            }
            if (event.getEntity().m_21023_(MobEffects.f_19614_) && TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.POISON_RESISTANCE)) {
                event.getEntity().m_21195_(MobEffects.f_19614_);
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.AMPHIBIOUS)) {
                event.getEntity().m_20301_(event.getEntity().m_6062_());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.MAGNETIC) && (livingEntity = event.getEntity()) instanceof Mob) {
                Mob mob2 = (Mob)livingEntity;
                Entity sucking = TameableUtils.getPetAttackTarget((LivingEntity)mob2);
                if (!mob2.m_9236_().f_46443_) {
                    if (mob2.m_5448_() == null || !mob2.m_5448_().m_6084_() || mob2.m_20270_((Entity)mob2.m_5448_()) < 0.5f + mob2.m_20205_() || mob2.m_20201_() instanceof GiantBubbleEntity) {
                        if (TameableUtils.getPetAttackTargetID((LivingEntity)mob2) != -1) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob2, -1);
                        }
                    } else {
                        TameableUtils.setPetAttackTarget((LivingEntity)mob2, mob2.m_5448_().m_19879_());
                    }
                } else if (sucking != null) {
                    double dist = mob2.m_20270_(sucking);
                    Vec3 start = mob2.m_20182_().m_82520_(0.0, (double)(mob2.m_20206_() * 0.5f), 0.0);
                    Vec3 end = sucking.m_20182_().m_82520_(0.0, (double)(sucking.m_20206_() * 0.5f), 0.0).m_82546_(start);
                    for (float distStep = mob2.m_20205_() + 0.8f; distStep < (float)((int)Math.ceil(dist)); distStep += 1.0f) {
                        Vec3 vec3 = start.m_82549_(end.m_82490_((double)distStep / dist));
                        float f1 = 0.5f * (mob2.m_217043_().m_188501_() - 0.5f);
                        float f2 = 0.5f * (mob2.m_217043_().m_188501_() - 0.5f);
                        float f3 = 0.5f * (mob2.m_217043_().m_188501_() - 0.5f);
                        mob2.m_9236_().m_7106_((ParticleOptions)DIParticleRegistry.MAGNET.get(), vec3.f_82479_ + (double)f1, vec3.f_82480_ + (double)f2, vec3.f_82481_ + (double)f3, 0.0, 0.0, 0.0);
                    }
                }
                if (sucking != null) {
                    if (mob2.f_19797_ % 15 == 0) {
                        mob2.m_5496_((SoundEvent)DISoundRegistry.MAGNET_LOOP.get(), 1.0f, 1.0f);
                    }
                    mob2.m_20256_(mob2.m_20184_().m_82542_(0.88, 1.0, 0.88));
                    Vec3 move2 = new Vec3(mob2.m_20185_() - sucking.m_20185_(), mob2.m_20186_() - (double)sucking.m_20192_() / 2.0 - sucking.m_20186_(), mob2.m_20189_() - sucking.m_20189_());
                    sucking.m_20256_(sucking.m_20184_().m_82549_(move2.m_82541_().m_82490_(mob2.m_20096_() ? 0.15 : 0.05)));
                }
            }
            if ((shadowHandsLevel = TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.SHADOW_HANDS)) > 0 && (move2 = event.getEntity()) instanceof Mob) {
                mob = (Mob)move2;
                PetHomeMod.PROXY.updateVisualDataForMob((Entity)event.getEntity(), TameableUtils.getShadowPunchTimes((LivingEntity)mob));
                if (!mob.m_9236_().f_46443_) {
                    Entity targetEntity = TameableUtils.getPetAttackTarget((LivingEntity)mob);
                    Entity punching = targetEntity instanceof Player || targetEntity instanceof TamableAnimal ? null : targetEntity;
                    int[] punchProgress = TameableUtils.getShadowPunchTimes((LivingEntity)mob);
                    if (punching != null && punching.m_6084_() && mob.m_142582_(punching) && mob.m_20270_(punching) < 16.0f) {
                        int[] striking = TameableUtils.getShadowPunchStriking((LivingEntity)mob);
                        if (punchProgress == null || punchProgress.length < shadowHandsLevel) {
                            int[] clean = new int[shadowHandsLevel];
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, clean);
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, clean);
                        } else {
                            int cooldown = TameableUtils.getShadowPunchCooldown((LivingEntity)mob);
                            if (cooldown <= 0) {
                                int start;
                                boolean flag = false;
                                for (int i2 = start = shadowHandsLevel == 1 ? 0 : mob.m_217043_().m_188503_(shadowHandsLevel - 1); i2 < shadowHandsLevel; ++i2) {
                                    if (striking[i2] != 0) continue;
                                    striking[i2] = 1;
                                    flag = true;
                                    break;
                                }
                                if (flag) {
                                    TameableUtils.setShadowPunchCooldown((LivingEntity)mob, 5);
                                }
                            } else {
                                TameableUtils.setShadowPunchCooldown((LivingEntity)mob, cooldown - 1);
                            }
                            for (int i3 = 0; i3 < Math.min(shadowHandsLevel, Math.min(striking.length, punchProgress.length)); ++i3) {
                                if (striking[i3] != 0) {
                                    if (punchProgress[i3] < 10) {
                                        punchProgress[i3] = punchProgress[i3] + 1;
                                    } else {
                                        punching.m_6469_(punching.m_269291_().m_269333_((LivingEntity)mob), (float)Mth.m_14045_((int)shadowHandsLevel, (int)2, (int)4));
                                        striking[i3] = 0;
                                    }
                                }
                                if (striking[i3] != 0 || punchProgress[i3] <= 0) continue;
                                punchProgress[i3] = punchProgress[i3] - 1;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, striking);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, punchProgress);
                        }
                    } else {
                        if (punching != null) {
                            boolean flag = true;
                            for (int i4 = 0; i4 < Math.min(shadowHandsLevel, punchProgress.length); ++i4) {
                                if (punchProgress[i4] <= 0) continue;
                                punchProgress[i4] = punchProgress[i4] - 1;
                                flag = false;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, new int[shadowHandsLevel]);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, punchProgress);
                            if (flag) {
                                TameableUtils.setPetAttackTarget((LivingEntity)mob, -1);
                            }
                        }
                        punchingTarget = null;
                        if (mob.m_5448_() != null) {
                            punchingTarget = mob.m_5448_();
                        } else {
                            Entity i3 = TameableUtils.getOwnerOf((Entity)mob);
                            if (i3 instanceof LivingEntity) {
                                LivingEntity owner = (LivingEntity)i3;
                                if (owner.m_21188_() != null && owner.m_21188_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob, (Entity)owner.m_21188_())) {
                                    punchingTarget = owner.m_21188_();
                                }
                                if (owner.m_21214_() != null && owner.m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob, (Entity)owner.m_21214_())) {
                                    punchingTarget = owner.m_21214_();
                                }
                            }
                        }
                        if (punchingTarget != null && punchingTarget.m_6084_()) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob, punchingTarget.m_19879_());
                        }
                    }
                }
            }
            if (!(!TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.DISK_JOCKEY) || event.getEntity().m_9236_().f_46443_ || event.getEntity().f_19797_ % 10 != 0 || (uuid = TameableUtils.getPetJukeboxUUID(event.getEntity())) != null && ((ServerLevel)event.getEntity().m_9236_()).m_8791_(uuid) instanceof FollowingJukeboxEntity)) {
                FollowingJukeboxEntity follower2 = (FollowingJukeboxEntity)((EntityType)PHEntityRegistry.FOLLOWING_JUKEBOX.get()).m_20615_(event.getEntity().m_9236_());
                follower2.setFollowingUUID(event.getEntity().m_20148_());
                follower2.m_20359_((Entity)event.getEntity());
                event.getEntity().m_9236_().m_7967_((Entity)follower2);
                TameableUtils.setPetJukeboxUUID(event.getEntity(), follower2.m_20148_());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.LINKED_INVENTORY) && (follower2 = event.getEntity()) instanceof Mob && !(mob = (Mob)follower2).m_21531_()) {
                mob.m_21553_(true);
            }
            if ((shepherdLvl = TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.SHEPHERD)) > 0) {
                TameableUtils.attractAnimals(event.getEntity(), shepherdLvl * 3);
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.INFAMY_CURSE)) {
                TameableUtils.aggroRandomMonsters(event.getEntity());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.INTIMIDATION)) {
                TameableUtils.scareRandomMonsters(event.getEntity(), TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.INTIMIDATION));
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.BLIGHT_CURSE)) {
                TameableUtils.destroyRandomPlants(event.getEntity());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.REJUVENATION)) {
                TameableUtils.absorbExpOrbs(event.getEntity());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.XP_Transfer)) {
                TameableUtils.xpTransfer(event.getEntity());
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.VOID_CLOUD) && !event.getEntity().m_20072_() && event.getEntity().f_19789_ > 3.0f && !event.getEntity().m_20096_()) {
                double targetZ;
                Entity owner = TameableUtils.getOwnerOf((Entity)event.getEntity());
                boolean shouldMoveToOwnerXZ = owner != null && Math.abs(owner.m_20186_() - event.getEntity().m_20186_()) < 1.0;
                double targetX2 = shouldMoveToOwnerXZ ? owner.m_20185_() : event.getEntity().m_20185_();
                double targetY = Math.max((double)((float)event.getEntity().m_9236_().m_141937_() + 0.5f), owner == null ? 64.0 : (owner.m_20186_() < event.getEntity().m_20186_() ? owner.m_20186_() + (double)0.6f : owner.m_20227_(1.0) + (double)event.getEntity().m_20206_()));
                if (owner != null && owner.m_20201_() == event.getEntity()) {
                    targetY = Math.min((double)((float)event.getEntity().m_9236_().m_141937_() + 0.5f), event.getEntity().m_20186_() - 0.5);
                }
                double d = targetZ = shouldMoveToOwnerXZ ? owner.m_20189_() : event.getEntity().m_20189_();
                if (event.getEntity().f_19863_) {
                    event.getEntity().m_6853_(true);
                    targetX2 += (double)((event.getEntity().m_217043_().m_188501_() - 0.5f) * 4.0f);
                    targetZ += (double)((event.getEntity().m_217043_().m_188501_() - 0.5f) * 4.0f);
                }
                Vec3 move3 = new Vec3(targetX2 - event.getEntity().m_20185_(), targetY - event.getEntity().m_20186_(), targetZ - event.getEntity().m_20189_());
                event.getEntity().m_20256_(event.getEntity().m_20184_().m_82549_(move3.m_82541_().m_82490_(0.15)).m_82542_(0.5, 0.5, 0.5));
                if (event.getEntity().m_9236_() instanceof ServerLevel) {
                    TameableUtils.setFallDistance(event.getEntity(), event.getEntity().f_19789_);
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123789_, event.getEntity().m_20208_(1.5), event.getEntity().m_20186_() - (double)event.getEntity().m_217043_().m_188501_(), event.getEntity().m_20262_(1.5), 0, 0.0, (double)-0.2f, 0.0, 1.0);
                }
            }
            if ((oreLvl = TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.ORE_SCENTING)) > 0 && !event.getEntity().m_9236_().f_46443_) {
                int interval = 100 + Math.max(150, 550 - oreLvl * 100);
                TameableUtils.detectRandomOres(event.getEntity(), interval, 5 + oreLvl * 2, oreLvl * 50, oreLvl * 3);
            }
            if (TameableUtils.isZombiePet(event.getEntity()) && !event.getEntity().m_9236_().f_46443_ && (targetX2 = event.getEntity()) instanceof Mob) {
                Mob mob3 = (Mob)targetX2;
                if (mob3.m_5448_() instanceof Player && ((Player)mob3.m_5448_()).m_7500_()) {
                    mob3.m_6710_(null);
                }
                if (mob3.m_5448_() == null || !mob3.m_5448_().m_6084_()) {
                    mob3.m_6710_((LivingEntity)mob3.m_9236_().m_45946_(ZOMBIE_TARGET, (LivingEntity)mob3));
                } else if (mob3.m_20270_((Entity)mob3.m_5448_()) < mob3.m_20205_() + 0.5f) {
                    mob3.m_7327_((Entity)mob3.m_5448_());
                } else if (mob3.m_21573_().m_26571_()) {
                    mob3.m_21573_().m_5624_((Entity)mob3.m_5448_(), 1.0);
                }
            }
            if ((psychicWallLevel = TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.PSYCHIC_WALL)) > 0 && (punchingTarget = event.getEntity()) instanceof Mob) {
                Mob mob4 = (Mob)punchingTarget;
                if (!event.getEntity().m_9236_().f_46443_) {
                    int cooldown = TameableUtils.getPsychicWallCooldown((LivingEntity)mob4);
                    if (cooldown > 0) {
                        TameableUtils.setPsychicWallCooldown((LivingEntity)mob4, cooldown - 1);
                    } else {
                        LivingEntity blocking = null;
                        Mob blockingFrom = null;
                        if (mob4.m_5448_() != null) {
                            blocking = mob4.m_5448_();
                            blockingFrom = mob4;
                        } else {
                            Entity i2 = TameableUtils.getOwnerOf((Entity)mob4);
                            if (i2 instanceof LivingEntity) {
                                LivingEntity owner = (LivingEntity)i2;
                                if (owner.m_21188_() != null && owner.m_21188_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob4, (Entity)owner.m_21188_())) {
                                    blocking = owner.m_21188_();
                                    blockingFrom = owner;
                                }
                                if (owner.m_21214_() != null && owner.m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob4, (Entity)owner.m_21214_())) {
                                    blocking = owner.m_21214_();
                                    blockingFrom = owner;
                                }
                            }
                        }
                        if (blocking != null) {
                            int width = psychicWallLevel + 1;
                            float yAdditional = blocking.m_20206_() * 0.5f + (float)width * 0.5f;
                            Vec3 vec3 = blockingFrom.m_20182_().m_82520_(0.0, (double)yAdditional, 0.0);
                            Vec3 vec32 = blocking.m_20182_().m_82520_(0.0, (double)yAdditional, 0.0);
                            Vec3 vec33 = vec3.m_82549_(vec32);
                            Vec3 avg = new Vec3(vec33.f_82479_ / 2.0, Math.floor(vec33.f_82480_ / 2.0), vec33.f_82481_ / 2.0);
                            Vec3 rotationFrom = avg.m_82546_(vec3);
                            Direction dir = Direction.m_122366_((double)rotationFrom.f_82479_, (double)rotationFrom.f_82480_, (double)rotationFrom.f_82481_);
                            PsychicWallEntity wall = (PsychicWallEntity)((EntityType)PHEntityRegistry.PSYCHIC_WALL.get()).m_20615_(mob4.m_9236_());
                            wall.m_6034_(avg.f_82479_, avg.f_82480_, avg.f_82481_);
                            wall.setBlockWidth(width);
                            wall.setCreatorId(mob4.m_20148_());
                            wall.setLifespan(psychicWallLevel * 100);
                            wall.setWallDirection(dir);
                            mob4.m_9236_().m_7967_((Entity)wall);
                            TameableUtils.setPsychicWallCooldown((LivingEntity)mob4, psychicWallLevel * 200 + 40);
                        }
                    }
                }
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.BLAZING_PROTECTION) && !event.getEntity().m_9236_().f_46443_ && (bars = TameableUtils.getBlazingProtectionBars(event.getEntity())) < 2 * TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.BLAZING_PROTECTION)) {
                int cooldown = TameableUtils.getBlazingProtectionCooldown(event.getEntity());
                if (cooldown > 0) {
                    --cooldown;
                } else {
                    TameableUtils.setBlazingProtectionBars(event.getEntity(), bars + 1);
                    cooldown = 200;
                }
                TameableUtils.setBlazingProtectionCooldown(event.getEntity(), cooldown);
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.HEALING_AURA) && !event.getEntity().m_9236_().f_46443_) {
                int time = TameableUtils.getHealingAuraTime(event.getEntity());
                if (time > 0) {
                    List<LivingEntity> hurtNearby = TameableUtils.getAuraHealables(event.getEntity());
                    for (LivingEntity needsHealing : hurtNearby) {
                        if (needsHealing.m_21023_(MobEffects.f_19605_)) continue;
                        needsHealing.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.HEALING_AURA) - 1));
                    }
                    if (--time == 0) {
                        time = -600 - event.getEntity().m_217043_().m_188503_(600);
                    }
                } else if (time < 0) {
                    ++time;
                } else if ((event.getEntity().f_19797_ + event.getEntity().m_19879_()) % 200 == 0 || TameableUtils.getHealingAuraImpulse(event.getEntity())) {
                    List<LivingEntity> hurtNearby = TameableUtils.getAuraHealables(event.getEntity());
                    if (!hurtNearby.isEmpty()) {
                        time = 200;
                    }
                    TameableUtils.setHealingAuraImpulse(event.getEntity(), false);
                }
                TameableUtils.setHealingAuraTime(event.getEntity(), time);
            }
        }
        if (frozenTime > 0) {
            TameableUtils.setFrozenTimeTag(event.getEntity(), frozenTime - 1);
            AttributeInstance instance = event.getEntity().m_21051_(Attributes.f_22279_);
            if (instance != null) {
                float f = -0.1f * event.getEntity().m_146889_();
                if (frozenTime > 1) {
                    AttributeModifier fangModifier = new AttributeModifier(FROST_FANG_SLOW, "Frost fang slow", (double)f, AttributeModifier.Operation.ADDITION);
                    if (!instance.m_22109_(fangModifier)) {
                        instance.m_22118_(fangModifier);
                    }
                } else {
                    instance.m_22120_(FROST_FANG_SLOW);
                }
            }
            for (int i = 0; i < 1 + event.getEntity().m_217043_().m_188503_(2); ++i) {
                event.getEntity().m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, event.getEntity().m_20208_((double)0.7f), event.getEntity().m_20187_(), event.getEntity().m_20262_((double)0.7f), 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onLivingIncomingDamage(LivingHurtEvent event) {
        if (FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getAmount())) {
            event.getEntity().m_6703_(null);
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.m_6703_(null);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingAttackEvent event) {
        List<LivingEntity> nearbyHealers;
        Level world = event.getEntity().m_9236_();
        if (!world.m_5776_() && FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getAmount())) {
            event.setCanceled(true);
            event.getEntity().m_6703_(null);
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.m_6703_(null);
            }
        }
        if (TameableUtils.isTamed((Entity)event.getEntity()) && !event.getSource().m_276093_(DIDamageTypes.SIPHON)) {
            Object owner;
            int bars;
            boolean flag = false;
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.IMMUNITY_FRAME)) {
                int level = TameableUtils.getEnchantLevel(event.getEntity(), DIEnchantmentRegistry.IMMUNITY_FRAME);
                if (TameableUtils.getImmuneTime(event.getEntity()) <= 0) {
                    TameableUtils.setImmuneTime(event.getEntity(), 20 + level * 20);
                } else {
                    flag = true;
                    event.setCanceled(true);
                }
            }
            if (TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.BLAZING_PROTECTION) && (bars = TameableUtils.getBlazingProtectionBars(event.getEntity())) > 0) {
                LivingEntity livingAttacker;
                Entity attacker = event.getSource().m_7639_();
                if (attacker instanceof LivingEntity && !TameableUtils.hasSameOwnerAs(livingAttacker = (LivingEntity)attacker, (Entity)event.getEntity())) {
                    livingAttacker.m_20254_(5 + event.getEntity().m_217043_().m_188503_(3));
                    livingAttacker.m_147240_(0.4, event.getEntity().m_20185_() - livingAttacker.m_20185_(), event.getEntity().m_20189_() - livingAttacker.m_20189_());
                }
                event.setCanceled(true);
                flag = true;
                if (attacker != null) {
                    for (int i = 0; i < 3 + event.getEntity().m_217043_().m_188503_(3); ++i) {
                        attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, event.getEntity().m_20208_((double)0.8f), event.getEntity().m_20187_(), event.getEntity().m_20262_((double)0.8f), 0.0, 0.0, 0.0);
                    }
                }
                event.getEntity().m_5496_((SoundEvent)DISoundRegistry.BLAZING_PROTECTION.get(), 1.0f, event.getEntity().m_6100_());
                TameableUtils.setBlazingProtectionBars(event.getEntity(), bars - 1);
                TameableUtils.setBlazingProtectionCooldown(event.getEntity(), 600);
            }
            if ((event.getSource().m_276093_(DamageTypes.f_268722_) || event.getSource().m_276093_(DamageTypes.f_268752_)) && TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.AMPHIBIOUS)) {
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && (event.getSource().m_276093_(DamageTypes.f_268671_) || event.getSource().m_276093_(DamageTypes.f_268724_)) && TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.VOID_CLOUD)) {
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.HEALTH_SIPHON) && (owner = TameableUtils.getOwnerOf((Entity)event.getEntity())) != null && owner.m_6084_() && owner.m_20270_((Entity)event.getEntity()) < 100.0f && owner != event.getEntity()) {
                owner.m_6469_(event.getSource(), event.getAmount());
                event.setCanceled(true);
                flag = true;
                event.getEntity().m_6469_(DIDamageTypes.causeSiphonDamage(owner.m_9236_().m_9598_()), 0.0f);
            }
            if (!flag && TameableUtils.hasEnchant(event.getEntity(), DIEnchantmentRegistry.TOTAL_RECALL) && (double)(event.getEntity().m_21223_() - event.getAmount()) <= 2.0 && !TameableUtils.isZombiePet(event.getEntity()) && (owner = TameableUtils.getOwnerUUIDOf((Entity)event.getEntity())) != null) {
                LivingEntity i = event.getEntity();
                if (i instanceof Mob) {
                    Mob mob = (Mob)i;
                    mob.m_8032_();
                }
                event.getEntity().m_5496_(SoundEvents.f_11888_, 1.0f, 1.5f);
                RecallBallEntity recallBall = (RecallBallEntity)((EntityType)PHEntityRegistry.RECALL_BALL.get()).m_20615_(event.getEntity().m_9236_());
                recallBall.setOwnerUUID((UUID)owner);
                CompoundTag tag = new CompoundTag();
                event.getEntity().m_7380_(tag);
                recallBall.setContainedData(tag);
                recallBall.setContainedEntityType(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString());
                recallBall.m_6034_(event.getEntity().m_20185_(), Math.max(event.getEntity().m_20186_(), (double)(event.getEntity().m_9236_().m_141937_() + 1)), event.getEntity().m_20189_());
                recallBall.m_146922_(event.getEntity().m_146908_());
                recallBall.m_20331_(true);
                event.getEntity().m_8127_();
                if (event.getEntity().m_9236_().m_7967_((Entity)recallBall)) {
                    event.getEntity().m_146870_();
                }
                flag = true;
                event.setCanceled(true);
            }
        }
        if (event.getSource().m_7639_() != null && TameableUtils.isTamed(event.getSource().m_7639_())) {
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            int lightningLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.CHAIN_LIGHTNING);
            int bubblingLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.BUBBLING);
            int vampireLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.VAMPIRE);
            if (lightningLevel > 0) {
                ChainLightningEntity lightning = (ChainLightningEntity)((EntityType)PHEntityRegistry.CHAIN_LIGHTNING.get()).m_20615_(event.getEntity().m_9236_());
                lightning.setCreatorEntityID(attacker.m_19879_());
                lightning.setFromEntityID(attacker.m_19879_());
                lightning.setToEntityID(event.getEntity().m_19879_());
                lightning.m_20359_((Entity)event.getEntity());
                lightning.setChainsLeft(3 + lightningLevel * 3);
                event.getEntity().m_9236_().m_7967_((Entity)lightning);
                event.getEntity().m_5496_((SoundEvent)DISoundRegistry.CHAIN_LIGHTNING.get(), 1.0f, 1.0f);
            }
            if (TameableUtils.hasEnchant(attacker, DIEnchantmentRegistry.FROST_FANG)) {
                event.getEntity().m_146917_(event.getEntity().m_146891_() + 200);
                Vec3 vec3 = event.getEntity().m_146892_().m_82546_(attacker.m_146892_()).m_82541_().m_82490_((double)(attacker.m_20205_() + 0.5f));
                Vec3 vec32 = attacker.m_146892_().m_82549_(vec3);
                for (int i = 0; i < 3 + attacker.m_217043_().m_188503_(3); ++i) {
                    float f1 = 0.2f * (attacker.m_217043_().m_188501_() - 1.0f);
                    float f2 = 0.2f * (attacker.m_217043_().m_188501_() - 1.0f);
                    float f3 = 0.2f * (attacker.m_217043_().m_188501_() - 1.0f);
                    attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, vec32.f_82479_ + (double)f1, vec32.f_82480_ + (double)f2, vec32.f_82481_ + (double)f3, 0.0, 0.0, 0.0);
                }
                TameableUtils.setFrozenTimeTag(event.getEntity(), 60);
            }
            if (bubblingLevel > 0 && !(event.getEntity().m_20201_() instanceof GiantBubbleEntity) && (event.getEntity().m_20096_() || event.getEntity().m_20072_() || event.getEntity().m_20077_())) {
                GiantBubbleEntity bubble = (GiantBubbleEntity)((EntityType)PHEntityRegistry.GIANT_BUBBLE.get()).m_20615_(event.getEntity().m_9236_());
                bubble.m_20359_((Entity)event.getEntity());
                event.getEntity().m_7998_((Entity)bubble, true);
                bubble.setpopsIn(bubblingLevel * 40 + 40);
                event.getEntity().m_9236_().m_7967_((Entity)bubble);
                event.getEntity().m_5496_((SoundEvent)DISoundRegistry.GIANT_BUBBLE_INFLATE.get(), 1.0f, 1.0f);
            }
            if (vampireLevel > 0 && attacker.m_21223_() < attacker.m_21233_()) {
                float f = Mth.m_14036_((float)(event.getAmount() * (float)vampireLevel * 0.5f), (float)1.0f, (float)10.0f);
                attacker.m_5634_(f);
                if (event.getEntity().m_9236_() instanceof ServerLevel) {
                    for (int i = 0; i < 5 + event.getEntity().m_217043_().m_188503_(3); ++i) {
                        double f1 = event.getEntity().m_20208_((double)0.7f);
                        double f2 = event.getEntity().m_20227_((double)(0.4f + event.getEntity().m_217043_().m_188501_() * 0.2f));
                        double f3 = event.getEntity().m_20262_((double)0.7f);
                        Vec3 motion = attacker.m_146892_().m_82492_(f1, f2, f3).m_82541_().m_82490_((double)0.2f);
                        ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)DIParticleRegistry.VAMPIRE.get()), f1, f2, f3, 1, motion.f_82479_, motion.f_82480_, motion.f_82481_, (double)0.2f);
                    }
                }
            }
            if (!event.getEntity().m_9236_().f_46443_ && TameableUtils.hasEnchant(attacker, DIEnchantmentRegistry.WARPING_BITE)) {
                for (int i = 0; i < 16; ++i) {
                    double d3 = event.getEntity().m_20185_() + (attacker.m_217043_().m_188500_() - 0.5) * 16.0;
                    double d4 = Mth.m_14008_((double)(event.getEntity().m_20186_() + (double)(attacker.m_217043_().m_188503_(16) - 8)), (double)event.getEntity().m_9236_().m_141937_(), (double)(event.getEntity().m_9236_().m_141937_() + ((ServerLevel)event.getEntity().m_9236_()).m_143344_() - 1));
                    double d5 = event.getEntity().m_20189_() + (attacker.m_217043_().m_188500_() - 0.5) * 16.0;
                    if (!event.getEntity().m_20984_(d3, d4, d5, true)) continue;
                    SoundEvent soundevent = event.getEntity() instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                    event.getEntity().m_5496_(soundevent, 1.0f, 1.0f);
                    break;
                }
            }
        }
        if (!event.isCanceled() && !(nearbyHealers = TameableUtils.getNearbyHealers(event.getEntity())).isEmpty()) {
            for (LivingEntity healer : nearbyHealers) {
                TameableUtils.setHealingAuraImpulse(healer, true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity pet = (LivingEntity)entity;
            if (TameableUtils.isTamed(event.getSource().m_7639_()) && TameableUtils.hasEnchant(pet, DIEnchantmentRegistry.IMMATURITY_CURSE)) {
                event.setAmount((float)Math.ceil(event.getAmount() * 0.7f));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDie(LivingDeathEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntity()) && !TameableUtils.isZombiePet(event.getEntity())) {
            Object saveName;
            BlockPos bedPos = TameableUtils.getPetBedPos(event.getEntity());
            if (bedPos != null) {
                CompoundTag data = new CompoundTag();
                event.getEntity().m_7380_(data);
                saveName = event.getEntity().m_8077_() ? event.getEntity().m_7770_().getString() : "";
                RespawnRequest request = new RespawnRequest(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString(), TameableUtils.getPetBedDimension(event.getEntity()), data, bedPos, event.getEntity().m_9236_().m_8044_(), (String)saveName);
                DIWorldData worldData = DIWorldData.get(event.getEntity().m_9236_());
                if (worldData != null) {
                    worldData.addRespawnRequest(request);
                }
            }
            if (!(event.getEntity() instanceof TamableAnimal)) {
                Entity owner = TameableUtils.getOwnerOf((Entity)event.getEntity());
                if (!event.getEntity().m_9236_().f_46443_ && event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && owner instanceof ServerPlayer) {
                    owner.m_213846_(event.getEntity().m_21231_().m_19293_());
                }
            }
            if ((saveName = event.getEntity()) instanceof Mob) {
                Mob mob = (Mob)saveName;
                if (event.getEntity().m_9236_().m_46791_() != Difficulty.PEACEFUL && TameableUtils.hasEnchant((LivingEntity)mob, DIEnchantmentRegistry.UNDEAD_CURSE)) {
                    Mob zombieCopy = (Mob)mob.m_6095_().m_20615_(mob.m_9236_());
                    int id = zombieCopy.m_19879_();
                    Entity owner = TameableUtils.getOwnerOf((Entity)mob);
                    CompoundTag livingNbt = new CompoundTag();
                    mob.m_7380_(livingNbt);
                    livingNbt.m_128359_("DeathLootTable", BuiltInLootTables.f_78712_.toString());
                    zombieCopy.m_7378_(livingNbt);
                    zombieCopy.m_20234_(id);
                    if (zombieCopy instanceof TamableAnimal) {
                        TamableAnimal tamed = (TamableAnimal)zombieCopy;
                        tamed.m_7105_(false);
                        tamed.m_21816_(null);
                        tamed.m_21839_(false);
                    }
                    if (zombieCopy instanceof ModifedToBeTameable) {
                        ModifedToBeTameable tameable = (ModifedToBeTameable)zombieCopy;
                        tameable.setTame(false);
                        tameable.setTameOwnerUUID(null);
                    }
                    if (zombieCopy instanceof IComandableMob) {
                        IComandableMob commandableMob = (IComandableMob)zombieCopy;
                        commandableMob.setCommand(0);
                    }
                    zombieCopy.m_20359_((Entity)mob);
                    zombieCopy.m_6710_((LivingEntity)(owner instanceof Player && !((Player)owner).m_7500_() ? (Player)owner : mob.m_9236_().m_45946_(ZOMBIE_TARGET, (LivingEntity)mob)));
                    mob.m_9236_().m_7967_((Entity)zombieCopy);
                    zombieCopy.m_21153_(zombieCopy.m_21233_());
                    TameableUtils.setZombiePet((LivingEntity)zombieCopy, true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof GiantBubbleEntity && event.isDismounting() && event.getEntityBeingMounted().m_6084_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Entity i52;
        LivingEntity living;
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        if (entity instanceof LivingEntity) {
            Rabbit rabbit;
            CompoundTag horseExtras;
            Horse horse;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.m_6095_() == EntityType.f_20457_ && stack.m_150930_((Item)PHItemRegistry.ROTTEN_APPLE.get()) && ForgeEventFactory.canLivingConvert((LivingEntity)livingEntity, (EntityType)EntityType.f_20502_, timer -> {})) {
                player.m_6674_(hand);
                horse = (Horse)entity;
                horse.m_5496_(SoundEvents.f_11975_, 0.8f, horse.m_6100_());
                horse.m_5496_(SoundEvents.f_12609_, 0.8f, horse.m_6100_());
                horseExtras = new CompoundTag();
                if (!horse.m_30722_().m_41619_()) {
                    horse.m_19983_(horse.m_30722_().m_41777_());
                    horse.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                }
                horse.m_7380_(horseExtras);
                for (int i2 = 0; i2 < 6 + horse.m_217043_().m_188503_(5); ++i2) {
                    horse.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123763_, horse.m_20208_(1.0), horse.m_20187_(), horse.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                ZombieHorse zombie = (ZombieHorse)EntityType.f_20502_.m_20615_(horse.m_9236_());
                if (horse.m_21523_()) {
                    zombie.m_21463_(horse.m_21524_(), true);
                }
                zombie.m_7678_(horse.m_20185_(), horse.m_20186_(), horse.m_20189_(), horse.m_146908_(), horse.m_146909_());
                zombie.m_21557_(horse.m_21525_());
                zombie.m_6863_(horse.m_6162_());
                if (horse.m_8077_()) {
                    zombie.m_6593_(horse.m_7770_());
                    zombie.m_20340_(horse.m_20151_());
                }
                zombie.m_7378_(horseExtras);
                zombie.m_21530_();
                ForgeEventFactory.onLivingConvert((LivingEntity)horse, (LivingEntity)zombie);
                player.m_9236_().m_7967_((Entity)zombie);
                horse.m_146870_();
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            if (entity.m_6095_() == EntityType.f_20517_ && TameableUtils.isTamed(entity) && stack.m_150930_((Item)PHItemRegistry.SINISTER_CARROT.get()) && TameableUtils.isPetOf(player, entity) && ForgeEventFactory.canLivingConvert((LivingEntity)livingEntity, (EntityType)EntityType.f_20517_, timer -> {}) && entity instanceof Rabbit && (rabbit = (Rabbit)entity).m_28554_() != Rabbit.Variant.EVIL) {
                player.m_6674_(hand);
                rabbit.m_5496_(SoundEvents.f_12298_, 0.8f, rabbit.m_6100_());
                rabbit.m_5496_(SoundEvents.f_12609_, 0.8f, rabbit.m_6100_());
                rabbit.m_28464_(Rabbit.Variant.EVIL);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            if (entity.m_6095_() == EntityType.f_20502_ && stack.m_150930_((Item)PHItemRegistry.SINISTER_CARROT.get()) && ForgeEventFactory.canLivingConvert((LivingEntity)livingEntity, (EntityType)EntityType.f_20525_, timer -> {})) {
                player.m_6674_(hand);
                horse = (ZombieHorse)entity;
                horse.m_5496_(SoundEvents.f_11975_, 0.8f, horse.m_6100_());
                horse.m_5496_(SoundEvents.f_12609_, 0.8f, horse.m_6100_());
                horseExtras = new CompoundTag();
                horse.m_7380_(horseExtras);
                for (int i3 = 0; i3 < 6 + horse.m_217043_().m_188503_(5); ++i3) {
                    horse.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123763_, horse.m_20208_(1.0), horse.m_20187_(), horse.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                SkeletonHorse skeleton = (SkeletonHorse)EntityType.f_20525_.m_20615_(horse.m_9236_());
                if (horse.m_21523_()) {
                    skeleton.m_21463_(horse.m_21524_(), true);
                }
                skeleton.m_7678_(horse.m_20185_(), horse.m_20186_(), horse.m_20189_(), horse.m_146908_(), horse.m_146909_());
                skeleton.m_21557_(horse.m_21525_());
                skeleton.m_6863_(horse.m_6162_());
                if (horse.m_8077_()) {
                    skeleton.m_6593_(horse.m_7770_());
                    skeleton.m_20340_(horse.m_20151_());
                }
                skeleton.m_7378_(horseExtras);
                skeleton.m_21530_();
                ForgeEventFactory.onLivingConvert((LivingEntity)horse, (LivingEntity)skeleton);
                player.m_9236_().m_7967_((Entity)skeleton);
                horse.m_146870_();
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        }
        if (TameableUtils.isTamed(event.getTarget()) && event.getItemStack().m_150930_((Item)PHItemRegistry.DEED_OF_OWNERSHIP.get())) {
            CompoundTag tag = stack.m_41783_();
            boolean unbound = !DeedOfOwnershipItem.isBound(event.getItemStack());
            Entity currentOwner = TameableUtils.getOwnerOf(entity);
            if (TameableUtils.isTamed(entity) && currentOwner != null && currentOwner.equals((Object)player) && unbound) {
                CompoundTag newTag = new CompoundTag();
                newTag.m_128379_("HasBoundEntity", true);
                newTag.m_128362_("BoundEntity", entity.m_20148_());
                newTag.m_128359_("BoundEntityName", entity.m_7755_().getString());
                stack.m_41751_(newTag);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            if (TameableUtils.isTamed(entity) && tag != null && tag.m_128471_("HasBoundEntity") && tag.m_128342_("BoundEntity") != null) {
                UUID fromItem = tag.m_128342_("BoundEntity");
                if (entity.m_20148_().equals(fromItem)) {
                    player.m_36335_().m_41524_(stack.m_41720_(), 5);
                    TameableUtils.setOwnerUUIDOf(entity, player.m_20148_());
                    player.m_5661_((Component)Component.m_237110_((String)"message.pet_home.set_owner", (Object[])new Object[]{player.m_7755_(), entity.m_7755_()}), true);
                    if (currentOwner instanceof Player && !currentOwner.equals((Object)player)) {
                        ((Player)currentOwner).m_5661_((Component)Component.m_237110_((String)"message.pet_home.set_owner", (Object[])new Object[]{player.m_7755_(), entity.m_7755_()}), true);
                    }
                    stack.m_41751_(new CompoundTag());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
        if (TameableUtils.couldBeTamed(event.getTarget()) && TameableUtils.isZombiePet((LivingEntity)event.getTarget())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        Entity unbound = event.getTarget();
        if (unbound instanceof LivingEntity) {
            living = (LivingEntity)unbound;
            if (TameableUtils.isTamed(entity) && TameableUtils.hasEnchant(living, DIEnchantmentRegistry.GLUTTONOUS) && stack.m_41720_().m_41472_() && living.m_21223_() < living.m_21233_() && stack.m_41720_().m_41473_() != null) {
                living.m_5634_((float)Math.floor((float)stack.m_41720_().m_41473_().m_38744_() * 1.5f));
                if (!event.getEntity().m_7500_()) {
                    stack.m_41774_(1);
                }
                living.m_5496_(living.m_217043_().m_188499_() ? SoundEvents.f_12321_ : SoundEvents.f_11912_, 1.0f, living.m_6100_());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
        if ((unbound = event.getTarget()) instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)unbound;
            if (((Boolean)PetHomeMod.CONFIG.tameableRabbit.get()).booleanValue()) {
                if (stack.m_41720_() == Items.f_42129_) {
                    if (TameableUtils.isTamed((Entity)rabbit) && rabbit.m_21223_() < rabbit.m_21233_()) {
                        rabbit.m_5634_(3.0f);
                        if (!event.getEntity().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        return;
                    }
                    if (!TameableUtils.isTamed((Entity)rabbit) && !rabbit.m_9236_().f_46443_) {
                        if (!event.getEntity().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        rabbit.m_216990_(SoundEvents.f_11947_);
                        if (rabbit.m_217043_().m_188499_()) {
                            for (int i4 = 0; i4 < 3; ++i4) {
                                double d0 = rabbit.m_217043_().m_188583_() * 0.02;
                                double d1 = rabbit.m_217043_().m_188583_() * 0.02;
                                double d = rabbit.m_217043_().m_188583_() * 0.02;
                                ((ServerLevel)rabbit.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, rabbit.m_20208_(1.0), rabbit.m_20187_() + 0.5, rabbit.m_20262_(1.0), 3, d0, d1, d, (double)0.02f);
                            }
                            ((ModifedToBeTameable)rabbit).setTame(true);
                            ((ModifedToBeTameable)rabbit).setTameOwnerUUID(event.getEntity().m_20148_());
                            ((IComandableMob)rabbit).setCommand(1);
                        } else {
                            for (int i52 = 0; i52 < 3; ++i52) {
                                double d0 = rabbit.m_217043_().m_188583_() * 0.02;
                                double d1 = rabbit.m_217043_().m_188583_() * 0.02;
                                double d = rabbit.m_217043_().m_188583_() * 0.02;
                                ((ServerLevel)rabbit.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, rabbit.m_20208_(1.0), rabbit.m_20187_() + 0.5, rabbit.m_20262_(1.0), 3, d0, d1, d, (double)0.02f);
                            }
                        }
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        return;
                    }
                }
                if (TameableUtils.isTamed((Entity)rabbit) && TameableUtils.isPetOf(event.getEntity(), (Entity)rabbit)) {
                    ((IComandableMob)rabbit).playerSetCommand(event.getEntity(), (Animal)rabbit);
                }
            }
        }
        if ((i52 = event.getTarget()) instanceof LivingEntity) {
            living = (LivingEntity)i52;
            if (TameableUtils.isPetOf(event.getEntity(), entity) && !living.m_6095_().m_204039_(DITagRegistry.REFUSES_COLLAR_TAGS) && event.getItemStack().m_150930_((Item)PHItemRegistry.COLLAR_TAG.get()) && ((Boolean)PetHomeMod.CONFIG.collarTag.get()).booleanValue()) {
                if (!event.getEntity().m_9236_().f_46443_ && living.m_6084_()) {
                    Map itemEnchantments = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
                    Map<ResourceLocation, Integer> entityEnchantments = TameableUtils.getEnchants(living);
                    if (stack.m_41788_() && living.m_8077_() && stack.m_41786_().equals(living.m_7770_())) {
                        boolean hasSameEnchants = itemEnchantments.isEmpty();
                        if (entityEnchantments != null) {
                            hasSameEnchants = true;
                            for (Map.Entry itemEntry : itemEnchantments.entrySet()) {
                                ResourceLocation resourceLocation = ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)itemEntry.getKey()));
                                if (entityEnchantments.get(resourceLocation) != null && entityEnchantments.get(resourceLocation).equals(itemEntry.getValue())) continue;
                                hasSameEnchants = false;
                            }
                        }
                        if (hasSameEnchants) {
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.FAIL);
                            return;
                        }
                    }
                    if (stack.m_41788_()) {
                        living.m_6593_(stack.m_41786_());
                    }
                    if (!event.getEntity().m_7500_()) {
                        stack.m_41774_(1);
                    }
                    this.blockCollarTick((Entity)living);
                    if (TameableUtils.hasCollar(living)) {
                        ItemStack collarFrom = new ItemStack((ItemLike)PHItemRegistry.COLLAR_TAG.get());
                        if (entityEnchantments != null) {
                            collarFrom.m_41784_();
                            if (!collarFrom.m_41783_().m_128425_("Enchantments", 9)) {
                                collarFrom.m_41783_().m_128365_("Enchantments", (Tag)new ListTag());
                            }
                            ListTag listtag = collarFrom.m_41783_().m_128437_("Enchantments", 10);
                            for (Map.Entry entry : entityEnchantments.entrySet()) {
                                listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)((ResourceLocation)entry.getKey()), (int)((Integer)entry.getValue())));
                            }
                        } else {
                            collarFrom.m_41751_(null);
                        }
                        living.m_19983_(collarFrom);
                    }
                    living.m_5496_((SoundEvent)DISoundRegistry.COLLAR_TAG.get(), 1.0f, 1.0f);
                    if (itemEnchantments.isEmpty()) {
                        TameableUtils.clearEnchants(living);
                    } else {
                        ListTag listTag = new ListTag();
                        for (Map.Entry entry : itemEnchantments.entrySet()) {
                            TameableUtils.addEnchant(living, new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()), listTag);
                        }
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        if (event.getState().m_60734_() instanceof PetBedBlock && (blockEntity = event.getLevel().m_7702_(event.getPos())) instanceof PetBedBlockEntity) {
            PetBedBlockEntity entity1 = (PetBedBlockEntity)blockEntity;
            entity1.removeAllRequestsFor(event.getPlayer());
            entity1.resetBedsForNearbyPets();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(MobSpawnEvent.FinalizeSpawn event) {
        try {
            if (event.getEntity() != null && event.getEntity() instanceof Ravager && ((Boolean)PetHomeMod.CONFIG.rabbitsScareRavagers.get()).booleanValue()) {
                Ravager ravager = (Ravager)event.getEntity();
                ravager.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)ravager, Rabbit.class, 13.0f, 1.5, 2.0, EntitySelector.f_20408_));
            }
        }
        catch (Exception e) {
            PetHomeMod.LOGGER.warn("could not add ai tasks to ravager");
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35594_) {
            Int2ObjectMap tradeList = event.getTrades();
            for (int level = 1; level <= 5; ++level) {
                List levelTrade = (List)tradeList.get(level);
                if (levelTrade == null) continue;
                levelTrade.removeIf(i -> i instanceof VillagerTrades.EnchantBookForEmeralds);
                levelTrade.add(new EnchantBookForEmeraldsWithoutPet(5 * level));
            }
        }
        if (event.getType() == DIVillagerRegistry.ANIMAL_TAMER.get()) {
            ArrayList<Object> level1 = new ArrayList<Object>();
            ArrayList<Object> level2 = new ArrayList<Object>();
            ArrayList<Object> level3 = new ArrayList<Object>();
            ArrayList<Object> level4 = new ArrayList<Object>();
            ArrayList<Object> level5 = new ArrayList<Object>();
            level1.add(new SellingItemTrade(Items.f_42500_, 3, 10, 6, 4));
            level1.add(new SellingItemTrade(Items.f_42526_, 2, 7, 6, 3));
            level1.add(new SellingRandomEnchantedBook());
            level1.add(new SellingItemTrade((Item)PHItemRegistry.FEATHER_ON_A_STICK.get(), 3, 1, 2, 3));
            level2.add(new SellingItemTrade(Items.f_42459_, 2, 1, 6, 7));
            level2.add(new BuyingItemTrade((ItemLike)PHItemRegistry.COLLAR_TAG.get(), 5, 1, 12, 7));
            level2.add(new SellingItemTrade(Items.f_42410_, 4, 12, 3, 7));
            level2.add(new SellingRandomEnchantedBook());
            level2.add(new SellingItemTrade((Item)PHItemRegistry.DEED_OF_OWNERSHIP.get(), 3, 1, 2, 7));
            level3.add(new SellingItemTrade((Item)PHItemRegistry.ROTTEN_APPLE.get(), 4, 1, 1, 10));
            level3.add(new SellingRandomEnchantedBook());
            level3.add(new SellingItemTrade((Block)DIBlockRegistry.DRUM.get(), 2, 3, 7, 11));
            level3.add(new SellingItemTrade(Items.f_220210_, 6, 1, 4, 13));
            level3.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 20, 2, 8, 3, 10));
            level4.add(new SellingItemTrade(Items.f_151057_, 11, 1, 2, 15));
            level4.add(new SellingItemTrade(Items.f_42279_, 26, 1, 2, 15));
            level4.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 40, 3, 18, 3, 15));
            level5.add(new SellingItemTrade(Items.f_42355_, 21, 1, 3, 18));
            level5.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 50, 4, 38, 3, 20));
            level5.add(new SellingRandomEnchantedBook());
            event.getTrades().put(1, level1);
            event.getTrades().put(2, level2);
            event.getTrades().put(3, level3);
            event.getTrades().put(4, level4);
            event.getTrades().put(5, level5);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntity()) && TameableUtils.getPetBedPos(event.getEntity()) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        float dist = 30.0f;
        Vec3 center = event.getExplosion().getPosition();
        Vec3 bottom = center.m_82520_((double)(-dist), (double)(-dist), (double)(-dist));
        Vec3 top = center.m_82520_((double)dist, (double)dist, (double)dist);
        Predicate<Entity> defusal = animal -> TameableUtils.isTamed(animal) && TameableUtils.hasEnchant((LivingEntity)animal, DIEnchantmentRegistry.DEFUSAL);
        boolean flag = false;
        for (LivingEntity defuser : event.getLevel().m_6443_(LivingEntity.class, new AABB(bottom, top), EntitySelector.f_20408_.and(defusal))) {
            float level = 10 * TameableUtils.getEnchantLevel(defuser, DIEnchantmentRegistry.DEFUSAL);
            if (!(defuser.m_20238_(center) <= (double)(level * level))) continue;
            flag = true;
            break;
        }
        if (flag) {
            event.setCanceled(true);
            float pitch = 1.5f + new Random().nextFloat();
            event.getLevel().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, pitch);
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, 5, 0.0, 0.0, 0.0, (double)0.2f);
                }
            }
        }
    }

    private void teleportNearbyPets(Player owner, Vec3 fromPos, Vec3 toPos, Level fromLevel, Level toLevel) {
        double dist = 20.0;
        boolean removeAndReadd = fromLevel.m_46472_() != toLevel.m_46472_();
        Predicate<Entity> enchantedPet = animal -> animal instanceof Mob && TameableUtils.isPetOf(owner, animal) && TameableUtils.isValidTeleporter((LivingEntity)owner, (Mob)animal);
        for (Mob entity : fromLevel.m_6443_(Mob.class, new AABB(fromPos.f_82479_ - dist, fromPos.f_82480_ - dist, fromPos.f_82481_ - dist, fromPos.f_82479_ + dist, fromPos.f_82480_ + dist, fromPos.f_82481_ + dist), EntitySelector.f_20408_.and(enchantedPet))) {
            if (removeAndReadd) {
                teleportingPets.add((Triple<Entity, ServerLevel, UUID>)new Triple((Object)entity, (Object)toLevel, (Object)owner.m_20148_()));
                continue;
            }
            EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
            AABB suffocationBox = new AABB((double)(-dimensions.f_20377_ / 2.0f), 0.0, (double)(-dimensions.f_20377_ / 2.0f), (double)(dimensions.f_20377_ / 2.0f), (double)dimensions.f_20378_, (double)(dimensions.f_20377_ / 2.0f));
            while (!toLevel.m_45756_((Entity)entity, suffocationBox.m_82386_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_)) && toPos.f_82480_ < 300.0) {
                toPos = toPos.m_82520_(0.0, 1.0, 0.0);
            }
            entity.f_19789_ = 0.0f;
            entity.m_20324_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_);
            entity.m_20091_();
        }
    }

    @SubscribeEvent
    public void onEntityTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof Player) {
            this.teleportNearbyPets((Player)event.getEntity(), event.getPrev(), event.getTarget(), event.getEntity().m_9236_(), event.getEntity().m_9236_());
        }
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Level level;
        if (!event.isCanceled() && (level = event.getEntity().m_9236_()) instanceof ServerLevel) {
            MinecraftServer server;
            ServerLevel toLevel;
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getEntity() instanceof Player && (toLevel = (server = serverLevel.m_7654_()).m_129880_(event.getDimension())) != null) {
                this.teleportNearbyPets((Player)event.getEntity(), event.getEntity().m_20182_(), event.getEntity().m_20182_(), event.getEntity().m_9236_(), (Level)toLevel);
            }
        }
    }

    @SubscribeEvent
    public void onSetAttackTarget(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (TameableUtils.isTamed((Entity)event.getEntity()) && (livingEntity = event.getNewTarget()) instanceof Player && TameableUtils.isPetOf(player = (Player)livingEntity, (Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onUpdateAnvil(AnvilUpdateEvent event) {
        if (event.getLeft().m_150930_((Item)PHItemRegistry.COLLAR_TAG.get()) && !event.getLeft().getAllEnchantments().isEmpty() && event.getRight().m_150930_((Item)PHItemRegistry.COLLAR_TAG.get()) && !event.getRight().getAllEnchantments().isEmpty()) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)event.getLeft());
            Map map1 = EnchantmentHelper.m_44831_((ItemStack)event.getRight());
            boolean canCombine = true;
            int i = 0;
            for (Enchantment enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, i2);
                for (Enchantment enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.m_44695_(enchantment)) continue;
                    canCombine = false;
                    ++i;
                }
                if (!canCombine) continue;
                if (j2 > enchantment1.m_6586_()) {
                    j2 = enchantment1.m_6586_();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.m_44699_()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
                i += k3 * j2;
            }
            event.setCost(i);
            ItemStack copy = event.getLeft().m_41777_();
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)copy);
            event.setOutput(copy);
        }
    }
}

