/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.entity;

import com.github.yzqdev.pethome.server.entity.PHEntityRegistry;
import com.github.yzqdev.pethome.server.item.NetItem;
import com.github.yzqdev.pethome.server.item.PHItemRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NetEntity
extends ThrowableItemProjectile {
    private String entityNbt = "itemNbt";
    private ItemStack itemStack = ItemStack.f_41583_;
    private boolean hasItemStack = false;

    public NetEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public NetEntity(double x, double y, double z, Level world, ItemStack newStack) {
        super((EntityType)PHEntityRegistry.NET_ENTITY.get(), x, y, z, world);
        this.setItemStack(newStack);
    }

    @Nonnull
    protected Item m_7881_() {
        if (this.hasItemStack && !this.itemStack.m_41619_()) {
            return NetItem.containsEntity(this.itemStack) ? (Item)PHItemRegistry.NET_HAS_ITEM.get() : (Item)PHItemRegistry.NET_ITEM.get();
        }
        return (Item)PHItemRegistry.NET_ITEM.get();
    }

    protected void m_6532_(@Nonnull HitResult result) {
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return;
        }
        HitResult.Type type = result.m_6662_();
        boolean containsEntity = NetItem.containsEntity(this.itemStack);
        if (containsEntity) {
            Entity entity = NetItem.getEntityFromStack(this.itemStack, this.m_9236_(), true);
            BlockPos pos = type == HitResult.Type.ENTITY ? ((EntityHitResult)result).m_82443_().m_20183_() : ((BlockHitResult)result).m_82425_();
            entity.m_19890_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            this.m_9236_().m_7967_(entity);
        } else if (type == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTrace = (EntityHitResult)result;
            Entity target = entityRayTrace.m_82443_();
            if (!target.m_6084_() || !NetItem.canCatchMob(target)) {
                return;
            }
            CompoundTag nbt = NetItem.getNBTfromEntity(target);
            ItemStack newStack = new ItemStack((ItemLike)PHItemRegistry.NET_HAS_ITEM.get());
            CompoundTag tag = newStack.m_41784_();
            tag.m_128365_("entity_holder", (Tag)nbt);
            newStack.m_41751_(tag);
            ItemEntity itemEntity = this.createDroppedItemAtEntity(target, newStack);
            this.m_9236_().m_7967_((Entity)itemEntity);
            target.m_146870_();
        } else {
            ItemEntity emptynet = this.createDroppedItemAtEntity((Entity)this, this.itemStack.m_41777_());
            this.m_9236_().m_7967_((Entity)emptynet);
        }
        this.m_146870_();
    }

    public void setItemStack(ItemStack stack) {
        this.itemStack = stack.m_41777_();
        this.hasItemStack = true;
        this.m_37446_(this.itemStack);
    }

    protected ItemEntity createDroppedItemAtEntity(Entity entity, ItemStack stack) {
        return new ItemEntity(this.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.hasItemStack) {
            nbt.m_128365_(this.entityNbt, (Tag)this.itemStack.m_41739_(nbt));
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.itemStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("pet_home"));
        if (nbt.m_128425_(this.entityNbt, 10)) {
            ItemStack savedStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(this.entityNbt));
            this.setItemStack(savedStack);
        } else {
            this.hasItemStack = false;
        }
    }
}

