/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.entity;

import com.github.yzqdev.pethome.server.entity.PHEntityRegistry;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.github.yzqdev.pethome.server.misc.DIParticleRegistry;
import com.github.yzqdev.pethome.server.misc.DISoundRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class PsychicWallEntity
extends Entity {
    protected static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.m_135353_(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_UUID = SynchedEntityData.m_135353_(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CREATOR_ID = SynchedEntityData.m_135353_(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLOCK_WIDTH = SynchedEntityData.m_135353_(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final List<UUID> deflectedArrows = new ArrayList<UUID>();
    private final Map<UUID, Integer> deflectedEntities = new HashMap<UUID, Integer>();
    private int soundLoop = 0;

    public PsychicWallEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public PsychicWallEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)PHEntityRegistry.PSYCHIC_WALL.get(), world);
    }

    public void m_8119_() {
        Entity creator;
        super.m_8119_();
        if (this.f_19797_ <= 10 || this.getLifespan() <= 10) {
            this.m_20011_(this.m_142242_());
        } else {
            if (this.soundLoop % 15 == 0) {
                this.m_5496_((SoundEvent)DISoundRegistry.PSYCHIC_WALL.get(), 1.0f, this.f_19796_.m_188501_() * 0.3f + 0.9f);
            }
            ++this.soundLoop;
        }
        if (!this.m_9236_().f_46443_ && this.getCreatorId() != null && (creator = this.getCreator()) != null) {
            this.f_19804_.m_135381_(CREATOR_ID, (Object)creator.m_19879_());
            if (!creator.m_6084_() && this.getLifespan() > 20) {
                this.setLifespan(20);
            }
        }
        this.m_20256_(Vec3.f_82478_);
        float wX = Math.abs(this.getWallDirection().m_122429_());
        float wY = Math.abs(this.getWallDirection().m_122430_());
        float wZ = Math.abs(this.getWallDirection().m_122431_());
        AABB collisionAABB = this.m_20191_().m_82377_((double)(wX * 0.25f), (double)(wY * 0.25f), (double)(wZ * 0.25f));
        List colliders = this.m_9236_().m_45933_((Entity)this, collisionAABB);
        float backISay = this.getWallDirection().m_122434_() == Direction.Axis.Y ? -0.6f : -0.1f;
        for (Entity collider : colliders) {
            Vec3 vec31;
            if (this.isSameTeam(collider)) continue;
            collider.m_5997_((double)((float)this.getWallDirection().m_122429_() * 0.25f), (double)((float)this.getWallDirection().m_122430_() * 0.25f), (double)((float)this.getWallDirection().m_122431_() * 0.25f));
            if (this.deflectedEntities.containsKey(collider.m_20148_())) continue;
            boolean flag = true;
            if (collider instanceof Projectile) {
                if (this.isFiredByAlly((Projectile)collider)) {
                    flag = false;
                } else {
                    collider.m_20256_(collider.m_20184_().m_82490_((double)backISay));
                    collider.m_146922_(collider.m_146908_() + 180.0f);
                    collider.m_146926_(collider.m_146909_() + 180.0f);
                }
            }
            if (!flag) continue;
            this.deflectedEntities.put(collider.m_20148_(), 15);
            if (!this.m_9236_().f_46443_ || !collider.m_20191_().m_82381_(collisionAABB)) continue;
            Vec3 vec3 = new Vec3(collider.m_20185_(), collider.m_20227_(0.5), collider.m_20189_());
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)collider, (Vec3)vec3, (Vec3)(vec31 = collisionAABB.m_82399_()), (AABB)collisionAABB, entity -> entity == this, (double)collider.m_20270_((Entity)this));
            Vec3 vec32 = entityhitresult == null || entityhitresult.m_6662_() == HitResult.Type.MISS ? vec3 : entityhitresult.m_82450_();
            this.m_9236_().m_7106_((ParticleOptions)DIParticleRegistry.PSYCHIC_WALL.get(), vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (double)this.getWallDirection().m_122411_(), 0.0, 0.0);
            this.m_5496_((SoundEvent)DISoundRegistry.PSYCHIC_WALL_DEFLECT.get(), 1.0f, this.f_19796_.m_188501_() * 0.3f + 0.9f);
        }
        if (!this.deflectedEntities.isEmpty()) {
            for (UUID uuid : this.deflectedEntities.keySet()) {
                this.deflectedEntities.put(uuid, this.deflectedEntities.get(uuid) - 1);
            }
            this.deflectedEntities.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
        }
        if (this.getLifespan() <= 0) {
            this.m_146870_();
        } else {
            this.setLifespan(this.getLifespan() - 1);
        }
    }

    private boolean isFiredByAlly(Projectile projectile) {
        Entity owner = this.getCreator();
        if (owner instanceof LivingEntity && projectile.m_19749_() != null) {
            return TameableUtils.hasSameOwnerAs((LivingEntity)owner, projectile.m_19749_());
        }
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float f) {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFESPAN, (Object)300);
        this.f_19804_.m_135372_(BLOCK_WIDTH, (Object)1);
        this.f_19804_.m_135372_(CREATOR_UUID, Optional.empty());
        this.f_19804_.m_135372_(CREATOR_ID, (Object)-1);
        this.f_19804_.m_135372_(DIRECTION, (Object)Direction.UP);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Lifespan")) {
            this.setLifespan(tag.m_128451_("Lifespan"));
        }
        if (tag.m_128403_("CreatorUUID")) {
            this.setCreatorId(tag.m_128342_("CreatorUUID"));
        }
        this.setBlockWidth(tag.m_128451_("BlockWidth"));
        this.setWallDirection(Direction.m_122376_((int)tag.m_128451_("WallDirection")));
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getCreatorId() != null) {
            tag.m_128362_("CreatorUUID", this.getCreatorId());
        }
        tag.m_128405_("Lifespan", this.getLifespan());
        tag.m_128405_("BlockWidth", this.getBlockWidth());
        tag.m_128405_("WallDirection", this.getWallDirection().m_122411_());
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)i);
    }

    public int getBlockWidth() {
        return (Integer)this.f_19804_.m_135370_(BLOCK_WIDTH);
    }

    public void setBlockWidth(int i) {
        this.f_19804_.m_135381_(BLOCK_WIDTH, (Object)i);
    }

    public Direction getWallDirection() {
        return (Direction)this.f_19804_.m_135370_(DIRECTION);
    }

    public void setWallDirection(Direction direction) {
        this.f_19804_.m_135381_(DIRECTION, (Object)direction);
    }

    @Nullable
    public UUID getCreatorId() {
        return ((Optional)this.f_19804_.m_135370_(CREATOR_UUID)).orElse(null);
    }

    public void setCreatorId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CREATOR_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getCreator() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getCreatorId();
            if (id != null) {
                return ((ServerLevel)this.m_9236_()).m_8791_(id);
            }
            return null;
        }
        int id = (Integer)this.f_19804_.m_135370_(CREATOR_ID);
        return id < 0 ? null : this.m_9236_().m_6815_(id);
    }

    public boolean m_7337_(Entity entity) {
        return !this.isSameTeam(entity);
    }

    protected AABB m_142242_() {
        Direction direction2 = this.getWallDirection().m_122424_();
        float scale = (float)Math.min(10, Math.min(this.getLifespan(), this.f_19797_)) / 10.0f;
        float width = (float)this.getBlockWidth() / 2.0f * scale;
        float minX = -0.15f;
        float minY = -0.15f;
        float minZ = -0.15f;
        float maxX = 0.15f;
        float maxY = 0.15f;
        float maxZ = 0.15f;
        switch (direction2) {
            case NORTH: 
            case SOUTH: {
                minX = -width;
                maxX = width;
                minY = -width;
                maxY = width;
                break;
            }
            case EAST: 
            case WEST: {
                minZ = -width;
                maxZ = width;
                minY = -width;
                maxY = width;
                break;
            }
            case UP: 
            case DOWN: {
                minX = -width;
                maxX = width;
                minZ = -width;
                maxZ = width;
            }
        }
        return new AABB(this.m_20185_() + (double)minX, this.m_20186_() + (double)minY, this.m_20189_() + (double)minZ, this.m_20185_() + (double)maxX, this.m_20186_() + (double)maxY, this.m_20189_() + (double)maxZ);
    }

    public void m_6034_(double p_20210_, double p_20211_, double p_20212_) {
        this.m_20343_(p_20210_, p_20211_, p_20212_);
        this.m_20011_(this.m_142242_());
    }

    public void m_7350_(EntityDataAccessor<?> ac) {
        if (DIRECTION.equals(ac) || BLOCK_WIDTH.equals(ac)) {
            this.m_20011_(this.m_142242_());
        }
        super.m_7350_(ac);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isSameTeam(Entity entity) {
        Entity owner = this.getCreator();
        return owner instanceof LivingEntity && (TameableUtils.hasSameOwnerAs((LivingEntity)owner, entity) || owner.m_7307_(entity));
    }
}

