/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.item;

import com.github.yzqdev.pethome.PetHomeConfig;
import com.github.yzqdev.pethome.datagen.LangDefinition;
import com.github.yzqdev.pethome.server.entity.NetEntity;
import com.github.yzqdev.pethome.server.item.PHItemRegistry;
import com.github.yzqdev.pethome.server.item.Type;
import com.github.yzqdev.pethome.util.ItemMobTooltip;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NetItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Type type;
    static Set<String> warned;

    public NetItem(Type type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (world.f_46443_ || !NetItem.containsEntity(stack)) {
            return InteractionResult.FAIL;
        }
        Entity entity = NetItem.getEntityFromStack(stack, world, true);
        BlockPos blockPos = context.m_8083_();
        entity.m_19890_((double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
        stack.m_41751_(null);
        world.m_7967_(entity);
        context.m_43722_().m_41774_(1);
        if (player.m_7500_()) {
            player.m_21008_(context.m_43724_(), new ItemStack((ItemLike)PHItemRegistry.NET_ITEM.get()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target.m_20193_().f_46443_ || target instanceof Player || !target.m_6084_() || NetItem.containsEntity(stack)) {
            return InteractionResult.FAIL;
        }
        if (this.type == Type.EMPTY) {
            EntityType entityID = target.m_6095_();
            if (!NetItem.canCatchMob((Entity)target)) {
                return InteractionResult.FAIL;
            }
            ItemStack newStack = new ItemStack((ItemLike)PHItemRegistry.NET_HAS_ITEM.get());
            CompoundTag nbt = NetItem.getNBTfromEntity((Entity)target);
            ItemStack newerStack = newStack.m_41620_(1);
            newerStack.m_41784_().m_128365_("entity_holder", (Tag)nbt);
            player.m_6674_(hand);
            player.m_21008_(hand, newStack);
            if (!player.m_36356_(newerStack)) {
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), newerStack);
                player.m_9236_().m_7967_((Entity)itemEntity);
            }
            target.m_146870_();
            player.m_36335_().m_41524_((Item)this, 5);
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_142038_()) {
            entity.m_146915_(true);
        }
        if (!entity.m_20147_()) {
            entity.m_20331_(true);
        }
        Vec3 position = entity.m_20182_();
        int minY = entity.m_9236_().m_141937_();
        if (position.f_82480_ < (double)minY) {
            entity.m_20242_(true);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6034_(position.f_82479_, (double)minY, position.f_82481_);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (this.type == Type.HAS_MOB) {
            if (NetItem.containsEntity(stack)) {
                CompoundTag holder = NetItem.getEntityData(stack);
                String id = holder.m_128461_("id");
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)id));
                tooltip.add(type.m_20676_());
                tooltip.add((Component)Component.m_237115_((String)LangDefinition.ConstantMsg.health_text).m_130946_(": " + String.format("%.1f", NetItem.getEntityData(stack).m_128459_("Health"))));
            }
        } else {
            super.m_7373_(stack, level, tooltip, isAdvanced);
            tooltip.add((Component)Component.m_237115_((String)LangDefinition.ConstantMsg.net_launcher_default_only_tamable).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (this.type == Type.EMPTY) {
            return Optional.empty();
        }
        if (stack.m_41784_().m_128469_("entity_holder").m_128456_()) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41784_().m_128469_("entity_holder");
        return Optional.of(new ItemMobTooltip(tag));
    }

    public static RegistryAccess registryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().m_206579_();
        }
        return ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElseThrow()).m_9598_();
    }

    public static Component getNameFromStoredEntity(ItemStack stack) {
        CompoundTag holder;
        block3: {
            holder = NetItem.getEntityData(stack);
            if (holder.m_128425_("CustomName", 8)) {
                String s = holder.m_128461_("CustomName");
                try {
                    return Component.Serializer.m_130701_((String)s);
                }
                catch (Exception exception) {
                    if (warned.contains(s)) break block3;
                    LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                    warned.add(s);
                }
            }
        }
        String id = holder.m_128461_("id");
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)id));
        return type.m_20676_().m_6881_().m_130940_(ChatFormatting.AQUA);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Component nameC = super.m_7626_(stack);
        if (!NetItem.containsEntity(stack)) {
            return nameC;
        }
        return ((MutableComponent)nameC).m_130946_(" (").m_7220_(NetItem.getNameFromStoredEntity(stack)).m_130946_(")");
    }

    public NetEntity createNet(Level worldIn, LivingEntity shooter, ItemStack stack) {
        ItemStack newStack = stack.m_41777_();
        newStack.m_41764_(1);
        return new NetEntity(shooter.m_20185_(), shooter.m_20186_() + 1.25, shooter.m_20189_(), worldIn, newStack);
    }

    public static boolean containsEntity(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("entity_holder");
    }

    public static CompoundTag getEntityData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return new CompoundTag();
        }
        return NetItem.containsEntity(stack) ? tag.m_128469_("entity_holder") : new CompoundTag();
    }

    public static String getEntityID(CompoundTag nbt) {
        return nbt.m_128461_("id");
    }

    public static boolean isBlacklisted(EntityType<?> type) {
        return type == EntityType.f_20532_ || PetHomeConfig.mobcatcherBlackList.contains(type);
    }

    public static boolean canCatchMob(Entity livingEntity) {
        EntityType type = livingEntity.m_6095_();
        if (PetHomeConfig.mobcatcherOnlyTamableAnimal) {
            return livingEntity instanceof TamableAnimal && !NetItem.isBlacklisted(type);
        }
        return !NetItem.isBlacklisted(type);
    }

    public static Entity getEntityFromNBT(CompoundTag nbt, Level world, boolean withInfo) {
        Entity entity = ((EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.parse((String)NetItem.getEntityID(nbt)))).m_20615_(world);
        if (withInfo) {
            entity.m_20258_(nbt);
        }
        return entity;
    }

    public static Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        return NetItem.getEntityFromNBT(stack.m_41784_().m_128469_("entity_holder"), world, withInfo);
    }

    public static CompoundTag getNBTfromEntity(Entity entity) {
        CompoundTag nbt = new CompoundTag();
        entity.m_20223_(nbt);
        return nbt;
    }
}

