/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.item;

import com.github.yzqdev.pethome.datagen.LangDefinition;
import com.github.yzqdev.pethome.server.entity.NetEntity;
import com.github.yzqdev.pethome.server.item.NetItem;
import com.github.yzqdev.pethome.server.item.PHItemRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetLauncherItem
extends Item {
    public static final Component CAPTURE = Component.m_237115_((String)LangDefinition.ConstantMsg.capturing_text).m_130940_(ChatFormatting.GREEN);
    public static final Component RELEASE = Component.m_237115_((String)LangDefinition.ConstantMsg.release_text).m_130940_(ChatFormatting.RED);

    public NetLauncherItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)LangDefinition.ConstantMsg.net_launcher_tip).m_130940_(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.m_237115_((String)LangDefinition.ConstantMsg.net_launcher_default_only_tamable).m_130940_(ChatFormatting.GRAY));
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i < 0) {
                return;
            }
            float f = NetLauncherItem.getNetVelocity(i);
            if ((double)f >= 0.1) {
                if (!worldIn.f_46443_) {
                    if (NetLauncherItem.isCaptureMode(stack)) {
                        ItemStack netStack = new ItemStack((ItemLike)PHItemRegistry.NET_ITEM.get());
                        Item item = netStack.m_41720_();
                        if (item instanceof NetItem) {
                            NetItem netItem = (NetItem)item;
                            NetEntity netEntity = netItem.createNet(worldIn, (LivingEntity)player, netStack);
                            netEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 0.0f);
                            worldIn.m_7967_((Entity)netEntity);
                            stack.m_41622_(1, (LivingEntity)player, v -> {});
                        }
                    } else {
                        ItemStack netWithEntityStack = this.findNet(player);
                        if (netWithEntityStack.m_41619_()) {
                            player.m_213846_((Component)Component.m_237115_((String)LangDefinition.ConstantMsg.no_net_entity_text));
                            return;
                        }
                        Object netEntity = netWithEntityStack.m_41720_();
                        if (netEntity instanceof NetItem) {
                            NetItem netItem = (NetItem)((Object)netEntity);
                            netEntity = netItem.createNet(worldIn, (LivingEntity)player, netWithEntityStack);
                            netEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 0.0f);
                            worldIn.m_7967_((Entity)netEntity);
                            stack.m_41622_(1, (LivingEntity)player, v -> {});
                            netWithEntityStack.m_41774_(1);
                        }
                    }
                }
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("release_mode", false);
        stack.m_41751_(tag);
        return stack;
    }

    public static float getNetVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        f = Math.min(f, 1.5f);
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            boolean capture = NetLauncherItem.isCaptureMode(stack);
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("release_mode", capture);
            stack.m_41751_(tag);
            player.m_5661_(capture ? RELEASE : CAPTURE, true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (NetLauncherItem.isCaptureMode(stack)) {
            player.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        MutableComponent base = (MutableComponent)super.m_7626_(stack);
        return base.m_130946_(" (").m_7220_(NetLauncherItem.isCaptureMode(stack) ? CAPTURE : RELEASE).m_130946_(")");
    }

    protected ItemStack findNet(Player player) {
        ItemStack stack = player.m_21205_();
        if (NetLauncherItem.isFilledNet(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (NetLauncherItem.isFilledNet(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!NetLauncherItem.isFilledNet(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isEmptyNet(ItemStack stack) {
        return stack.m_41720_() instanceof NetItem && !NetItem.containsEntity(stack);
    }

    public static boolean isFilledNet(ItemStack stack) {
        return stack.m_41720_() instanceof NetItem && NetItem.containsEntity(stack);
    }

    public static boolean isCaptureMode(ItemStack stack) {
        boolean release = stack.m_41784_().m_128471_("release_mode");
        return !release;
    }
}

