/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.misc;

import com.github.yzqdev.pethome.server.misc.DITagRegistry;
import com.github.yzqdev.pethome.server.misc.DIVillagePieceRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class PetshopStructurePoolElement
extends LegacySinglePoolElement {
    public static final ResourceLocation CHEST = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"chests/petshop_chest");
    public static final ResourceLocation FISHTANK_MOBS = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"petstore_fishtank");
    public static final ResourceLocation CAGE_0_MOBS = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"petstore_cage_0");
    public static final ResourceLocation CAGE_1_MOBS = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"petstore_cage_1");
    public static final ResourceLocation CAGE_2_MOBS = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"petstore_cage_2");
    public static final ResourceLocation CAGE_3_MOBS = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"petstore_cage_3");
    private static boolean initializedMobLists = false;
    private static EntityType[] fishtankMobs = null;
    private static EntityType[] cage0Mobs = null;
    private static EntityType[] cage1Mobs = null;
    private static EntityType[] cage2Mobs = null;
    private static EntityType[] cage3Mobs = null;
    public static final Codec<PetshopStructurePoolElement> CODEC = RecordCodecBuilder.create(p_210357_ -> p_210357_.group((App)PetshopStructurePoolElement.m_210465_(), (App)PetshopStructurePoolElement.m_210462_(), (App)PetshopStructurePoolElement.m_210538_()).apply((Applicative)p_210357_, PetshopStructurePoolElement::new));

    protected PetshopStructurePoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> p_210349_, StructureTemplatePool.Projection p_210350_) {
        super(either, p_210349_, p_210350_);
    }

    public PetshopStructurePoolElement(ResourceLocation resourceLocation, Holder<StructureProcessorList> processors) {
        super(Either.left((Object)resourceLocation), processors, StructureTemplatePool.Projection.RIGID);
    }

    public void m_227329_(LevelAccessor levelAccessor, StructureTemplate.StructureBlockInfo structureBlockInfo, BlockPos pos, Rotation rotation, RandomSource random, BoundingBox box) {
        String contents = structureBlockInfo.f_74677_().m_128461_("metadata");
        if (!initializedMobLists) {
            fishtankMobs = this.getAllMatchingEntities(DITagRegistry.PETSTORE_FISHTANK).toArray(new EntityType[0]);
            cage0Mobs = this.getAllMatchingEntities(DITagRegistry.PETSTORE_CAGE_0).toArray(new EntityType[0]);
            cage1Mobs = this.getAllMatchingEntities(DITagRegistry.PETSTORE_CAGE_1).toArray(new EntityType[0]);
            cage2Mobs = this.getAllMatchingEntities(DITagRegistry.PETSTORE_CAGE_2).toArray(new EntityType[0]);
            cage3Mobs = this.getAllMatchingEntities(DITagRegistry.PETSTORE_CAGE_3).toArray(new EntityType[0]);
            initializedMobLists = true;
        }
        switch (contents) {
            case "petshop_water": {
                BlockState state = Blocks.f_49990_.m_49966_();
                float f = random.m_188501_();
                if (f < 0.5f) {
                    state = Blocks.f_50037_.m_49966_();
                } else if (f < 0.75f) {
                    state = (BlockState)(switch (random.m_188503_(5)) {
                        case 1 -> Blocks.f_50594_;
                        case 2 -> Blocks.f_50595_;
                        case 3 -> Blocks.f_50596_;
                        case 4 -> Blocks.f_50597_;
                        default -> Blocks.f_50598_;
                    }).m_49966_().m_61124_((Property)BaseCoralPlantTypeBlock.f_49158_, (Comparable)Boolean.valueOf(true));
                }
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_(), 2, random, fishtankMobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), state, 2);
                break;
            }
            case "petshop_chest": {
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 2);
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)levelAccessor, (RandomSource)random, (BlockPos)structureBlockInfo.f_74675_().m_7495_(), (ResourceLocation)CHEST);
                break;
            }
            case "petshop_cage_0": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_(), 1 + random.m_188503_(2), random, cage0Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 4);
                break;
            }
            case "petshop_cage_1": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_(), 2 + random.m_188503_(2), random, cage1Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 2);
                break;
            }
            case "petshop_cage_2": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_(), 1 + random.m_188503_(2), random, cage2Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 2);
                break;
            }
            case "petshop_cage_3": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_(), 1, random, cage3Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    private List<EntityType<?>> getAllMatchingEntities(TagKey<EntityType<?>> tag) {
        return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(type -> type.m_204039_(tag)).toList();
    }

    public void spawnAnimalsAt(LevelAccessor accessor, BlockPos at, int count, RandomSource random, EntityType ... types) {
        if (types.length > 0 && count > 0 && accessor.m_8055_(at).m_60734_() == Blocks.f_50677_ && accessor instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)accessor;
            for (int i = 0; i < count; ++i) {
                int index = types.length == 1 ? 0 : random.m_188503_(types.length - 1);
                Entity entity = types[index].m_20615_((Level)serverLevel.m_6018_());
                entity.m_146884_(Vec3.m_82539_((Vec3i)at));
                entity.m_146922_((float)(random.m_188503_(360) - 180));
                entity.m_146926_((float)(random.m_188503_(360) - 180));
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21530_();
                    mob.m_6518_(serverLevel, serverLevel.m_6436_(mob.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                }
                serverLevel.m_47205_(entity);
            }
        }
    }

    protected StructurePlaceSettings m_207169_(Rotation p_210421_, BoundingBox p_210422_, boolean p_210423_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings();
        structureplacesettings.m_74381_(p_210422_);
        structureplacesettings.m_74379_(p_210421_);
        structureplacesettings.m_74402_(true);
        structureplacesettings.m_74392_(false);
        structureplacesettings.m_74405_(true);
        if (!p_210423_) {
            structureplacesettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structureplacesettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)DIVillagePieceRegistry.PETSHOP.get();
    }

    public String toString() {
        return "PetShop[" + this.f_210411_ + "]";
    }
}

