/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.util;

import com.github.yzqdev.pethome.ModConstants;
import com.github.yzqdev.pethome.PetHomeConfig;
import com.github.yzqdev.pethome.util.GlobalUtil;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class FriendlyFireCommon {
    public static final TagKey<Item> BYPASS_PET = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"bypass_pet"));
    public static final TagKey<Item> BYPASS_ALL = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"bypass_all_protection"));
    public static final TagKey<EntityType<?>> GENERAL_PROTECTION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)GlobalUtil.res("general_protection"));
    public static final TagKey<EntityType<?>> PLAYER_PROTECTION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)GlobalUtil.res("player_protection"));
    public static final TagKey<EntityType<?>> BYPASSED_PROTECTION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)GlobalUtil.res("bypassed_entity_types"));

    public static void init() {
        ModConstants.LOG.debug("Protect children = {}", (Object)PetHomeConfig.protectChildren);
        ModConstants.LOG.debug("Protect pets from owner = {}", (Object)PetHomeConfig.protectPetsFromOwner);
        ModConstants.LOG.debug("Protect pets from pets = {}", (Object)PetHomeConfig.protectPetsFromPets);
        ModConstants.LOG.debug("Reflect damage = {}", (Object)PetHomeConfig.reflectDamage);
    }

    public static boolean preventAttack(Entity target, DamageSource source, float amount) {
        boolean preventDamage;
        Entity attacker = source.m_7639_();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (PetHomeConfig.displayHitWarning) {
                player.m_5661_((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237110_((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.m_7755_()}).m_130940_(ChatFormatting.WHITE)), true);
            }
        }
        return preventDamage;
    }

    public static boolean isProtected(Entity victim, Entity attacker, float amount) {
        AgeableMob agable;
        UUID ownerId;
        ItemStack heldItem;
        if (PetHomeConfig.noProtectionEntity.contains(victim.m_6095_())) {
            return false;
        }
        if (victim == null || attacker == null || attacker.m_6047_()) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            v0 = attackerLiving.m_21205_();
        } else {
            v0 = heldItem = ItemStack.f_41583_;
        }
        if (PetHomeConfig.canHurtAllItem.contains(heldItem.m_41720_())) {
            return false;
        }
        if (PetHomeConfig.otherShouldProtectionEntity.contains(victim.m_6095_())) {
            return true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (PetHomeConfig.playerCantHurtEntity.contains(victim.m_6095_())) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(victim)) != null && !PetHomeConfig.canHurtPetItem.contains(heldItem.m_41720_())) {
            if (PetHomeConfig.protectPetsFromOwner && ownerId.equals(attacker.m_20148_())) {
                if (PetHomeConfig.reflectDamage) {
                    attacker.m_6469_(attacker.m_9236_().m_269111_().m_269264_(), amount);
                }
                return true;
            }
            if (PetHomeConfig.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        if (PetHomeConfig.protectTeamMembers && FriendlyFireCommon.isOnProtectedTeam(attacker, victim)) {
            return true;
        }
        return PetHomeConfig.protectChildren && attacker instanceof Player && !(victim instanceof Enemy) && victim instanceof AgeableMob && (agable = (AgeableMob)victim).m_6162_() && !attacker.m_6047_();
    }

    public static boolean isOnProtectedTeam(Entity attacker, Entity victim) {
        PlayerTeam attackerTeam = FriendlyFireCommon.getEffectiveTeam(attacker);
        PlayerTeam victimTeam = FriendlyFireCommon.getEffectiveTeam(victim);
        return attackerTeam != null && victimTeam != null && attackerTeam.m_83536_((Team)victimTeam) && victimTeam.m_83536_((Team)attackerTeam) && (!PetHomeConfig.respectTeamRules || !victimTeam.m_6260_());
    }

    @Nullable
    public static PlayerTeam getEffectiveTeam(Entity entity) {
        OwnableEntity ownable;
        PlayerTeam directTeam = (PlayerTeam)entity.m_5647_();
        if (directTeam == null && entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_21805_() != null) {
            ServerLevel server;
            GameProfile fetchResult;
            if (ownable.m_269323_() != null) {
                return (PlayerTeam)ownable.m_269323_().m_5647_();
            }
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel && (fetchResult = (GameProfile)(server = (ServerLevel)level).m_7654_().m_129927_().m_11002_(ownable.m_21805_()).orElse(null)) != null) {
                return entity.m_9236_().m_6188_().m_83500_(fetchResult.getName());
            }
        }
        return directTeam;
    }

    @Nullable
    public static UUID getOwner(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.m_21805_();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.m_21805_();
        }
        return null;
    }
}

