#!/usr/bin/env bash

for origin in origins/*.json; do
  oname=$(jq -r '.name // empty' "$origin")
  odesc=$(jq -r '.description // empty' "$origin")

  echo "## ${oname}"
  echo
  echo "${odesc}"
  echo

  # Get powers as newline-separated list
  powers=$(jq -r '
    if .powers == null then empty
    elif (.powers | type) == "array" then .powers[]
    elif (.powers | type) == "object" then (.powers | keys[])
    else empty end
  ' "$origin")

  # Loop over each power ID
  while IFS= read -r raw_power; do
    [[ -z "$raw_power" ]] && continue
    pid="${raw_power##*:}"  # strip namespace
    power_file="powers/${pid}.json"

    if [[ -f "$power_file" ]]; then
      pname=$(jq -r '.name // empty' "$power_file")
      pdesc=$(jq -r '.description // empty' "$power_file")
    else
      pname=$(jq -r --arg pid "$pid" --arg raw "$raw_power" '(.powers[$pid].name // .powers[$raw].name) // empty' "$origin")
      pdesc=$(jq -r --arg pid "$pid" --arg raw "$raw_power" '(.powers[$pid].description // .powers[$raw].description) // empty' "$origin")
    fi

    if [[ -n "$pname" ]]; then
      echo "### ${pname}"
      echo
      echo "${pdesc}"
      echo
    else
      echo "### ${pid}"
      echo
      echo "(description not found)"
      echo
    fi
  done <<< "$powers"
done
