/*
 * Decompiled with CFR 0.152.
 */
package com.smibii.cameraman.camera;

import com.smibii.cameraman.camera.CameraManagerSettings;
import com.smibii.cameraman.camera.CameraPoint;
import com.smibii.cameraman.camera.CameraPointAccessor;
import com.smibii.cameraman.events.TransitionCompletedEvent;
import com.smibii.cameraman.math.Easing;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CameraManager {
    private final Map<String, CameraPoint> pointMap = new HashMap<String, CameraPoint>();
    private String currentPointName = "#player";
    private Vec3 currentPos = Vec3.f_82478_;
    private float currentYaw = 0.0f;
    private float currentPitch = 0.0f;
    private float currentFov = 0.5f;
    private float currentTilt = 0.0f;
    private boolean detached = true;
    private CameraPoint startPoint;
    private CameraPoint endPoint;
    private long startTime;
    private boolean isTransitioning = false;
    private boolean inUse = false;
    private float playerYaw = 0.0f;
    private float playerPitch = 0.0f;
    public CameraManagerSettings settings;

    public CameraManager(CameraManagerSettings settings) {
        this.settings = settings;
    }

    private CameraPoint getPlayerPoint(long duration, Function<Double, Double> easing) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            throw new RuntimeException("LocalPlayer doesn't exist");
        }
        this.playerYaw = player.m_146908_();
        this.playerPitch = player.m_146909_();
        return CameraPoint.of(new Vec3(player.m_20185_(), player.m_20186_() + 1.62, player.m_20189_()), this.playerYaw, this.playerPitch, (float)((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue() / 100.0f, duration, easing, false);
    }

    public CameraPointAccessor registerPoint(String name, CameraPoint point) {
        this.pointMap.put(name, point);
        return new CameraPointAccessor(name, point);
    }

    public void transitionFromPointToPoint(CameraPoint pointA, CameraPoint pointB, String pointBName) {
        if (pointA == null || pointB == null) {
            throw new IllegalArgumentException("pointA or pointB is null!");
        }
        this.startPoint = pointA;
        this.currentPointName = pointBName;
        this.endPoint = pointB;
        this.currentPos = pointA.pos();
        this.currentYaw = pointA.yaw();
        this.currentPitch = pointA.pitch();
        this.currentFov = pointA.fov();
        this.currentTilt = pointA.tilt();
        this.detached = pointB.detached();
        this.startTime = System.currentTimeMillis();
        this.isTransitioning = true;
    }

    public void transitionToPoint(String name) {
        if (!this.pointMap.containsKey(name)) {
            throw new IllegalArgumentException("Key " + name + " does not exist in pointMap");
        }
        if (this.currentPointName.equals("#player")) {
            this.transitionFromPlayerToPoint(name);
            return;
        }
        this.setInUse(true);
        this.transitionFromPointToPoint(this.endPoint, this.pointMap.get(name), name);
    }

    public void transitionFromPlayerToPoint(String name) {
        if (!this.pointMap.containsKey(name)) {
            throw new IllegalArgumentException("Key " + name + " does not exist in pointMap");
        }
        this.endPoint = this.getPlayerPoint(1000L, Easing::easeInOutQuad);
        this.setInUse(true);
        this.transitionFromPointToPoint(this.endPoint, this.pointMap.get(name), name);
    }

    public void transitionToPlayer() {
        this.transitionToPlayer(1000L);
    }

    public void transitionToPlayer(long duration) {
        this.transitionToPlayer(duration, Easing::easeInOutQuad);
    }

    public void transitionToPlayer(long duration, Function<Double, Double> easing) {
        if (!this.inUse) {
            return;
        }
        CameraPoint playerPoint = this.getPlayerPoint(duration, easing);
        this.transitionFromPointToPoint(this.endPoint, playerPoint, "#player");
        Executors.newSingleThreadScheduledExecutor().schedule(() -> this.setInUse(false), duration, TimeUnit.MILLISECONDS);
    }

    public void tickFrame() {
        if (!this.isTransitioning) {
            return;
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        double t = Math.min(1.0, (double)elapsed / (double)this.endPoint.duration());
        Function<Double, Double> easing = this.endPoint.easing();
        if (easing == null) {
            easing = Easing::easeInOutQuad;
        }
        double eased = easing.apply(t);
        this.currentPos = this.lerp(this.startPoint.pos(), this.endPoint.pos(), eased);
        this.currentYaw = this.lerpAngle(this.startPoint.yaw(), this.endPoint.yaw(), eased);
        this.currentPitch = (float)Mth.m_14139_((double)eased, (double)this.startPoint.pitch(), (double)this.endPoint.pitch());
        this.currentFov = (float)Mth.m_14139_((double)eased, (double)this.startPoint.fov(), (double)this.endPoint.fov());
        this.currentTilt = this.lerpAngle(this.startPoint.tilt(), this.endPoint.tilt(), eased);
        if (t >= 1.0) {
            MinecraftForge.EVENT_BUS.post((Event)new TransitionCompletedEvent(this.endPoint, this.currentPointName));
            this.isTransitioning = false;
        }
    }

    private Vec3 lerp(Vec3 from, Vec3 to, double t) {
        return new Vec3(Mth.m_14139_((double)t, (double)from.f_82479_, (double)to.f_82479_), Mth.m_14139_((double)t, (double)from.f_82480_, (double)to.f_82480_), Mth.m_14139_((double)t, (double)from.f_82481_, (double)to.f_82481_));
    }

    private float lerpAngle(float a, float b, double t) {
        float delta = (b - a + 540.0f) % 360.0f - 180.0f;
        return a + (float)t * delta;
    }

    public void setInUse(boolean value) {
        this.inUse = value;
        if (!value) {
            this.currentPointName = "#player";
        }
    }

    public void setCurrentPointName(String name) {
        this.currentPointName = name;
    }

    public Vec3 getCurrentPos() {
        return this.currentPos;
    }

    public float getCurrentYaw() {
        return this.currentYaw;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public float getCurrentFov() {
        return this.currentFov;
    }

    public String getCurrentPointName() {
        return this.currentPointName;
    }

    public float getPlayerYaw() {
        return this.playerYaw;
    }

    public float getPlayerPitch() {
        return this.playerPitch;
    }

    public float getCurrentTilt() {
        return this.currentTilt;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public boolean isInUse() {
        return this.inUse;
    }
}

