/*
 * Decompiled with CFR 0.152.
 */
package com.smibii.cameraman.listeners;

import com.mojang.blaze3d.systems.RenderSystem;
import com.smibii.cameraman.camera.CameraManager;
import com.smibii.cameraman.camera.CameraManagerSettings;
import com.smibii.cameraman.events.CameraManagerSetupEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;

@Mod.EventBusSubscriber(modid="cameraman", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Camera {
    public static CameraManager manager = new CameraManager(new CameraManagerSettings(true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true));
    private static boolean initialized = false;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!initialized) {
            MinecraftForge.EVENT_BUS.post((Event)new CameraManagerSetupEvent(manager));
            initialized = true;
        }
        manager.tickFrame();
    }

    @SubscribeEvent
    public static void modifyFov(ComputeFovModifierEvent event) {
        if (!manager.isInUse()) {
            return;
        }
        event.setNewFovModifier(manager.getCurrentFov());
    }

    @SubscribeEvent
    public static void onInteraction(InputEvent.InteractionKeyMappingTriggered event) {
        if (manager.isInUse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        if (manager.isInUse() && !Camera.manager.settings.playerCanInteract()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInputUpdate(MovementInputUpdateEvent event) {
        if (!manager.isInUse()) {
            return;
        }
        Input input = event.getInput();
        input.f_108566_ = 0.0f;
        input.f_108567_ = 0.0f;
        input.f_108572_ = false;
        input.f_108573_ = false;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !manager.isInUse() || Camera.manager.settings.playerCanLookAround()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        player.m_146922_(manager.getPlayerYaw());
        player.m_146926_(manager.getPlayerPitch());
        player.f_20885_ = manager.getPlayerYaw();
        player.f_20883_ = manager.getPlayerPitch();
    }

    @SubscribeEvent
    public static void onRender(RenderGuiOverlayEvent.Pre event) {
        if (!manager.isInUse()) {
            return;
        }
        String overlayId = event.getOverlay().id().m_135815_();
        CameraManagerSettings settings = Camera.manager.settings;
        if (!settings.drawAir() && overlayId.equals("air_level")) {
            event.setCanceled(true);
        } else if (!settings.drawArmor() && overlayId.equals("armor_level")) {
            event.setCanceled(true);
        } else if (!settings.drawBossbar() && overlayId.equals("boss_event_progress")) {
            event.setCanceled(true);
        } else if (!settings.drawCrosshair() && overlayId.equals("crosshair")) {
            event.setCanceled(true);
        } else if (!settings.drawExperience() && overlayId.equals("experience_bar")) {
            event.setCanceled(true);
        } else if (!settings.drawFood() && overlayId.equals("food_level")) {
            event.setCanceled(true);
        } else if (!settings.drawFrostbite() && overlayId.equals("frostbite")) {
            event.setCanceled(true);
        } else if (!settings.drawHealth() && overlayId.equals("player_health")) {
            event.setCanceled(true);
        } else if (!settings.drawHelmet() && overlayId.equals("helmet")) {
            event.setCanceled(true);
        } else if (!settings.drawHotbar() && overlayId.equals("hotbar")) {
            event.setCanceled(true);
        } else if (!settings.drawItemName() && overlayId.equals("item_name")) {
            event.setCanceled(true);
        } else if (!settings.drawJumpBar() && overlayId.equals("jump_bar")) {
            event.setCanceled(true);
        } else if (!settings.drawMountHealth() && overlayId.equals("mount_health")) {
            event.setCanceled(true);
        } else if (!settings.drawPortal() && overlayId.equals("portal")) {
            event.setCanceled(true);
        } else if (!settings.drawPotions() && overlayId.equals("potion_icons")) {
            event.setCanceled(true);
        } else if (!settings.drawSleepFade() && overlayId.equals("sleep_fade")) {
            event.setCanceled(true);
        } else if (!settings.drawSpyglass() && overlayId.equals("spyglass")) {
            event.setCanceled(true);
        } else if (!settings.drawVignette() && overlayId.equals("vignette")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        if (!manager.isInUse()) {
            return;
        }
        if (!Camera.manager.settings.renderHand()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        if (manager.getCurrentTilt() == 0.0f) {
            return;
        }
        RenderSystem.getModelViewStack().m_85836_();
        float radians = (float)Math.toRadians(manager.getCurrentTilt());
        Quaternionf quaternionf = new Quaternionf().rotateZ(manager.getCurrentTilt());
        RenderSystem.getModelViewStack().m_252781_(quaternionf);
    }

    @SubscribeEvent
    public static void onRenderWorldEnd(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        if (manager.getCurrentTilt() == 0.0f) {
            return;
        }
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

