/*
 * Decompiled with CFR 0.152.
 */
package com.smibii.cameraman.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.smibii.cameraman.network.CameraSetInUsePacket;
import com.smibii.cameraman.network.CameraToPlayerPacket;
import com.smibii.cameraman.network.CameraToPointPacket;
import com.smibii.cameraman.network.NetworkHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cameraman", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BrunoCommand {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        BrunoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bruno").requires(command -> command.m_6761_(2))).then(Commands.m_82127_((String)"transition").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return BrunoCommand.transition(source, name);
        })))).then(Commands.m_82127_((String)"exit").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return BrunoCommand.exit(source);
        })));
    }

    private static int transition(CommandSourceStack source, String name) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (name.equals("player")) {
            NetworkHandler.sendToClient(new CameraToPlayerPacket(), player);
            source.m_288197_(() -> Component.m_237113_((String)("Transitioned player " + player.m_7755_().getString() + " to its LocalPlayer position")), false);
        } else {
            NetworkHandler.sendToClient(new CameraToPointPacket(name), player);
            source.m_288197_(() -> Component.m_237113_((String)("Transitioned player " + player.m_7755_().getString() + " to " + name)), false);
        }
        return 1;
    }

    private static int exit(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        NetworkHandler.sendToClient(new CameraSetInUsePacket(false), player);
        source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " exit camera!")), false);
        return 1;
    }
}

