/*
 * Decompiled with CFR 0.152.
 */
package com.smibii.cameraman.network;

import com.smibii.cameraman.camera.CameraPoint;
import com.smibii.cameraman.listeners.Camera;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CameraRegisterPointPacket {
    private final String name;
    private final CameraPoint point;

    public CameraRegisterPointPacket(String name, CameraPoint point) {
        this.name = name;
        this.point = point;
    }

    public static void encode(CameraRegisterPointPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        msg.point.write(buf);
    }

    public static CameraRegisterPointPacket decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        CameraPoint point = CameraPoint.read(buf);
        return new CameraRegisterPointPacket(name, point);
    }

    public static void handle(CameraRegisterPointPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Camera.manager.registerPoint(msg.name, msg.point));
        ctx.get().setPacketHandled(true);
    }
}

