/*
 * Decompiled with CFR 0.152.
 */
package libs.yaml.engine;

import java.util.Map;
import libs.yaml.YamlDocument;
import libs.yaml.block.Block;
import libs.yaml.block.Comments;
import libs.yaml.block.implementation.Section;
import libs.yaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import libs.yaml.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import libs.yaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import libs.yaml.libs.org.snakeyaml.engine.v2.representer.StandardRepresenter;
import libs.yaml.settings.dumper.DumperSettings;
import libs.yaml.settings.general.GeneralSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedRepresenter
extends StandardRepresenter {
    private final GeneralSettings generalSettings;
    private final DumperSettings dumperSettings;

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumperSettings dumperSettings, @NotNull DumpSettings engineSettings) {
        super(engineSettings);
        this.generalSettings = generalSettings;
        this.dumperSettings = dumperSettings;
        RepresentSection representSection = new RepresentSection();
        RepresentSerializable representSerializable = new RepresentSerializable();
        this.representers.put(Section.class, representSection);
        this.representers.put(YamlDocument.class, representSection);
        this.representers.put(Enum.class, new RepresentEnum());
        this.representers.put(String.class, new RepresentString((RepresentToNode)this.representers.get(String.class)));
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedClasses()) {
            this.representers.put(clazz, representSerializable);
        }
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedParentClasses()) {
            this.parentClassRepresenters.put(clazz, representSerializable);
        }
    }

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumperSettings dumperSettings) {
        this(generalSettings, dumperSettings, dumperSettings.buildEngineSettings());
    }

    @NotNull
    public Node applyKeyComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.AFTER));
        }
        return node;
    }

    @NotNull
    public Node applyValueComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.AFTER));
        }
        return node;
    }

    @Override
    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        Block block = entry.getValue() instanceof Block ? (Block)entry.getValue() : null;
        Node key = this.applyKeyComments(block, this.representData(entry.getKey()));
        Node value = this.applyValueComments(block, this.representData(block == null ? entry.getValue() : block.getStoredValue()));
        return new NodeTuple(key, value);
    }

    private class RepresentString
    implements RepresentToNode {
        private final RepresentToNode previous;

        private RepresentString(RepresentToNode previous) {
            this.previous = previous;
        }

        @Override
        public Node representData(Object data) {
            ScalarStyle previousStyle = ExtendedRepresenter.this.defaultScalarStyle;
            ExtendedRepresenter.this.defaultScalarStyle = ExtendedRepresenter.this.dumperSettings.getStringStyle();
            Node node = this.previous.representData(data);
            ExtendedRepresenter.this.defaultScalarStyle = previousStyle;
            return node;
        }
    }

    private class RepresentEnum
    implements RepresentToNode {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object data) {
            return ExtendedRepresenter.this.representData(((Enum)data).name());
        }
    }

    private class RepresentSection
    implements RepresentToNode {
        private RepresentSection() {
        }

        @Override
        public Node representData(Object data) {
            Section section = (Section)data;
            return ExtendedRepresenter.this.applyKeyComments(section, ExtendedRepresenter.this.representData(section.getStoredValue()));
        }
    }

    private class RepresentSerializable
    implements RepresentToNode {
        private RepresentSerializable() {
        }

        @Override
        public Node representData(Object data) {
            Map<Object, Object> serialized = ExtendedRepresenter.this.generalSettings.getSerializer().serialize(data, ExtendedRepresenter.this.generalSettings.getDefaultMapSupplier());
            return ExtendedRepresenter.this.representData(serialized == null ? data : serialized);
        }
    }
}

