/*
 * Decompiled with CFR 0.152.
 */
package libs.yaml.libs.org.snakeyaml.engine.v2.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import libs.yaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import libs.yaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import libs.yaml.libs.org.snakeyaml.engine.v2.nodes.Tag;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, FlowStyle flowStyle, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(tag, flowStyle, startMark, endMark);
        Objects.requireNonNull(value, "value in a Node is required.");
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, FlowStyle flowStyle) {
        this(tag, true, value, flowStyle, Optional.empty(), Optional.empty());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SEQUENCE;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }
}

