/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import libs.yaml.YamlDocument;
import libs.yaml.dvs.versioning.BasicVersioning;
import libs.yaml.settings.dumper.DumperSettings;
import libs.yaml.settings.general.GeneralSettings;
import libs.yaml.settings.loader.LoaderSettings;
import libs.yaml.settings.updater.UpdaterSettings;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.neziw.wallet.basic.Metrics;
import xyz.neziw.wallet.basic.PlayerInput;
import xyz.neziw.wallet.basic.UpdateChecker;
import xyz.neziw.wallet.commands.impl.ShopCommand;
import xyz.neziw.wallet.commands.impl.WalletAdminCommand;
import xyz.neziw.wallet.commands.impl.WalletCommand;
import xyz.neziw.wallet.listeners.PlayerJoinListener;
import xyz.neziw.wallet.listeners.PlayerQuitListener;
import xyz.neziw.wallet.loaders.ShopsLoader;
import xyz.neziw.wallet.managers.CommandManager;
import xyz.neziw.wallet.managers.DataManager;
import xyz.neziw.wallet.managers.DatabaseManager;
import xyz.neziw.wallet.managers.HookManager;
import xyz.neziw.wallet.managers.UserManager;
import xyz.neziw.wallet.tasks.SaveTaskRunnable;

public class WalletPlugin
extends JavaPlugin {
    private static WalletPlugin instance;
    private YamlDocument mainConfig;
    private YamlDocument messagesConfig;
    private YamlDocument confirmationMenuConfig;
    private UserManager userManager;
    private DatabaseManager databaseManager;
    private HookManager hookManager;
    private ShopsLoader shopsLoader;
    private DataManager dataManager;

    public void onEnable() {
        instance = this;
        this.mainConfig = YamlDocument.create(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build());
        this.messagesConfig = YamlDocument.create(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build());
        this.confirmationMenuConfig = YamlDocument.create(new File(this.getDataFolder(), "confirmation-menu.yml"), this.getResource("confirmation-menu.yml"));
        this.userManager = new UserManager();
        this.databaseManager = new DatabaseManager(this, this.mainConfig);
        this.hookManager = new HookManager(this, this.mainConfig);
        this.shopsLoader = new ShopsLoader(this);
        this.dataManager = new DataManager(this.userManager, this.databaseManager);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerQuitListener(this.userManager, this.databaseManager), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerJoinListener(this, this.userManager, this.databaseManager, this.mainConfig), (Plugin)this);
        pluginManager.registerEvents(PlayerInput.handle(), (Plugin)this);
        CommandManager commandManager = new CommandManager(this);
        commandManager.registerCommand(new WalletCommand(this.userManager, this.mainConfig, this.messagesConfig));
        commandManager.registerCommand(new WalletAdminCommand(this.userManager, this.mainConfig, this.messagesConfig, this.dataManager));
        commandManager.registerCommand(new ShopCommand(this.shopsLoader, this.mainConfig, this.messagesConfig));
        if (this.mainConfig.getBoolean("auto-data-save").booleanValue()) {
            this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new SaveTaskRunnable(this.userManager, this.databaseManager), 0L, 6000L);
        }
        new Metrics(this, 17633);
        this.exampleShop();
        this.updateCheck();
    }

    public void onDisable() {
        if (this.userManager != null && this.databaseManager != null) {
            this.databaseManager.getExecutor().shutdown();
            this.userManager.getUsers().values().forEach(this.databaseManager::saveUser);
        }
    }

    private void exampleShop() {
        File file = new File(this.getDataFolder(), "shops");
        if (!file.isDirectory()) {
            throw new UnsupportedOperationException("Shops folder is not directory");
        }
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/shops/example-shop.yml");){
                File exampleShop = new File(file, "example-shop.yml");
                Files.copy(inputStream, exampleShop.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void updateCheck() {
        if (!this.mainConfig.getBoolean("update-checker").booleanValue()) {
            return;
        }
        new UpdateChecker(this, 107826).getVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                this.getLogger().info("There is not a new update available.");
            } else {
                this.getLogger().info("There is a new update available.");
                this.getLogger().info("Your version " + this.getDescription().getVersion() + " new version " + version);
            }
        });
    }

    public static WalletPlugin getInstance() {
        return instance;
    }

    public YamlDocument getMainConfig() {
        return this.mainConfig;
    }

    public YamlDocument getMessagesConfig() {
        return this.messagesConfig;
    }

    public YamlDocument getConfirmationMenuConfig() {
        return this.confirmationMenuConfig;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public ShopsLoader getShopsLoader() {
        return this.shopsLoader;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }
}

