/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import xyz.neziw.wallet.WalletPlugin;
import xyz.neziw.wallet.basic.InputRunnable;
import xyz.neziw.wallet.utilities.ColorUtils;

public class PlayerInput {
    private static final Map<UUID, PlayerInput> inputs = new HashMap<UUID, PlayerInput>();
    private final UUID uuid;
    private final InputRunnable runGo;
    private final InputRunnable runCancel;
    private final BukkitTask taskId;

    public PlayerInput(final Player player, InputRunnable correct, InputRunnable cancel) {
        this.uuid = player.getUniqueId();
        this.runGo = correct;
        this.runCancel = cancel;
        this.taskId = new BukkitRunnable(){

            public void run() {
                player.sendTitle(ColorUtils.fix("&a&lType value"), ColorUtils.fix("&7on the chat!"), 0, 21, 0);
            }
        }.runTaskTimer((Plugin)WalletPlugin.getInstance(), 0L, 20L);
        this.register();
    }

    private void register() {
        inputs.put(this.uuid, this);
    }

    private void unRegister() {
        inputs.remove(this.uuid);
    }

    public static Listener handle() {
        return new Listener(){

            @EventHandler
            public void onChatInput(AsyncPlayerChatEvent event) {
                Player player = event.getPlayer();
                String input = event.getMessage();
                UUID uuid = player.getUniqueId();
                if (inputs.containsKey(uuid)) {
                    PlayerInput current = inputs.get(uuid);
                    event.setCancelled(true);
                    if (input.equalsIgnoreCase("cancel")) {
                        player.sendMessage(ColorUtils.fix("&cCancelled input!"));
                        current.taskId.cancel();
                        player.sendTitle("", "", 0, 5, 0);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)WalletPlugin.getInstance(), () -> current.runCancel.run(input), 3L);
                        current.unRegister();
                        return;
                    }
                    current.taskId.cancel();
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)WalletPlugin.getInstance(), () -> current.runGo.run(input), 3L);
                    player.sendTitle("", "", 0, 5, 0);
                    current.unRegister();
                }
            }
        };
    }
}

