/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.commands.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import libs.yaml.YamlDocument;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.neziw.wallet.commands.WCommand;
import xyz.neziw.wallet.loaders.ShopsLoader;
import xyz.neziw.wallet.menu.ShopMenu;
import xyz.neziw.wallet.utilities.ColorUtils;

public class ShopCommand
extends WCommand {
    private final ShopsLoader shopsLoader;
    private final YamlDocument messages;

    public ShopCommand(ShopsLoader shopsLoader, YamlDocument config, YamlDocument messages) {
        super(config.getString("commands-aliases.shop.command"), "", config.getStringList("commands-aliases.shop.aliases"));
        this.shopsLoader = shopsLoader;
        this.messages = messages;
    }

    @Override
    public void exec(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                player.sendMessage(ColorUtils.fix(this.messages.getString("errors.incorrect-usage")));
            } else if (this.shopsLoader.getShops().get(args[0]) != null) {
                new ShopMenu(this.shopsLoader.getShops().get(args[0]), player);
            } else {
                player.sendMessage(ColorUtils.fix(this.messages.getString("errors.shop-not-exists")));
            }
        } else {
            sender.sendMessage(ColorUtils.fix(this.messages.getString("errors.player-only")));
        }
    }

    @Override
    public List<String> complete(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>();
        String search = args[0].toLowerCase(Locale.ROOT);
        for (String shop : this.shopsLoader.getShops().keySet()) {
            if (!shop.toLowerCase(Locale.ROOT).startsWith(search)) continue;
            matches.add(shop);
        }
        return matches;
    }
}

