/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.loaders;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import xyz.neziw.wallet.WalletPlugin;
import xyz.neziw.wallet.objects.Product;
import xyz.neziw.wallet.objects.Shop;

public class ShopsLoader {
    private final WalletPlugin plugin;
    private final HashMap<String, Shop> shops = new HashMap();

    public ShopsLoader(WalletPlugin plugin) {
        this.plugin = plugin;
        this.loadShops();
    }

    public void loadShops() {
        File dataFolder = new File(this.plugin.getDataFolder(), "shops");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        ArrayList<YamlConfiguration> configs = new ArrayList<YamlConfiguration>();
        for (File file : dataFolder.listFiles()) {
            configs.add(YamlConfiguration.loadConfiguration((File)file));
        }
        for (FileConfiguration fileConfiguration : configs) {
            Shop shop = new Shop(fileConfiguration.getString("name"), fileConfiguration.getString("shop-title"), fileConfiguration.getInt("shop-size"), fileConfiguration);
            for (String string : fileConfiguration.getConfigurationSection("products").getKeys(false)) {
                Product product = new Product(string, fileConfiguration.getString("products." + string + ".item-name"), fileConfiguration.getInt("products." + string + ".item-slot"), fileConfiguration.getString("products." + string + ".item-material"), fileConfiguration.getDouble("products." + string + ".cost"));
                product.setLore(fileConfiguration.getStringList("products." + string + ".item-lore"));
                product.setCommands(fileConfiguration.getStringList("products." + string + ".commands"));
                shop.getProducts().put(string, product);
            }
            this.shops.put(fileConfiguration.getString("name"), shop);
        }
    }

    public void reload() {
        this.unloadShops();
        this.loadShops();
    }

    private void unloadShops() {
        this.shops.clear();
    }

    public HashMap<String, Shop> getShops() {
        return this.shops;
    }
}

