/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.managers;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xyz.neziw.wallet.managers.DatabaseManager;
import xyz.neziw.wallet.managers.UserManager;
import xyz.neziw.wallet.objects.WalletUser;

public class DataManager {
    private final UserManager userManager;
    private final DatabaseManager databaseManager;

    public void setBalance(String name, double balance) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            WalletUser user = this.userManager.getUser(player.getUniqueId());
            user.setBalance(balance);
            this.databaseManager.saveUser(user);
        } else {
            this.databaseManager.setBalanceByName(name, balance);
        }
    }

    public void depositBalance(String name, double balance) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            WalletUser user = this.userManager.getUser(player.getUniqueId());
            user.setBalance(user.getBalance() + balance);
            this.databaseManager.saveUser(user);
        } else {
            this.databaseManager.deposit(name, balance);
        }
    }

    public void withDrawBalance(String name, double balance) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            WalletUser user = this.userManager.getUser(player.getUniqueId());
            user.setBalance(user.getBalance() - balance);
            this.databaseManager.saveUser(user);
        } else {
            this.databaseManager.withDraw(name, balance);
        }
    }

    public double getBalance(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            WalletUser user = this.userManager.getUser(player.getUniqueId());
            return user.getBalance();
        }
        return this.databaseManager.getBalanceByName(name);
    }

    public boolean exists(String name) {
        return this.databaseManager.exists(name);
    }

    public DataManager(UserManager userManager, DatabaseManager databaseManager) {
        this.userManager = userManager;
        this.databaseManager = databaseManager;
    }
}

