/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.managers;

import java.util.HashMap;
import java.util.Map;
import libs.yaml.YamlDocument;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import xyz.neziw.wallet.WalletPlugin;
import xyz.neziw.wallet.hooks.IHook;
import xyz.neziw.wallet.hooks.impl.GadgetsMenuHook;
import xyz.neziw.wallet.hooks.impl.PlaceholderHook;
import xyz.neziw.wallet.hooks.impl.VaultHook;

public class HookManager {
    private final Map<Class<?>, IHook> hooks = new HashMap();
    private final WalletPlugin plugin;

    public HookManager(WalletPlugin plugin, YamlDocument config) {
        this.plugin = plugin;
        if (config.getBoolean("hook-placeholder-api").booleanValue()) {
            this.hooks.put(PlaceholderHook.class, new PlaceholderHook());
        }
        if (config.getBoolean("hook-gadgets-menu").booleanValue()) {
            this.hooks.put(GadgetsMenuHook.class, new GadgetsMenuHook(this.plugin));
        }
        if (config.getBoolean("hook-vault-api").booleanValue()) {
            VaultHook vaultHook = new VaultHook(this.plugin, this.plugin.getDataManager());
            this.plugin.getServer().getServicesManager().register(Economy.class, (Object)vaultHook, (Plugin)this.plugin, ServicePriority.High);
            this.hooks.put(VaultHook.class, vaultHook);
        }
        this.startHooks();
    }

    private void startHooks() {
        for (IHook hook : this.hooks.values()) {
            hook.hook(this.plugin);
        }
    }

    public Map<Class<?>, IHook> getHooks() {
        return this.hooks;
    }
}

