/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.menu;

import java.util.List;
import libs.gui.builder.gui.SimpleBuilder;
import libs.gui.builder.item.ItemBuilder;
import libs.gui.guis.Gui;
import libs.gui.guis.GuiItem;
import libs.yaml.YamlDocument;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.neziw.wallet.WalletPlugin;
import xyz.neziw.wallet.managers.DataManager;
import xyz.neziw.wallet.managers.UserManager;
import xyz.neziw.wallet.menu.ShopMenu;
import xyz.neziw.wallet.objects.Product;
import xyz.neziw.wallet.objects.Shop;
import xyz.neziw.wallet.objects.WalletUser;
import xyz.neziw.wallet.utilities.ColorUtils;

public class ConfirmationMenu {
    private final WalletPlugin plugin = WalletPlugin.getInstance();
    private final YamlDocument menuConfig = this.plugin.getConfirmationMenuConfig();
    private final YamlDocument messages = this.plugin.getMessagesConfig();
    private final UserManager userManager = this.plugin.getUserManager();
    private final DataManager dataManager = this.plugin.getDataManager();
    private final Product product;
    private final Shop shop;
    private final WalletUser user;

    public ConfirmationMenu(Product product, Shop shop, Player player) {
        this.product = product;
        this.shop = shop;
        this.user = this.userManager.getUser(player.getUniqueId());
        this.open(player);
    }

    private void open(Player player) {
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(Component.text(this.menuConfig.getString("menu-settings.gui-title")))).rows(this.menuConfig.getInt("menu-settings.gui-size"))).create();
        gui.getInventory().clear();
        gui.setDefaultClickAction(event -> event.setCancelled(true));
        GuiItem acceptItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.valueOf((String)this.menuConfig.getString("menu-settings.accept-item"))).setName(ColorUtils.fix(this.menuConfig.getString("menu-settings.accept-name")))).setLore(ColorUtils.fixList(this.menuConfig.getStringList("menu-settings.accept-lore")))).asGuiItem(event -> {
            if (player.hasPermission("openwallet.buyonce." + this.product.getProduct())) {
                player.sendMessage(ColorUtils.fix(this.messages.getString("errors.already-owned")));
                gui.close((HumanEntity)player);
                return;
            }
            if (this.user.getBalance() < this.product.getCost()) {
                player.sendMessage(ColorUtils.fix(this.messages.getString("errors.not-enough-balance")));
            } else {
                player.sendMessage(ColorUtils.fix(this.messages.getString("successfully-purchased").replace("{PRODUCT}", this.product.getName())));
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 8.0f);
                this.dataManager.withDrawBalance(player.getName(), this.product.getCost());
                this.runCommands(this.product.getCommands(), player);
            }
        });
        gui.setItem(this.menuConfig.getInt("menu-settings.accept-item-slot"), acceptItem);
        GuiItem cancelItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.valueOf((String)this.menuConfig.getString("menu-settings.cancel-item"))).setName(ColorUtils.fix(this.menuConfig.getString("menu-settings.cancel-name")))).setLore(ColorUtils.fixList(this.menuConfig.getStringList("menu-settings.cancel-lore")))).asGuiItem(event -> {
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            new ShopMenu(this.shop, player);
        });
        gui.setItem(this.menuConfig.getInt("menu-settings.cancel-item-slot"), cancelItem);
        gui.open((HumanEntity)player);
    }

    private void runCommands(List<String> commands, Player player) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)command.replace("{PLAYER}", player.getName()))));
    }
}

