/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import libs.gui.builder.gui.SimpleBuilder;
import libs.gui.builder.item.ItemBuilder;
import libs.gui.builder.item.SkullBuilder;
import libs.gui.guis.Gui;
import libs.gui.guis.GuiItem;
import libs.yaml.YamlDocument;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import xyz.neziw.wallet.WalletPlugin;
import xyz.neziw.wallet.basic.PlayerInput;
import xyz.neziw.wallet.loaders.ShopsLoader;
import xyz.neziw.wallet.utilities.ColorUtils;

public class ManagerMenu {
    private final WalletPlugin plugin = WalletPlugin.getInstance();
    private final YamlDocument config = this.plugin.getMainConfig();
    private final ShopsLoader shopsLoader = this.plugin.getShopsLoader();

    public void open(Player player) {
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(Component.text("OpenWallet Configuration"))).rows(6)).create();
        gui.getInventory().clear();
        gui.setDefaultClickAction(event -> event.setCancelled(true));
        gui.getFiller().fillBorder(Arrays.asList(((ItemBuilder)ItemBuilder.from(Material.LIME_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.RED_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.BLUE_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.YELLOW_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.WHITE_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.PURPLE_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem(), ((ItemBuilder)ItemBuilder.from(Material.PINK_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem()));
        GuiItem startBalance = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjA5Mjk5YTExN2JlZTg4ZDMyNjJmNmFiOTgyMTFmYmEzNDRlY2FlMzliNDdlYzg0ODEyOTcwNmRlZGM4MWU0ZiJ9fX0=").setName(ColorUtils.fix("&aStarting balance"))).setLore(ColorUtils.fixList(Arrays.asList("&7This is amount of balance that player", "&7who never played will get at first join", "", "&7Current value: &6" + this.config.getDouble("start-balance"), "", "&eClick to change this value!")))).asGuiItem(event -> {
            gui.close((HumanEntity)player);
            new PlayerInput(player, input -> {
                double value = Double.parseDouble(input);
                this.config.set("start-balance", (Object)value);
                try {
                    this.config.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_YES, 1.0f, 1.0f);
                gui.open((HumanEntity)player);
                gui.update();
            }, input -> {
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 5.0f);
                gui.open((HumanEntity)player);
                gui.update();
            });
        });
        gui.setItem(20, startBalance);
        if (this.config.getBoolean("hook-placeholder-api").booleanValue()) {
            GuiItem placeholderHook = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzc0NzJkNjA4ODIxZjQ1YTg4MDUzNzZlYzBjNmZmY2I3ODExNzgyOWVhNWY5NjAwNDFjMmEwOWQxMGUwNGNiNCJ9fX0=").setName(ColorUtils.fix("&aPlaceholderAPI hook"))).setLore(ColorUtils.fixList(Arrays.asList("&7This option makes OpenWallet hook into PlaceholderAPI", "&7on startup and implement some placeholders", "", "&7Current value: &aEnabled", "", "&eClick to toggle this option!")))).asGuiItem(event -> {
                this.config.set("hook-placeholder-api", (Object)false);
                try {
                    this.config.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 5.0f);
                gui.open((HumanEntity)player);
                gui.update();
            });
            gui.setItem(23, placeholderHook);
        } else {
            GuiItem placeholderHook = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjk1M2IxMmEwOTQ2YjYyOWI0YzA4ODlkNDFmZDI2ZWQyNmZiNzI5ZDRkNTE0YjU5NzI3MTI0YzM3YmI3MGQ4ZCJ9fX0=").setName(ColorUtils.fix("&aPlaceholderAPI hook"))).setLore(ColorUtils.fixList(Arrays.asList("&7This option makes OpenWallet hook into PlaceholderAPI", "&7on startup and implement some placeholders", "", "&7Current value: &cDisabled", "", "&eClick to toggle this option!")))).asGuiItem(event -> {
                this.config.set("hook-placeholder-api", (Object)true);
                try {
                    this.config.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 5.0f);
                gui.update();
            });
            gui.setItem(23, placeholderHook);
        }
        if (this.config.getBoolean("hook-gadgets-menu").booleanValue()) {
            GuiItem gadgetsMenuHook = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzc0NzJkNjA4ODIxZjQ1YTg4MDUzNzZlYzBjNmZmY2I3ODExNzgyOWVhNWY5NjAwNDFjMmEwOWQxMGUwNGNiNCJ9fX0=").setName(ColorUtils.fix("&aGadgetsMenu hook &cNOT AVAILABLE"))).setLore(ColorUtils.fixList(Arrays.asList("&7This option makes OpenWallet hook into GadgetsMenu", "&7on startup and override it's economy", "", "&7Current value: &aEnabled", "", "&eClick to toggle this option!")))).asGuiItem(event -> {
                this.config.set("hook-gadgets-menu", (Object)false);
                try {
                    this.config.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 5.0f);
                gui.open((HumanEntity)player);
                gui.update();
            });
            gui.setItem(24, gadgetsMenuHook);
        } else {
            GuiItem gadgetsMenuHook = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjk1M2IxMmEwOTQ2YjYyOWI0YzA4ODlkNDFmZDI2ZWQyNmZiNzI5ZDRkNTE0YjU5NzI3MTI0YzM3YmI3MGQ4ZCJ9fX0=").setName(ColorUtils.fix("&aGadgetsMenu hook &cNOT AVAILABLE"))).setLore(ColorUtils.fixList(Arrays.asList("&7This option makes OpenWallet hook into GadgetsMenu", "&7on startup and override it's economy", "", "&7Current value: &cDisabled", "", "&eClick to toggle this option!")))).asGuiItem(event -> {
                this.config.set("hook-gadgets-menu", (Object)true);
                try {
                    this.config.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 5.0f);
                gui.open((HumanEntity)player);
                gui.update();
            });
            gui.setItem(24, gadgetsMenuHook);
        }
        GuiItem shops = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQwMDVlYmJmOTgxN2Q2OTI4ZGU4YmM1ZjdkMWMzODkyNzYwMjBhYzg3NjQ3ZDI4YWI4Zjk5ZWIzOWZmZGU3NiJ9fX0=").setName(ColorUtils.fix("&aLoaded shops"))).setLore(ColorUtils.fixList(this.getShopsList()))).asGuiItem();
        gui.setItem(29, shops);
        GuiItem reload = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTRkNDliYWU5NWM3OTBjM2IxZmY1YjJmMDEwNTJhNzE0ZDYxODU0ODFkNWIxYzg1OTMwYjNmOTlkMjMyMTY3NCJ9fX0=").setName(ColorUtils.fix("&aReload configurations"))).setLore(ColorUtils.fixList(Arrays.asList("", "&eClick to reload configs!")))).asGuiItem(event -> {
            try {
                gui.close((HumanEntity)player);
                this.plugin.getMessagesConfig().reload();
                this.config.reload();
                this.shopsLoader.reload();
                this.plugin.getConfirmationMenuConfig().reload();
                player.sendMessage(ColorUtils.fix("&aReloaded"));
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 5.0f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        gui.setItem(30, reload);
        GuiItem saveTask = ((SkullBuilder)((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ4NmRiOWExNGQ1ODc5ZmEyODExZDMwMWNjYmQ1MjY5OTRmODcxMjQ3YjYyZjJkOWE0ODE4M2U5NjQxYWQ2OSJ9fX0=").setName(ColorUtils.fix("&bAuto-save is currently " + (this.config.getBoolean("auto-data-save") != false ? "&a&lENABLED" : "&c&lDISABLED")))).setLore(ColorUtils.fixList(Arrays.asList("", "&7Player data will automatically save", "&7every 5 minutes to the database", "")))).asGuiItem();
        gui.setItem(21, saveTask);
        gui.open((HumanEntity)player);
    }

    private List<String> getShopsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("&7List of currently loaded shops:");
        list.add("");
        for (String string : this.shopsLoader.getShops().keySet()) {
            list.add("&8- &a" + string);
        }
        list.add("");
        return list;
    }
}

