/*
 * Decompiled with CFR 0.152.
 */
package xyz.neziw.wallet.menu;

import libs.gui.builder.gui.SimpleBuilder;
import libs.gui.builder.item.ItemBuilder;
import libs.gui.guis.Gui;
import libs.gui.guis.GuiItem;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import xyz.neziw.wallet.menu.ConfirmationMenu;
import xyz.neziw.wallet.objects.Product;
import xyz.neziw.wallet.objects.Shop;
import xyz.neziw.wallet.utilities.ColorUtils;

public class ShopMenu {
    private final Shop shop;

    public ShopMenu(Shop shop, Player player) {
        this.shop = shop;
        this.open(player);
    }

    private void open(Player player) {
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(Component.text(this.shop.getTitle()))).rows(this.shop.getSize())).create();
        gui.getInventory().clear();
        gui.setDefaultClickAction(event -> event.setCancelled(true));
        for (Product product : this.shop.getProducts().values()) {
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(product.getMaterial()).setName(ColorUtils.fix(product.getName()))).setLore(ColorUtils.fixList(product.getLore()))).asGuiItem(event -> new ConfirmationMenu(product, this.shop, player));
            gui.setItem(product.getSlot(), guiItem);
        }
        gui.open((HumanEntity)player);
    }
}

