/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import dev.tazer.clutternomore.common.registry.CBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = (CNMConfig.StartupConfig)CNMConfig.StartupConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"startup", CNMConfig.StartupConfig.class);
    private static final class_9224 PACK_INFO = new class_9224("clutternomore-runtime", (class_2561)class_2561.method_43470((String)"ClutterNoMore"), class_5352.field_25348, Optional.empty());
    public static final CNMPackResources RESOURCES = new CNMPackResources(PACK_INFO);
    public static final ArrayList<class_2960> ALIASES = new ArrayList();

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
    }

    public static class_3288 createPack(class_3264 type) {
        return class_3288.method_45275((class_9224)PACK_INFO, (class_3288.class_7680)new PackResourcesSupplier(), (class_3264)type, (class_9225)new class_9225(true, class_3288.class_3289.field_14280, false));
    }

    public static class_2960 location(String path) {
        return ClutterNoMore.location(MODID, path);
    }

    public static class_2960 location(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static class_2960 parse(String id) {
        return class_2960.method_60654((String)id);
    }

    public static void load(class_7225.class_7874 registries, class_1863 recipeManager) {
    }

    public static void registerVariants() {
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue() || ((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) {
            LinkedHashMap<Object, Supplier> toRegister = new LinkedHashMap<Object, Supplier>();
            ArrayList<class_2960> slabs = new ArrayList<class_2960>();
            ArrayList<class_2960> stairs = new ArrayList<class_2960>();
            JsonArray verticalSlabsArray = new JsonArray();
            JsonArray stepsArray = new JsonArray();
            JsonArray woodenVerticalSlabsArray = new JsonArray();
            JsonArray woodenStepsArray = new JsonArray();
            JsonArray pickaxeMineableArray = new JsonArray();
            JsonArray shovelMineableArray = new JsonArray();
            List<class_2498> woodenSoundTypes = List.of(class_2498.field_11547, class_2498.field_40314, class_2498.field_42766, class_2498.field_40315);
            List<class_2498> shovelSoundTypes = List.of(class_2498.field_11529, class_2498.field_11535);
            for (Map.Entry resourceKeyItemEntry : class_7923.field_41178.method_29722()) {
                class_2510 stairBlock;
                class_2498 soundType;
                class_2960 shapeId;
                String path;
                Object shortPath;
                class_2482 slabBlock;
                class_2248 class_22482;
                class_1792 class_17922 = ((class_1792)resourceKeyItemEntry.getValue()).method_8389();
                if (!(class_17922 instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                class_2960 blockId = ((class_5321)resourceKeyItemEntry.getKey()).method_29177();
                Object blockNamespace = blockId.method_12836() + "/";
                if (blockId.method_12836().equals("minecraft")) {
                    blockNamespace = "";
                }
                if ((class_22482 = blockItem.method_7711()) instanceof class_2482 && (slabBlock = (class_2482)class_22482).method_9564().method_11656().size() == 2 && ((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue()) {
                    shortPath = "vertical_" + blockId.method_12832();
                    path = (String)blockNamespace + (String)shortPath;
                    toRegister.put(path, () -> new VerticalSlabBlock(ClutterNoMore.copy((class_2248)slabBlock).method_63500(CBlocks.registryKey(path))));
                    slabs.add(blockId);
                    shapeId = ClutterNoMore.location(path);
                    ClutterNoMore.addLootTable(blockId, shapeId);
                    soundType = ((BlockBehaviorAccessor)slabBlock).getSoundType();
                    if (woodenSoundTypes.contains(soundType)) {
                        woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                    } else {
                        verticalSlabsArray.add(ClutterNoMore.location(path).toString());
                        if (shovelSoundTypes.contains(soundType)) {
                            shovelMineableArray.add(ClutterNoMore.location(path).toString());
                        } else {
                            pickaxeMineableArray.add(ClutterNoMore.location(path).toString());
                        }
                    }
                }
                if (!((shortPath = blockItem.method_7711()) instanceof class_2510) || (stairBlock = (class_2510)shortPath).method_9564().method_11656().size() != 4 || !((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) continue;
                shortPath = blockId.method_12832().replace("stairs", "step");
                path = (String)blockNamespace + (String)shortPath;
                toRegister.put(path, () -> new StepBlock(ClutterNoMore.copy((class_2248)stairBlock).method_63500(CBlocks.registryKey(path))));
                stairs.add(blockId);
                shapeId = ClutterNoMore.location(path);
                ClutterNoMore.addLootTable(blockId, shapeId);
                soundType = ((BlockBehaviorAccessor)stairBlock).getSoundType();
                if (woodenSoundTypes.contains(soundType)) {
                    woodenStepsArray.add(shapeId.toString());
                    continue;
                }
                stepsArray.add(shapeId.toString());
                if (shovelSoundTypes.contains(soundType)) {
                    shovelMineableArray.add(shapeId.toString());
                    continue;
                }
                pickaxeMineableArray.add(shapeId.toString());
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            JsonObject verticalSlabTag = new JsonObject();
            verticalSlabTag.add("values", (JsonElement)verticalSlabsArray);
            ClutterNoMore.blockAndItemTag("vertical_slabs", (JsonElement)verticalSlabTag);
            JsonObject woodenVerticalSlabTag = new JsonObject();
            woodenVerticalSlabTag.add("values", (JsonElement)woodenVerticalSlabsArray);
            ClutterNoMore.blockAndItemTag("wooden_vertical_slabs", (JsonElement)woodenVerticalSlabTag);
            JsonObject stepTag = new JsonObject();
            stepTag.add("values", (JsonElement)stepsArray);
            ClutterNoMore.blockAndItemTag("steps", (JsonElement)stepTag);
            JsonObject woodenStepTag = new JsonObject();
            woodenStepTag.add("values", (JsonElement)woodenStepsArray);
            ClutterNoMore.blockAndItemTag("wooden_steps", (JsonElement)woodenStepTag);
            JsonObject pickaxeMineableTag = new JsonObject();
            pickaxeMineableTag.add("values", (JsonElement)pickaxeMineableArray);
            ClutterNoMore.blockAndItemTag("minecraft", "mineable/pickaxe", (JsonElement)pickaxeMineableTag);
            JsonObject shovelMineableTag = new JsonObject();
            shovelMineableTag.add("values", (JsonElement)shovelMineableArray);
            ClutterNoMore.blockAndItemTag("minecraft", "mineable/shovel", (JsonElement)shovelMineableTag);
        }
    }

    private static void blockTag(String s, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(MODID, s, verticalSlabTag);
    }

    private static void itemTag(String namespace, String s, JsonElement verticalSlabTag) {
        class_2960 location = ClutterNoMore.location(namespace, "tags/item/" + s + ".json");
        RESOURCES.addJson(class_3264.field_14190, location, verticalSlabTag);
    }

    private static void blockTag(String namespace, String s, JsonElement verticalSlabTag) {
        class_2960 location = ClutterNoMore.location(namespace, "tags/block/" + s + ".json");
        RESOURCES.addJson(class_3264.field_14190, location, verticalSlabTag);
    }

    private static void itemTag(String path, JsonElement verticalSlabTag) {
        ClutterNoMore.itemTag(MODID, path, verticalSlabTag);
    }

    private static void blockAndItemTag(String path, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(path, verticalSlabTag);
        ClutterNoMore.itemTag(path, verticalSlabTag);
    }

    private static void blockAndItemTag(String namespace, String path, JsonElement verticalSlabTag) {
        ClutterNoMore.blockTag(namespace, path, verticalSlabTag);
        ClutterNoMore.itemTag(namespace, path, verticalSlabTag);
    }

    public static void addLootTable(class_2960 block, class_2960 shape) {
        JsonObject lootTable = new JsonObject();
        lootTable.add("type", (JsonElement)new JsonPrimitive("block"));
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.add("type", (JsonElement)new JsonPrimitive("loot_table"));
        entry.add("value", (JsonElement)new JsonPrimitive(block.method_45138("blocks/").toString()));
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        lootTable.add("pools", (JsonElement)pools);
        String path = "loot_table";
        RESOURCES.addJson(class_3264.field_14190, ClutterNoMore.location("%s/blocks/%s.json".formatted(path, shape.method_12832())), (JsonElement)lootTable);
    }

    public static class_4970.class_2251 copy(class_2248 block) {
        return class_4970.class_2251.method_9630((class_4970)block);
    }

    private static class PackResourcesSupplier
    implements class_3288.class_7680 {
        private PackResourcesSupplier() {
        }

        public class_3262 method_52424(class_9224 location) {
            return RESOURCES;
        }

        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return RESOURCES;
        }
    }
}

