/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class AssetGenerator {
    public static Set<String> keys;
    public static final Path pack;

    public static void generate() {
        class_3300 manager = class_310.method_1551().method_1478();
        JsonObject lang = new JsonObject();
        keys.forEach(s -> lang.addProperty("block.clutternomore." + s.replace("/", "."), AssetGenerator.langName(s)));
        boolean writeLang = true;
        try {
            JsonObject existingLangJson;
            Optional existingLang = manager.method_14486(ClutterNoMore.location("lang/en_us.json"));
            if (existingLang.isPresent() && (existingLangJson = JsonParser.parseReader((Reader)((class_3298)existingLang.get()).method_43039()).getAsJsonObject()).equals((Object)lang)) {
                writeLang = false;
            }
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.catching((Throwable)e);
            throw new RuntimeException(e);
        }
        if (writeLang) {
            AssetGenerator.write("lang/en_us.json", (JsonElement)lang);
        }
        VerticalSlabGenerator.generate(manager);
        StepGenerator.generate(manager);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.RUNTIME_ASSET_GENERATION.value()).booleanValue()) {
            int minFormat = 15;
            int maxFormat = 70;
            JsonObject object = new JsonObject();
            object.add("description", (JsonElement)new JsonPrimitive("Generated resources for ClutterNoMore"));
            object.add("pack_format", (JsonElement)new JsonPrimitive((Number)15));
            object.add("min_format", (JsonElement)new JsonPrimitive((Number)minFormat));
            object.add("max_format", (JsonElement)new JsonPrimitive((Number)maxFormat));
            JsonArray supportedFormats = new JsonArray(2);
            supportedFormats.add((Number)minFormat);
            supportedFormats.add((Number)maxFormat);
            object.add("supported_formats", (JsonElement)supportedFormats);
            JsonObject mcmeta = new JsonObject();
            mcmeta.add("pack", (JsonElement)object);
            AssetGenerator.writeFile(pack, pack.resolve("pack.mcmeta"), mcmeta.toString());
        }
    }

    public static void write(String fileName, JsonElement contents) {
        ClutterNoMore.RESOURCES.addJson(class_3264.field_14188, ClutterNoMore.location(fileName), contents);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.RUNTIME_ASSET_GENERATION.value()).booleanValue()) {
            ClutterNoMoreClient.requireReload = true;
            Path assets = pack.resolve("assets/clutternomore");
            AssetGenerator.writeFile(assets.resolve(fileName.substring(0, fileName.lastIndexOf("/"))), assets.resolve(fileName), contents.toString());
        }
    }

    public static void writeFile(Path path, Path filePath, String contents) {
        try {
            path.toFile().mkdirs();
            FileWriter langWriter = new FileWriter(filePath.toFile());
            langWriter.write(contents);
            langWriter.close();
            ClutterNoMore.LOGGER.debug("Successfully wrote to {}", (Object)filePath);
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write dynamic data. %s".formatted(e));
        }
    }

    public static String langName(String name) {
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        String processed = name.replace("_", " ");
        List<String> nonCapital = List.of("of", "and", "with");
        String[] words = processed.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (!nonCapital.contains(word)) {
                result.append(Character.toUpperCase(word.charAt(0)));
            } else {
                result.append(word.charAt(0));
            }
            result.append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    @Nullable
    public static JsonObject getTextures(class_3300 manager, class_2960 parent) throws IOException {
        Optional parentBlockState = manager.method_14486(parent.method_45138("blockstates/").method_48331(".json"));
        if (parentBlockState.isEmpty()) {
            return null;
        }
        String model = null;
        BufferedReader reader = ((class_3298)parentBlockState.get()).method_43039();
        String line = reader.readLine();
        while (line != null) {
            if (line.contains("\"model\":")) {
                int firstIndex = line.indexOf("\"", line.indexOf("model\":") + 7);
                int secondIndex = line.indexOf("\"", firstIndex + 1);
                model = line.substring(firstIndex + 1, secondIndex);
                break;
            }
            line = reader.readLine();
        }
        if (model == null) {
            return null;
        }
        String[] modelParts = model.split(":");
        if (modelParts.length != 2) {
            return null;
        }
        Optional parentModel = manager.method_14486(ClutterNoMore.location(modelParts[0], "models/%s.json".formatted(modelParts[1])));
        if (parentModel.isEmpty()) {
            return null;
        }
        JsonObject textures = JsonParser.parseReader((Reader)((class_3298)parentModel.get()).method_43039()).getAsJsonObject().getAsJsonObject("textures");
        if (textures.get("top") == null) {
            if (textures.get("side") != null) {
                textures.add("top", textures.get("side"));
            } else if (textures.get("bottom") != null) {
                textures.add("top", textures.get("bottom"));
            }
        }
        if (textures.get("side") == null) {
            textures.add("side", textures.get("top"));
        }
        if (textures.get("bottom") == null) {
            textures.add("bottom", textures.get("top"));
        }
        return textures.get("top") == null ? null : textures;
    }

    public static void generateItem(class_2960 shape, class_3300 manager) {
        String modelString = shape.method_12832();
        modelString = modelString.replace("waxed_", "");
        Optional existingItemState = manager.method_14486(shape.method_45138("items/").method_48331(".json"));
        if (existingItemState.isPresent()) {
            return;
        }
        JsonObject itemState = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("type", "minecraft:model");
        model.addProperty("model", "clutternomore:block/" + modelString);
        itemState.add("model", (JsonElement)model);
        AssetGenerator.write("items/%s.json".formatted(shape.method_12832()), (JsonElement)itemState);
    }

    static {
        pack = Platform.INSTANCE.getResourcePack().resolve("clutternomore");
    }
}

