/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import dev.tazer.clutternomore.common.registry.CBlocks;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = (CNMConfig.StartupConfig)CNMConfig.StartupConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"startup", CNMConfig.StartupConfig.class);
    private static final class_9224 PACK_INFO = new class_9224("clutternomore-runtime", (class_2561)class_2561.method_43470((String)"ClutterNoMore"), class_5352.field_25348, Optional.empty());
    public static final CNMPackResources RESOURCES = new CNMPackResources(PACK_INFO);
    public static final ArrayList<class_2960> ALIASES = new ArrayList();
    public static final Path pack = Platform.INSTANCE.getResourcePack().resolve("clutternomore");

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
    }

    public static class_3288 createPack(class_3264 type) {
        return class_3288.method_45275((class_9224)PACK_INFO, (class_3288.class_7680)new PackResourcesSupplier(), (class_3264)type, (class_9225)new class_9225(true, class_3288.class_3289.field_14280, false));
    }

    public static class_2960 location(String path) {
        return ClutterNoMore.location(MODID, path);
    }

    public static class_2960 location(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static class_2960 parse(String id) {
        return class_2960.method_60654((String)id);
    }

    public static void modifyRecipes(class_7225.class_7874 registries, class_1863 recipeManager) {
        boolean changed = false;
        Collection originalRecipes = recipeManager.method_8126();
        ArrayList<class_8786> newRecipes = new ArrayList<class_8786>();
        for (class_8786 recipeHolder : originalRecipes) {
            class_1860 recipe = recipeHolder.comp_1933();
            class_1792 result = recipe.method_8110(registries).method_7909();
            if (ShapeMap.isShape(result)) continue;
            class_2371 ingredients = recipe.method_8117();
            for (class_1856 ingredient : new ArrayList(ingredients)) {
                ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                for (class_1799 stack : ingredient.method_8105()) {
                    class_1792 item = stack.method_7909();
                    if (ShapeMap.isShape(item)) {
                        class_1799 originalStack = ShapeMap.getParent(item).method_7854();
                        originalStack.method_7939(stack.method_7947());
                        stacks.add(originalStack);
                        changed = true;
                        continue;
                    }
                    stacks.add(stack);
                }
                Stream newStacks = stacks.stream();
                if (!changed) continue;
                try {
                    int index = ingredients.indexOf((Object)ingredient);
                    ingredients.set(index, (Object)class_1856.method_26964(newStacks));
                }
                catch (Exception exception) {}
            }
            class_8786 newHolder = new class_8786(recipeHolder.comp_1932(), recipe);
            newRecipes.add(newHolder);
        }
        if (changed) {
            recipeManager.method_20702(newRecipes);
        }
    }

    public static void registerVariants() {
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue() || ((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) {
            LinkedHashMap<Object, Supplier> toRegister = new LinkedHashMap<Object, Supplier>();
            ArrayList<class_2960> slabs = new ArrayList<class_2960>();
            ArrayList<class_2960> stairs = new ArrayList<class_2960>();
            List<class_2498> woodenSoundTypes = List.of(class_2498.field_11547, class_2498.field_40314, class_2498.field_42766, class_2498.field_40315);
            List<class_2498> shovelSoundTypes = List.of(class_2498.field_11529, class_2498.field_11535);
            for (Map.Entry resourceKeyItemEntry : class_7923.field_41178.method_29722()) {
                class_2510 stairBlock;
                class_2498 soundType;
                class_2960 shapeId;
                String path;
                Object shortPath;
                class_2482 slabBlock;
                class_2248 class_22482;
                class_1792 class_17922 = ((class_1792)resourceKeyItemEntry.getValue()).method_8389();
                if (!(class_17922 instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                class_2960 blockId = ((class_5321)resourceKeyItemEntry.getKey()).method_29177();
                Object blockNamespace = blockId.method_12836() + "/";
                if (blockId.method_12836().equals("minecraft")) {
                    blockNamespace = "";
                }
                if ((class_22482 = blockItem.method_7711()) instanceof class_2482 && (slabBlock = (class_2482)class_22482).method_9564().method_11656().size() == 2 && ((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue()) {
                    shortPath = "vertical_" + blockId.method_12832();
                    path = (String)blockNamespace + (String)shortPath;
                    ClutterNoMore.addAlias((String)blockNamespace, (String)shortPath, path);
                    toRegister.put(path, () -> new VerticalSlabBlock(ClutterNoMore.copy((class_2248)slabBlock)));
                    slabs.add(blockId);
                    shapeId = ClutterNoMore.location(path);
                    DataGenerator.addLootTable(blockId, shapeId);
                    soundType = ((BlockBehaviorAccessor)slabBlock).getSoundType();
                    if (woodenSoundTypes.contains(soundType)) {
                        DataGenerator.woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                    } else {
                        DataGenerator.addToTag(path, DataGenerator.verticalSlabsArray);
                        if (shovelSoundTypes.contains(soundType)) {
                            DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                        } else {
                            DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
                        }
                    }
                }
                if (!((shortPath = blockItem.method_7711()) instanceof class_2510) || (stairBlock = (class_2510)shortPath).method_9564().method_11656().size() != 4 || !((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) continue;
                shortPath = blockId.method_12832().replace("stairs", "step");
                path = (String)blockNamespace + (String)shortPath;
                ClutterNoMore.addAlias((String)blockNamespace, (String)shortPath, path);
                toRegister.put(path, () -> new StepBlock(ClutterNoMore.copy((class_2248)stairBlock)));
                stairs.add(blockId);
                shapeId = ClutterNoMore.location(path);
                DataGenerator.addLootTable(blockId, shapeId);
                soundType = ((BlockBehaviorAccessor)stairBlock).getSoundType();
                if (woodenSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(shapeId, DataGenerator.woodenStepsArray);
                    continue;
                }
                DataGenerator.addToTag(shapeId, DataGenerator.stepsArray);
                if (shovelSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                    continue;
                }
                DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            DataGenerator.generate();
        }
    }

    private static void addAlias(String blockNamespace, String shortPath, String path) {
        class_2960 shortNamespace = ClutterNoMore.location(shortPath);
        if (!blockNamespace.isEmpty() && !ALIASES.contains(shortNamespace)) {
            class_2960 id = ClutterNoMore.location(path);
            class_7923.field_41175.addAlias(shortNamespace, id);
            class_7923.field_41178.addAlias(shortNamespace, id);
            ALIASES.add(shortNamespace);
        }
    }

    public static void writeFile(Path path, Path filePath, String contents) {
        try {
            path.toFile().mkdirs();
            FileWriter langWriter = new FileWriter(filePath.toFile());
            langWriter.write(contents);
            langWriter.close();
            LOGGER.debug("Successfully wrote to {}", (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write dynamic data. %s".formatted(e));
        }
    }

    public static class_4970.class_2251 copy(class_2248 block) {
        return class_4970.class_2251.method_9630((class_4970)block);
    }

    private static class PackResourcesSupplier
    implements class_3288.class_7680 {
        private PackResourcesSupplier() {
        }

        public class_3262 method_52424(class_9224 location) {
            return RESOURCES;
        }

        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return RESOURCES;
        }
    }
}

