/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.shape_map;

import dev.tazer.clutternomore.common.networking.ShapeMapPayload;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class ShapeMap {
    private static final Map<class_1792, List<class_1792>> SHAPES_DATAMAP = new HashMap<class_1792, List<class_1792>>();
    private static final Map<class_1792, class_1792> INVERSE_SHAPES_DATAMAP = new HashMap<class_1792, class_1792>();

    public static void setShapeMaps(Map<class_1792, List<class_1792>> newShapeMap, Map<class_1792, class_1792> newInverseShapeMap) {
        SHAPES_DATAMAP.clear();
        SHAPES_DATAMAP.putAll(newShapeMap);
        INVERSE_SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.putAll(newInverseShapeMap);
    }

    public static boolean hasShapes(class_1792 item) {
        return SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean isShape(class_1792 item) {
        return INVERSE_SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean contains(class_1792 item) {
        return ShapeMap.hasShapes(item) || ShapeMap.isShape(item);
    }

    public static class_1792 getParent(class_1792 item) {
        return INVERSE_SHAPES_DATAMAP.getOrDefault(item, item);
    }

    public static boolean isParentOfShape(class_1792 parent, class_1792 shape) {
        return ShapeMap.getParent(shape) == parent;
    }

    public static boolean inSameShapeSet(class_1792 item, class_1792 other) {
        if (ShapeMap.isShape(item) || ShapeMap.isShape(other)) {
            return ShapeMap.getParent(item) == ShapeMap.getParent(other);
        }
        return false;
    }

    public static List<class_1792> getShapes(class_1792 item) {
        return SHAPES_DATAMAP.getOrDefault(ShapeMap.getParent(item), List.of());
    }

    public static void set(Map<class_2960, List<class_2960>> idMap) {
        SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.clear();
        for (Map.Entry<class_2960, List<class_2960>> entry : idMap.entrySet()) {
            class_2960 key2 = entry.getKey();
            class_1792 newKey = class_7923.field_41178.method_17966(key2).orElse(null);
            if (newKey == null) continue;
            List<class_2960> value = entry.getValue();
            ArrayList arrayList = new ArrayList();
            for (class_2960 location : value) {
                class_7923.field_41178.method_17966(location).map(arrayList::add);
            }
            if (arrayList.isEmpty()) continue;
            SHAPES_DATAMAP.put(newKey, arrayList);
        }
        class_7923.field_41178.method_29722().forEach(key -> {
            class_2960 id = ((class_5321)key.getKey()).method_29177();
            class_1792 item = (class_1792)key.getValue();
            if (item instanceof class_1747) {
                class_1747 blockItem = (class_1747)item;
                class_2248 block = blockItem.method_7711();
                BlockSetRegistry.ShapeSetRegistry.detectTypeFromBlock(block, id);
            }
        });
        for (class_1792 class_17922 : class_7923.field_41178.method_10220().toList()) {
            class_1792 mainChild;
            ArrayList<class_1792> shapes = new ArrayList<class_1792>(ShapeMap.getShapes(class_17922));
            BlockSetRegistry.ShapeSet shapeSet = BlockSetRegistry.getBlockTypeOf(class_17922);
            if (shapeSet != null && class_17922 == (mainChild = shapeSet.mainChild().method_8389())) {
                shapeSet.getChildren().forEach(child -> {
                    if (child != mainChild && child instanceof class_1792) {
                        class_1792 shape = (class_1792)child;
                        shapes.add(shape);
                    }
                });
            }
            if (shapes.isEmpty()) continue;
            SHAPES_DATAMAP.put(class_17922, shapes);
        }
        for (Map.Entry<Object, List<Object>> entry : new HashSet<Map.Entry<class_1792, List<class_1792>>>(SHAPES_DATAMAP.entrySet())) {
            class_1792 item = (class_1792)entry.getKey();
            List<Object> shapes = entry.getValue();
            for (class_1792 class_17923 : shapes) {
                INVERSE_SHAPES_DATAMAP.put(class_17923, item);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : new HashSet<Map.Entry<class_1792, class_1792>>(INVERSE_SHAPES_DATAMAP.entrySet())) {
            if (ShapeMap.hasShapes((class_1792)entry.getValue())) continue;
            INVERSE_SHAPES_DATAMAP.remove(entry.getKey());
        }
    }

    public static void sendShapeMap(class_3222 serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        HashMap<class_1799, List<class_1799>> shapes = new HashMap<class_1799, List<class_1799>>();
        SHAPES_DATAMAP.forEach((item, items) -> {
            ArrayList objects = new ArrayList();
            items.forEach(stack -> objects.add(stack.method_7854()));
            shapes.put(item.method_7854(), objects);
        });
        HashMap<class_1799, class_1799> inverseShapes = new HashMap<class_1799, class_1799>();
        INVERSE_SHAPES_DATAMAP.forEach((item, items) -> inverseShapes.put(item.method_7854(), items.method_7854()));
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new ShapeMapPayload(shapes, inverseShapes));
    }
}

