package dev.tazer.clutternomore.common.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2771;

@Mixin(class_1747.class)
public class BlockItemMixin {
    @Redirect(method = "place", at = @At(
            value = "INVOKE",
            //? if >1.20.1 {
            target = "Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V")
            //?} else {
            /*target = "Lnet/minecraft/world/item/ItemStack;shrink(I)V")
            *///?}
    )
    private void place(class_1799 instance,
                       int amount,
                       //? if >1.20.1 {
                       class_1309 entity,
                       //?}
                       @Local(argsOnly = true) class_1750 context,
                       @Local(ordinal = 0) class_2680 blockstate
    ) {
        boolean consume = true;
        if (ShapeMap.isShape(instance.method_7909())) {
            Optional<class_2771> slabType = blockstate.method_28500(class_2482.field_11501);
            Optional<Boolean> isDouble = blockstate.method_28500(VerticalSlabBlock.DOUBLE);

            if (slabType.isPresent()) consume = slabType.get() != class_2771.field_12682;
            if (isDouble.isPresent()) consume = !isDouble.get();
        }

        if (consume)
            //? if >1.20.1 {
            instance.method_57008(amount, entity);
            //?} else {
            /*instance.shrink(amount);
            *///?}
    }
}
