/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DOUBLE = BooleanProperty.m_61465_((String)"double");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DOUBLE}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 exactPos = context.m_43720_();
        Direction direction = context.m_8125_();
        BlockState replacingBlockState = context.m_43725_().m_8055_(pos);
        FluidState replacingFluidState = context.m_43725_().m_6425_(pos);
        if (replacingBlockState.m_60713_((Block)this)) {
            return (BlockState)replacingBlockState.m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(true));
        }
        BlockState stateForPlacement = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingFluidState.m_76152_() == Fluids.f_76193_));
        switch (direction) {
            case NORTH: {
                if (!(exactPos.f_82481_ - (double)pos.m_123343_() > 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case SOUTH: {
                if (!(exactPos.f_82481_ - (double)pos.m_123343_() < 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case EAST: {
                if (!(exactPos.f_82479_ - (double)pos.m_123341_() < 0.5)) break;
                direction = direction.m_122424_();
                break;
            }
            case WEST: {
                if (!(exactPos.f_82479_ - (double)pos.m_123341_() > 0.5)) break;
                direction = direction.m_122424_();
            }
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)direction);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() || !itemStack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!context.m_7058_()) {
            return true;
        }
        double hitposX = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
        double hitposZ = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
        Direction facingDirection = (Direction)state.m_61143_((Property)FACING);
        return switch (facingDirection) {
            case Direction.NORTH -> {
                if (hitposZ >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (hitposX <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (hitposZ <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (hitposX >= 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
            case Direction.EAST -> Shapes.m_166049_((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.SOUTH -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            case Direction.WEST -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
            default -> Shapes.m_83144_();
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7923_(BlockState state) {
        return (Boolean)state.m_61143_((Property)DOUBLE) == false;
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return state.m_60819_();
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            return super.m_7361_(level, pos, state, fluidState);
        }
        return false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            return super.m_6044_(level, pos, state, fluid);
        }
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)DOUBLE);
    }
}

