/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.tazer.clutternomore.ClutterNoMore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class CNMPackResources
extends AbstractPackResources {
    protected final Map<ResourceLocation, byte[]> clientResources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<ResourceLocation, byte[]> serverData = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final PackMetadataSection clientMetadata = new PackMetadataSection((Component)Component.m_237113_((String)"ClutterNoMore Runtime Client Resources"), resourcePackVersion);
    protected final PackMetadataSection serverMetadata = new PackMetadataSection((Component)Component.m_237113_((String)"ClutterNoMore Runtime Server Data"), dataPackVersion);
    private static final WorldVersion currentVersion = SharedConstants.m_183709_();
    public static final int resourcePackVersion = currentVersion.m_264084_(PackType.CLIENT_RESOURCES);
    public static final int dataPackVersion = currentVersion.m_264084_(PackType.SERVER_DATA);

    public CNMPackResources(String info) {
        super(info, true);
    }

    public Set<String> m_5698_(PackType packType) {
        return Set.of("clutternomore");
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        try {
            return (T)(deserializer == PackMetadataSection.f_243696_ ? this.clientMetadata : null);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public void addResource(PackType packType, ResourceLocation id, byte[] bytes) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        resources.put(id, bytes);
    }

    public void addJson(PackType packType, ResourceLocation path, JsonElement json) {
        try {
            this.addResource(packType, path, CNMPackResources.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        byte[] resource = this.rootResources.get(String.join((CharSequence)"/", strings));
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation id) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        byte[] resource = resources.get(id);
        return resource != null ? () -> new ByteArrayInputStream(resource) : null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
        Map<ResourceLocation, byte[]> resources = packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
        for (ResourceLocation location : resources.keySet()) {
            if (!location.m_135815_().startsWith(path)) continue;
            byte[] resource = resources.get(location);
            output.accept((Object)location, () -> new ByteArrayInputStream(resource));
        }
    }

    public void close() {
    }

    public static String serializeJson(JsonElement json) throws IOException {
        try {
            String string;
            try (StringWriter stringWriter = new StringWriter();
                 JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

