/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.networking;

import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ShapeMapPayload(Map<ItemStack, List<ItemStack>> shapes, Map<ItemStack, ItemStack> inverseShapes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShapeMapPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"clutternomore", (String)"shapes"));
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<ItemStack, List<ItemStack>>> SHAPE_MAP_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ItemStack.STREAM_CODEC, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, (int)BuiltInRegistries.ITEM.size());
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<ItemStack, ItemStack>> INVERSE_SHAPE_MAP_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ItemStack.STREAM_CODEC, (StreamCodec)ItemStack.STREAM_CODEC, (int)BuiltInRegistries.ITEM.size());
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapeMapPayload> STREAM_CODEC = StreamCodec.composite(SHAPE_MAP_CODEC, ShapeMapPayload::shapes, INVERSE_SHAPE_MAP_CODEC, ShapeMapPayload::inverseShapes, ShapeMapPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleDataOnClient(ShapeMapPayload data, IPayloadContext context) {
        HashMap<Item, List<Item>> SHAPES_DATAMAP = new HashMap<Item, List<Item>>();
        data.shapes.forEach((item, items) -> {
            ArrayList objects = new ArrayList();
            items.forEach(stack -> objects.add(stack.getItem()));
            SHAPES_DATAMAP.put(item.getItem(), objects);
        });
        HashMap<Item, Item> INVERSE_SHAPES_DATAMAP = new HashMap<Item, Item>();
        data.inverseShapes.forEach((item, items) -> INVERSE_SHAPES_DATAMAP.put(item.getItem(), items.getItem()));
        ShapeMap.setShapeMaps(SHAPES_DATAMAP, INVERSE_SHAPES_DATAMAP);
    }
}

