/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.mixin.access.SlotAccessor;
import dev.tazer.clutternomore.common.mixin.screen.ScreenAccessor;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9779;

public class ClutterNoMoreClient {
    public static boolean showTooltip = false;
    public static ShapeSwitcherOverlay OVERLAY = null;
    public static final CNMConfig.ClientConfig CLIENT_CONFIG = (CNMConfig.ClientConfig)CNMConfig.ClientConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"client", CNMConfig.ClientConfig.class);
    public static boolean requireReload = false;

    public static void init() {
    }

    public static void clientStarted(class_310 client) {
        AssetGenerator.generate();
        ClutterNoMoreClient.enablePack(client);
    }

    public static void onItemTooltips(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> tooltip) {
        if (!showTooltip && ShapeMap.contains(stack.method_7909())) {
            class_5250 component = tooltip.get(0).method_27661().method_10852((class_2561)class_2561.method_43470((String)" [+]").method_27692(class_124.field_1063));
            tooltip.remove(0);
            tooltip.add(0, (class_2561)component);
        }
    }

    public static void onKeyInput(int keyCode, int action) {
        if (keyCode == ClutterNoMoreClient.shapeKey()) {
            class_1799 heldStack;
            class_746 player;
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1755 == null && (player = minecraft.field_1724) != null && ShapeMap.contains((heldStack = player.method_5998(class_1268.field_5808)).method_7909())) {
                switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                    case HOLD: {
                        if (OVERLAY == null && action == 1) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        if (action != 0) break;
                        OVERLAY = null;
                        break;
                    }
                    case TOGGLE: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        OVERLAY = null;
                        break;
                    }
                    case PRESS: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                        }
                        OVERLAY.onMouseScrolled(-1);
                        OVERLAY = null;
                    }
                }
            }
        }
    }

    public static void onKeyPress(class_437 screen, int button) {
        if (button == ClutterNoMoreClient.shapeKey() && screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            class_1735 slot = ((ScreenAccessor)screen).getSlotUnderMouse();
            if (slot != null) {
                class_1799 heldStack = slot.method_7677();
                class_746 player = class_310.method_1551().field_1724;
                if (slot.method_32754((class_1657)player) && ShapeMap.contains(heldStack.method_7909())) {
                    switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                        case HOLD: {
                            showTooltip = true;
                            break;
                        }
                        case TOGGLE: {
                            showTooltip = !showTooltip;
                            break;
                        }
                        case PRESS: {
                            ClutterNoMoreClient.switchShapeInSlot((class_1657)player, containerScreen.method_17577().field_7763, ((SlotAccessor)slot).getSlotIndex(), heldStack, -1);
                        }
                    }
                }
            }
        }
    }

    public static boolean onKeyReleased(int button) {
        if (button == ClutterNoMoreClient.shapeKey() && ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value() == CNMConfig.InputType.HOLD) {
            showTooltip = false;
        }
        return false;
    }

    public static void switchShapeInSlot(class_1657 player, int containerId, int slotId, class_1799 heldStack, int direction) {
        class_1792 item = ShapeMap.getParent(heldStack.method_7909());
        int count = heldStack.method_7947();
        ArrayList<class_1792> shapes = new ArrayList<class_1792>(ShapeMap.getShapes(item));
        shapes.add(0, item);
        int selectedIndex = shapes.indexOf(heldStack.method_7909());
        int maxIndex = shapes.size() - 1;
        if ((selectedIndex -= direction) < 0) {
            selectedIndex = maxIndex;
        }
        if (selectedIndex > maxIndex) {
            selectedIndex = 0;
        }
        class_1792 nextItem = (class_1792)shapes.get(selectedIndex);
        class_1799 next = nextItem.method_7854();
        next.method_7939(count);
        player.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.3f, 1.5f);
        if (slotId < 9) {
            slotId += 36;
        }
        ChangeStackPayload p = new ChangeStackPayload(containerId, slotId, next);
        ClientPlayNetworking.send((class_8710)p);
    }

    public static int shapeKey() {
        return Platform.INSTANCE.shapeKey();
    }

    public static void onPlayerTick(class_310 minecraft) {
        if (OVERLAY != null && !OVERLAY.shouldStayOpenThisTick()) {
            OVERLAY = null;
        }
    }

    public static void onRenderGui(class_332 guiGraphics, class_9779 tracker) {
        if (OVERLAY != null && ClutterNoMoreClient.OVERLAY.render) {
            OVERLAY.render(guiGraphics, tracker.method_60636());
        }
    }

    public static boolean allowScreenScroll(class_437 pScreen, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (showTooltip && pScreen instanceof class_465) {
            class_1799 heldStack;
            class_465 screen = (class_465)pScreen;
            class_1735 slot = ((ScreenAccessor)screen).getSlotUnderMouse();
            class_746 player = class_310.method_1551().field_1724;
            if (slot != null && slot.method_32754((class_1657)player) && ShapeMap.contains((heldStack = slot.method_7677()).method_7909())) {
                ClutterNoMoreClient.switchShapeInSlot((class_1657)player, screen.method_17577().field_7763, ((SlotAccessor)slot).getSlotIndex(), heldStack, (int)scrollY);
                return false;
            }
        }
        return true;
    }

    public static boolean onMouseScrolling(double yOffset) {
        int direction = (int)yOffset;
        if (OVERLAY != null) {
            OVERLAY.onMouseScrolled(direction);
            return true;
        }
        return false;
    }

    private static void enablePack(class_310 client) {
        Path resourcepackPath;
        class_3283 repository = client.method_1520();
        if (requireReload && (resourcepackPath = client.method_1479().resolve("clutternomore")).toFile().exists()) {
            repository.method_14445();
            repository.method_49427("file/" + resourcepackPath.getFileName().toString());
            client.method_1521();
        }
    }
}

