/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.registry;

import dev.tazer.clutternomore.ClutterNoMore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockSetRegistry {
    public static ShapeSet getBlockTypeOf(class_1792 item) {
        return ShapeSetRegistry.items.get(item);
    }

    private static String stripSuffix(String path, String suffix) {
        if (path.endsWith("_" + suffix)) {
            return path.substring(0, path.length() - suffix.length() - 1);
        }
        if (path.endsWith(suffix)) {
            return path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private static String stripPrefix(String path, String prefix) {
        if (path.startsWith(prefix + "_")) {
            return path.substring(prefix.length() + 1);
        }
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    public static class ShapeSetRegistry {
        public static final Map<class_1792, ShapeSet> items = new LinkedHashMap<class_1792, ShapeSet>();

        public static void register(class_1792 block, ShapeSet shapeSet) {
            items.put(block, shapeSet);
        }

        public static void detectTypeFromBlock(class_2248 block, class_2960 blockId) {
            if (block.method_8389() != class_1802.field_8162 && ShapeSetRegistry.isParentBlock(blockId)) {
                new ShapeSet(blockId, block);
            }
        }

        private static boolean has(class_2960 block) {
            return class_7923.field_41175.method_10250(block);
        }

        private static boolean isParentBlock(class_2960 block) {
            List<String> namespaces = List.of(block.method_12836(), "minecraft");
            String path = block.method_12832();
            List<String> parentSuffixes = List.of("log", "planks", "block");
            List<String> ignoredSuffixes = List.of("block");
            Map<String, String> replacements = Map.of("log", "wood");
            List<String> prefixes = List.of("spiked");
            List<String> ignoredPrefixes = List.of("stripped");
            List<String> suffixes = List.of("stairs", "slab", "wall");
            for (String namespace : namespaces) {
                class_2960 candidate;
                class_2960 base = ClutterNoMore.location(namespace, path);
                String suffixBase = path;
                for (String string : ignoredSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, string);
                }
                for (String string : parentSuffixes) {
                    class_2960 candidate2;
                    String suffixed = suffixBase + "_" + string;
                    if (suffixed.equals(path) || !ShapeSetRegistry.has(candidate2 = base.method_45134(p -> suffixed))) continue;
                    return false;
                }
                for (Map.Entry entry : replacements.entrySet()) {
                    class_2960 candidate2;
                    String replaced = path.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    if (replaced.equals(path) || !ShapeSetRegistry.has(candidate2 = base.method_45134(p -> replaced))) continue;
                    return true;
                }
                String prefixBase = path;
                for (String ignored : ignoredPrefixes) {
                    prefixBase = BlockSetRegistry.stripPrefix(prefixBase, ignored);
                }
                for (String prefix : prefixes) {
                    String prefixed = prefix + "_" + prefixBase;
                    if (prefixed.equals(path) || !ShapeSetRegistry.has(candidate = base.method_45134(p -> prefixed))) continue;
                    return true;
                }
                for (String parent : parentSuffixes) {
                    suffixBase = BlockSetRegistry.stripSuffix(suffixBase, parent);
                }
                for (String suffix : suffixes) {
                    class_2960 candidate3;
                    String trimmed;
                    String suffixed;
                    if (suffixBase.endsWith("s") && !(suffixed = (trimmed = suffixBase.substring(0, suffixBase.length() - 1)) + "_" + suffix).equals(path) && ShapeSetRegistry.has(candidate3 = base.method_45134(p -> suffixed))) {
                        return true;
                    }
                    String suffixed2 = suffixBase + "_" + suffix;
                    if (suffixed2.equals(path) || !ShapeSetRegistry.has(candidate = base.method_45134(p -> suffixed2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShapeSet {
        private final class_2960 id;
        private final String type;
        private final class_2248 block;
        private final Map<String, class_1935> items = new LinkedHashMap<String, class_1935>();

        ShapeSet(class_2960 id, class_2248 block) {
            this.id = id;
            this.block = block;
            this.type = id.method_12832().replace("_block", "").replace("_planks", "");
            this.initializeChildrenBlocks();
            ShapeSetRegistry.register(block.method_8389(), this);
        }

        protected void initializeChildrenBlocks() {
            this.addChild("block", (class_1935)this.block);
            if (this.id.method_12832().contains("log")) {
                this.addChild("wood", (class_1935)this.getWood());
                if (this.id.method_12832().contains("stripped")) {
                    this.addChild("hollow_log", ClutterNoMore.location("wilderwild", this.id.method_12832().replace("stripped_", "stripped_hollowed_")));
                } else {
                    this.addChild("hollow_log", ClutterNoMore.location("wilderwild", "hollowed_" + this.id.method_12832()));
                }
            }
            this.addChild("slab", (class_1935)this.findShape("slab"));
            this.addChild("stairs", (class_1935)this.findShape("stairs"));
            this.addChild("wall", (class_1935)this.findShape("wall"));
            this.addChild("vertical_slab", (class_1935)this.findShape("clutternomore", this.id.method_12836() + "/vertical", "slab"));
            this.addChild("vertical_slab", (class_1935)this.findShape("clutternomore", "vertical", "slab"));
            this.addChild("vertical_slab", (class_1935)this.findShape("vertical", "slab"));
            this.addChild("step", (class_1935)this.findShape("clutternomore", this.id.method_12836() + "/", "step", false));
            this.addChild("step", (class_1935)this.findShape("clutternomore", "", "step"));
            this.addChild("step", (class_1935)this.findShape("", "step"));
            this.addChild("spiked", (class_1935)this.findShape("spiked", ""));
        }

        private void addChild(String block, class_1935 block1) {
            if (block1 != null && !this.items.containsKey(block)) {
                this.items.put(block, block1);
            }
        }

        private void addChild(String block, class_2960 id) {
            class_7923.field_41178.method_17966(id).ifPresent(block1 -> this.items.put(block, (class_1935)block1));
        }

        public String getVariantId(String prefix, String postfix) {
            Object name = prefix + (prefix.isEmpty() ? "" : "_") + this.getTypeName();
            List<String> suffixes = List.of("_block", "_planks", "s");
            for (String suffix : suffixes) {
                if (!((String)name).endsWith(suffix)) continue;
                name = ((String)name).substring(0, ((String)name).length() - suffix.length());
                break;
            }
            return (String)name + (postfix.isEmpty() ? "" : "_") + postfix;
        }

        private String getTypeName() {
            return this.type;
        }

        @Nullable
        protected class_1792 findShape(String prefix, String postfix) {
            return this.findShape(this.id.method_12836(), prefix, postfix);
        }

        @Nullable
        protected class_1792 findShape(String namespace, String prefix, String postfix) {
            return this.findShape(namespace, prefix, postfix, true);
        }

        @Nullable
        protected class_1792 findShape(String namespace, String prefix, String postfix, boolean addUnderscore) {
            String basePath = this.id.method_12832();
            List<String> parentSuffixes = List.of("block", "planks");
            for (String parent : parentSuffixes) {
                basePath = BlockSetRegistry.stripSuffix(basePath, parent);
            }
            List<String> ignoredPrefixes = List.of("stripped");
            Object reapplyPrefix = "";
            for (String ignored : ignoredPrefixes) {
                if (!this.id.method_12832().startsWith(ignored + "_")) continue;
                reapplyPrefix = ignored + "_";
                basePath = BlockSetRegistry.stripPrefix(basePath, ignored);
            }
            String prefixPart = prefix.isEmpty() ? "" : prefix + (addUnderscore ? "_" : "");
            Object postfixPart = postfix.isEmpty() ? "" : "_" + postfix;
            ArrayList<String> candidates = new ArrayList<String>();
            if (basePath.endsWith("s")) {
                candidates.add(basePath.substring(0, basePath.length() - 1));
            }
            candidates.add(basePath);
            for (String stem : candidates) {
                String candidatePath = (String)reapplyPrefix + prefixPart + stem + (String)postfixPart;
                class_2960 candidateId = ClutterNoMore.location(namespace, candidatePath);
                Optional found = class_7923.field_41178.method_17966(candidateId);
                if (!found.isPresent()) continue;
                return (class_1792)found.get();
            }
            return null;
        }

        @Nullable
        protected class_1792 findShape(String postfix) {
            return this.findShape("", postfix);
        }

        @Nullable
        protected class_1792 getWood() {
            String path = this.id.method_12832();
            if (path.endsWith("log")) {
                String stem = path.substring(0, path.length() - 3);
                class_2960 woodId = this.id.method_45134(p -> stem + "wood");
                return class_7923.field_41178.method_17966(woodId).orElse(null);
            }
            return null;
        }

        public class_2248 mainChild() {
            return this.block;
        }

        public Collection<class_1935> getChildren() {
            return this.items.values();
        }
    }
}

