/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.fabric;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.fabric.FabricClientEvents;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2248;
import net.minecraft.class_304;
import net.minecraft.class_7923;

public class FabricPlatformImpl
implements Platform {
    @Override
    public boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Override
    public String loader() {
        return "fabric";
    }

    @Override
    public Path getResourcePack() {
        return FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
    }

    @Override
    public JsonObject getFileInJar(String namespace, String path) {
        try {
            return JsonParser.parseReader((Reader)new FileReader(((Path)((ModContainer)FabricLoader.getInstance().getModContainer(namespace).get()).findPath(path).get()).toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path configPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    }

    @Override
    public int shapeKey() {
        return KeyBindingHelper.getBoundKeyOf((class_304)FabricClientEvents.SHAPE_KEY).method_1444();
    }

    @Override
    public void finalizeCopperBlockRegistration() {
        ClutterNoMore.COPPER_BLOCKS.forEach((less, more) -> {
            class_2248 lessBlock = (class_2248)class_7923.field_41175.method_63535(less);
            class_2248 moreBlock = (class_2248)class_7923.field_41175.method_63535(more);
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)lessBlock, (class_2248)moreBlock);
        });
        ClutterNoMore.WAXED_COPPER_BLOCKS.forEach(resourceLocation -> {
            Optional waxedBlock = class_7923.field_41175.method_17966(resourceLocation);
            Optional unwaxedBlock = class_7923.field_41175.method_17966(ClutterNoMore.location(resourceLocation.method_12836(), resourceLocation.method_12832().replace("waxed_", "")));
            if (waxedBlock.isPresent() && unwaxedBlock.isPresent()) {
                OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)((class_2248)unwaxedBlock.get()), (class_2248)((class_2248)waxedBlock.get()));
            }
        });
    }
}

