/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AssetGenerator {
    public static Set<String> keys;

    public static void generate() {
        if (keys == null) {
            return;
        }
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        JsonObject lang = new JsonObject();
        keys.forEach(s -> lang.addProperty("block.clutternomore." + s.replace("/", "."), AssetGenerator.langName(s)));
        boolean writeLang = true;
        try {
            JsonObject existingLangJson;
            Optional existingLang = manager.getResource(ClutterNoMore.location("lang/en_us.json"));
            if (existingLang.isPresent() && (existingLangJson = JsonParser.parseReader((Reader)((Resource)existingLang.get()).openAsReader()).getAsJsonObject()).equals((Object)lang)) {
                writeLang = false;
            }
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.catching((Throwable)e);
            throw new RuntimeException(e);
        }
        if (writeLang) {
            AssetGenerator.write("lang/en_us.json", (JsonElement)lang);
        }
        VerticalSlabGenerator.generate(manager);
        StepGenerator.generate(manager);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.RUNTIME_ASSET_GENERATION.value()).booleanValue()) {
            int minFormat = 15;
            int maxFormat = 70;
            JsonObject object = new JsonObject();
            object.add("description", (JsonElement)new JsonPrimitive("Generated resources for ClutterNoMore"));
            object.add("pack_format", (JsonElement)new JsonPrimitive((Number)CNMPackResources.resourcePackVersion));
            object.add("min_format", (JsonElement)new JsonPrimitive((Number)minFormat));
            object.add("max_format", (JsonElement)new JsonPrimitive((Number)maxFormat));
            JsonArray supportedFormats = new JsonArray(2);
            supportedFormats.add((Number)minFormat);
            supportedFormats.add((Number)maxFormat);
            object.add("supported_formats", (JsonElement)supportedFormats);
            JsonObject mcmeta = new JsonObject();
            mcmeta.add("pack", (JsonElement)object);
            ClutterNoMore.writeFile(ClutterNoMore.pack, ClutterNoMore.pack.resolve("pack.mcmeta"), mcmeta.toString());
        }
    }

    public static void write(String fileName, JsonElement contents) {
        ClutterNoMore.RESOURCES.addJson(PackType.CLIENT_RESOURCES, ClutterNoMore.location(fileName), contents);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.RUNTIME_ASSET_GENERATION.value()).booleanValue()) {
            Path assets = ClutterNoMore.pack.resolve("assets/clutternomore");
            ClutterNoMoreClient.requireReload = true;
            ClutterNoMore.writeFile(assets.resolve(fileName.substring(0, fileName.lastIndexOf("/"))), assets.resolve(fileName), contents.toString());
        }
    }

    public static String langName(String name) {
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        String processed = name.replace("_", " ");
        List<String> nonCapital = List.of("of", "and", "with");
        String[] words = processed.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (!nonCapital.contains(word)) {
                result.append(Character.toUpperCase(word.charAt(0)));
            } else {
                result.append(word.charAt(0));
            }
            result.append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    @Nullable
    public static JsonObject getTextures(ResourceManager manager, ResourceLocation parent) throws IOException {
        Optional parentBlockState = manager.getResource(parent.withPrefix("blockstates/").withSuffix(".json"));
        if (parentBlockState.isEmpty()) {
            return null;
        }
        String model = null;
        BufferedReader reader = ((Resource)parentBlockState.get()).openAsReader();
        String line = reader.readLine();
        while (line != null) {
            if (line.contains("\"model\":")) {
                int firstIndex = line.indexOf("\"", line.indexOf("model\":") + 7);
                int secondIndex = line.indexOf("\"", firstIndex + 1);
                model = line.substring(firstIndex + 1, secondIndex);
                break;
            }
            line = reader.readLine();
        }
        if (model == null) {
            return null;
        }
        String[] modelParts = model.split(":");
        if (modelParts.length != 2) {
            return null;
        }
        Optional parentModel = manager.getResource(ClutterNoMore.location(modelParts[0], "models/%s.json".formatted(modelParts[1])));
        if (parentModel.isEmpty()) {
            return null;
        }
        JsonObject textures = JsonParser.parseReader((Reader)((Resource)parentModel.get()).openAsReader()).getAsJsonObject().getAsJsonObject("textures");
        if (textures == null) {
            return null;
        }
        if (textures.get("top") == null) {
            if (textures.get("side") != null) {
                textures.add("top", textures.get("side"));
            } else if (textures.get("bottom") != null) {
                textures.add("top", textures.get("bottom"));
            }
        }
        if (textures.get("side") == null) {
            textures.add("side", textures.get("top"));
        }
        if (textures.get("bottom") == null) {
            textures.add("bottom", textures.get("top"));
        }
        return textures.get("top") == null ? null : textures;
    }

    public static void generateItem(ResourceLocation shape, ResourceManager manager) {
        String modelString = shape.getPath();
        modelString = modelString.replace("waxed_", "");
        Optional existingItemState = manager.getResource(shape.withPrefix("models/item/").withSuffix(".json"));
        if (existingItemState.isPresent()) {
            return;
        }
        JsonObject model = new JsonObject();
        model.addProperty("parent", "clutternomore:block/" + modelString);
        AssetGenerator.write("models/item/%s.json".formatted(shape.getPath()), (JsonElement)model);
    }
}

