/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin.creative;

import dev.tazer.clutternomore.common.CHooks;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.InsertableLinkedOpenCustomHashSet;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BuildCreativeModeTabContentsEvent.class})
public abstract class CreativeModeTabEntriesMixin {
    @Shadow
    public abstract void insertBefore(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);

    @Shadow
    public abstract void insertAfter(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);

    @Inject(method={"accept"}, at={@At(value="HEAD")}, cancellable=true)
    private void accept(ItemStack newEntry, CreativeModeTab.TabVisibility visibility, CallbackInfo ci) {
        if (CHooks.denyItem(newEntry.getItem())) {
            ci.cancel();
        }
    }

    @Inject(method={"insertAfter"}, at={@At(value="HEAD")}, cancellable=true)
    private void insertAfter(ItemStack existingEntry, ItemStack newEntry, CreativeModeTab.TabVisibility visibility, CallbackInfo ci) {
        if (CHooks.denyItem(newEntry.getItem())) {
            ci.cancel();
        }
        if (ShapeMap.isShape(existingEntry.getItem())) {
            this.insertAfter(ShapeMap.getParent(existingEntry.getItem()).getDefaultInstance(), newEntry, visibility);
            ci.cancel();
        }
    }

    @Inject(method={"insertBefore"}, at={@At(value="HEAD")}, cancellable=true)
    private void insertBefore(ItemStack existingEntry, ItemStack newEntry, CreativeModeTab.TabVisibility visibility, CallbackInfo ci) {
        if (CHooks.denyItem(newEntry.getItem())) {
            ci.cancel();
        }
        if (ShapeMap.isShape(existingEntry.getItem())) {
            this.insertBefore(ShapeMap.getParent(existingEntry.getItem()).getDefaultInstance(), newEntry, visibility);
            ci.cancel();
        }
    }

    @Inject(method={"assertTargetExists"}, at={@At(value="HEAD")}, cancellable=true)
    private void insertBefore(InsertableLinkedOpenCustomHashSet<ItemStack> setToCheck, ItemStack existingEntry, CallbackInfo ci) {
        ci.cancel();
    }
}

