/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.mixin.access.SlotAccessor;
import dev.tazer.clutternomore.common.mixin.screen.ContainerScreenAccessor;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClutterNoMoreClient {
    public static boolean showTooltip = false;
    public static ShapeSwitcherOverlay OVERLAY = null;
    public static final CNMConfig.ClientConfig CLIENT_CONFIG = (CNMConfig.ClientConfig)CNMConfig.ClientConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"client", CNMConfig.ClientConfig.class);
    public static boolean requireReload = false;

    public static void init() {
    }

    public static void clientStarted(Minecraft client) {
        AssetGenerator.generate();
        ClutterNoMoreClient.enablePack(client);
    }

    public static void onItemTooltips(ItemStack stack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> tooltip) {
        if (!showTooltip && ShapeMap.contains(stack.getItem())) {
            MutableComponent component = tooltip.get(0).copy().append((Component)Component.literal((String)" [+]").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.remove(0);
            tooltip.add(0, (Component)component);
        }
    }

    public static void onKeyInput(int keyCode, int action) {
        if (keyCode == ClutterNoMoreClient.shapeKey()) {
            ItemStack heldStack;
            LocalPlayer player;
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.screen == null && (player = minecraft.player) != null && ShapeMap.contains((heldStack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem())) {
                switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                    case HOLD: {
                        if (OVERLAY == null && action == 1) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        if (action != 0) break;
                        OVERLAY = null;
                        break;
                    }
                    case TOGGLE: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                            break;
                        }
                        OVERLAY = null;
                        break;
                    }
                    case PRESS: {
                        if (action != 1) break;
                        if (OVERLAY == null) {
                            OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                        }
                        OVERLAY.onMouseScrolled(-1);
                        OVERLAY = null;
                    }
                }
            }
        }
    }

    public static void onKeyPress(Screen screen, int button) {
        if (button == ClutterNoMoreClient.shapeKey() && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            Slot slot = ((ContainerScreenAccessor)screen).getSlotUnderMouse();
            if (slot != null) {
                ItemStack heldStack = slot.getItem();
                LocalPlayer player = Minecraft.getInstance().player;
                if (slot.allowModification((Player)player) && ShapeMap.contains(heldStack.getItem())) {
                    switch ((CNMConfig.InputType)((Object)ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value())) {
                        case HOLD: {
                            showTooltip = true;
                            break;
                        }
                        case TOGGLE: {
                            showTooltip = !showTooltip;
                            break;
                        }
                        case PRESS: {
                            ClutterNoMoreClient.switchShapeInSlot((Player)player, containerScreen.getMenu().containerId, ((SlotAccessor)slot).getSlotIndex(), heldStack, -1);
                        }
                    }
                }
            }
        }
    }

    public static boolean onKeyReleased(int button) {
        if (button == ClutterNoMoreClient.shapeKey() && ClutterNoMoreClient.CLIENT_CONFIG.HOLD.value() == CNMConfig.InputType.HOLD) {
            showTooltip = false;
        }
        return false;
    }

    public static void switchShapeInSlot(Player player, int containerId, int slotId, ItemStack heldStack, int direction) {
        Item item = ShapeMap.getParent(heldStack.getItem());
        int count = heldStack.getCount();
        ArrayList<Item> shapes = new ArrayList<Item>(ShapeMap.getShapes(item));
        shapes.add(0, item);
        int selectedIndex = shapes.indexOf(heldStack.getItem());
        int maxIndex = shapes.size() - 1;
        if ((selectedIndex -= direction) < 0) {
            selectedIndex = maxIndex;
        }
        if (selectedIndex > maxIndex) {
            selectedIndex = 0;
        }
        Item nextItem = (Item)shapes.get(selectedIndex);
        ItemStack next = nextItem.getDefaultInstance();
        next.setCount(count);
        player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.3f, 1.5f);
        if (slotId < 9) {
            slotId += 36;
        }
        ChangeStackPayload p = new ChangeStackPayload(containerId, slotId, next);
        PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int shapeKey() {
        return Platform.INSTANCE.shapeKey();
    }

    public static void onPlayerTick(Minecraft minecraft) {
        if (OVERLAY != null && !OVERLAY.shouldStayOpenThisTick()) {
            OVERLAY = null;
        }
    }

    public static void onRenderGui(GuiGraphics guiGraphics, DeltaTracker tracker) {
        if (OVERLAY != null && ClutterNoMoreClient.OVERLAY.render) {
            OVERLAY.render(guiGraphics, tracker.getGameTimeDeltaTicks());
        }
    }

    public static boolean allowScreenScroll(Screen pScreen, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (showTooltip && pScreen instanceof AbstractContainerScreen) {
            ItemStack heldStack;
            AbstractContainerScreen screen = (AbstractContainerScreen)pScreen;
            Slot slot = ((ContainerScreenAccessor)screen).getSlotUnderMouse();
            LocalPlayer player = Minecraft.getInstance().player;
            if (slot != null && slot.allowModification((Player)player) && ShapeMap.contains((heldStack = slot.getItem()).getItem())) {
                ClutterNoMoreClient.switchShapeInSlot((Player)player, screen.getMenu().containerId, ((SlotAccessor)slot).getSlotIndex(), heldStack, (int)scrollY);
                return false;
            }
        }
        return true;
    }

    public static boolean onMouseScrolling(double yOffset) {
        int direction = (int)yOffset;
        if (OVERLAY != null) {
            OVERLAY.onMouseScrolled(direction);
            return true;
        }
        return false;
    }

    private static void enablePack(Minecraft client) {
        Path resourcepackPath;
        PackRepository repository = client.getResourcePackRepository();
        if (requireReload && (resourcepackPath = client.getResourcePackDirectory().resolve("clutternomore")).toFile().exists()) {
            repository.reload();
            repository.addPack("file/" + resourcepackPath.getFileName().toString());
            client.reloadResourcePacks();
        }
    }
}

