/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.properties.SlabType;

public final class StepGenerator {
    public static ArrayList<ResourceLocation> STAIRS = new ArrayList();

    public static void generate(ResourceManager manager) {
        for (ResourceLocation parent : STAIRS) {
            Object namespace = parent.getNamespace() + "/";
            if (parent.getNamespace().equals("minecraft")) {
                namespace = "";
            }
            ResourceLocation shape = ClutterNoMore.location((String)namespace + parent.getPath().replace("stairs", "step"));
            try {
                StepGenerator.generateBlock(parent, shape, manager);
                AssetGenerator.generateItem(shape, manager);
            }
            catch (IOException e) {
                ClutterNoMore.LOGGER.catching((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void generateBlock(ResourceLocation parent, ResourceLocation shape, ResourceManager manager) throws IOException {
        Optional existingBlockState = manager.getResource(shape.withPrefix("blockstates/").withSuffix(".json"));
        if (existingBlockState.isPresent()) {
            return;
        }
        JsonObject textures = AssetGenerator.getTextures(manager, parent);
        if (textures == null) {
            return;
        }
        JsonObject blockModel = new JsonObject();
        blockModel.addProperty("parent", "clutternomore:block/templates/step");
        blockModel.add("textures", (JsonElement)textures);
        AssetGenerator.write("models/block/%s.json".formatted(shape.getPath()), (JsonElement)blockModel);
        blockModel.addProperty("parent", "clutternomore:block/templates/step_double");
        AssetGenerator.write("models/block/%s_double.json".formatted(shape.getPath()), (JsonElement)blockModel);
        blockModel.addProperty("parent", "clutternomore:block/templates/step_top");
        AssetGenerator.write("models/block/%s_top.json".formatted(shape.getPath()), (JsonElement)blockModel);
        JsonObject variants = new JsonObject();
        StepBlock.FACING.getAllValues().forEach(directionValue -> StepBlock.SLAB_TYPE.getAllValues().forEach(doubleState -> {
            JsonObject model = new JsonObject();
            Object modelString = "clutternomore:block/" + shape.getPath();
            modelString = ((String)modelString).replace("waxed_", "");
            model.addProperty("uvlock", Boolean.valueOf(true));
            if (((SlabType)doubleState.value()).equals((Object)SlabType.DOUBLE)) {
                model.addProperty("model", (String)modelString + "_double");
            } else if (((SlabType)doubleState.value()).equals((Object)SlabType.TOP)) {
                model.addProperty("model", (String)modelString + "_top");
            } else {
                model.addProperty("model", (String)modelString);
            }
            if (((Direction)directionValue.value()).equals((Object)Direction.EAST)) {
                model.addProperty("y", (Number)90);
            } else if (((Direction)directionValue.value()).equals((Object)Direction.SOUTH)) {
                model.addProperty("y", (Number)180);
            } else if (((Direction)directionValue.value()).equals((Object)Direction.WEST)) {
                model.addProperty("y", (Number)270);
            }
            variants.add(String.valueOf(directionValue) + "," + String.valueOf(doubleState), (JsonElement)model);
        }));
        JsonObject blockState = new JsonObject();
        blockState.add("variants", (JsonElement)variants);
        AssetGenerator.write("blockstates/%s.json".formatted(shape.getPath()), (JsonElement)blockState);
    }
}

