/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.mixin;

import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTooltipImage(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        Item item = stack.getItem();
        if (ShapeMap.contains(item)) {
            Item originalItem = ShapeMap.getParent(item);
            ArrayList<Item> shapes = new ArrayList<Item>(ShapeMap.getShapes(originalItem));
            shapes.add(originalItem);
            cir.setReturnValue(Optional.of(new ShapeTooltip(shapes, shapes.indexOf(item))));
        }
    }
}

