package dev.tazer.clutternomore.common.shape_map;

//? if >1.21.4 {
/*import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.common.compat.EIVCompat;
*///?}
//? if fabric || neoforge {
import dev.tazer.clutternomore.common.networking.ShapeMapPayload;
//?}
//? if fabric {
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
//?}
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.util.*;

public class ShapeMap {
    private static final Map<class_1792, List<class_1792>> SHAPES_DATAMAP = new HashMap<>();
    private static final Map<class_1792, class_1792> INVERSE_SHAPES_DATAMAP = new HashMap<>();

    public static void setShapeMaps(Map<class_1792, List<class_1792>> newShapeMap, Map<class_1792, class_1792> newInverseShapeMap) {
        SHAPES_DATAMAP.clear();
        SHAPES_DATAMAP.putAll(newShapeMap);
        INVERSE_SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.putAll(newInverseShapeMap);
    }

    public static boolean hasShapes(class_1792 item) {
        return SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean isShape(class_1792 item) {
        return INVERSE_SHAPES_DATAMAP.containsKey(item);
    }

    public static boolean contains(class_1792 item) {
        return hasShapes(item) || isShape(item);
    }

    public static class_1792 getParent(class_1792 item) {
        return INVERSE_SHAPES_DATAMAP.getOrDefault(item, item);
    }

    public static boolean isParentOfShape(class_1792 parent, class_1792 shape) {
        return getParent(shape) == parent;
    }

    public static boolean inSameShapeSet(class_1792 item, class_1792 other) {
        if (isShape(item) || isShape(other))
            return (getParent(item) == getParent(other));
        return false;
    }

    public static List<class_1792> getShapes(class_1792 item) {
        return SHAPES_DATAMAP.getOrDefault(getParent(item), List.of());
    }

    public static void set(Map<class_2960, List<class_2960>> idMap) {
        SHAPES_DATAMAP.clear();
        INVERSE_SHAPES_DATAMAP.clear();

        for (Map.Entry<class_2960, List<class_2960>> entry : idMap.entrySet()) {
            class_2960 key = entry.getKey();
            class_1792 newKey = class_7923.field_41178.method_17966(key).orElse(null);
            if (newKey != null) {
                List<class_2960> value = entry.getValue();
                List<class_1792> newValue = new ArrayList<>();

                for (class_2960 location : value) {
                    class_7923.field_41178.method_17966(location).map(newValue::add);
                }

                if (!newValue.isEmpty()) SHAPES_DATAMAP.put(newKey, newValue);
            }
        }

        class_7923.field_41178.method_29722().forEach((key -> {
            var id = key.getKey().method_29177();
            var item = key.getValue();
            if (item instanceof class_1747 blockItem) {
                var block = blockItem.method_7711();
                BlockSetRegistry.ShapeSetRegistry.detectTypeFromBlock(block, id);
            }
        }));

        for (class_1792 item : class_7923.field_41178.method_10220().toList()) {
            List<class_1792> shapes = new ArrayList<>(getShapes(item));

            BlockSetRegistry.ShapeSet shapeSet = BlockSetRegistry.getBlockTypeOf(item);

            if (shapeSet != null) {
                class_1792 mainChild = shapeSet.mainChild().method_8389();
                if (item == mainChild) {
                    shapeSet.getChildren().forEach(child -> {
                        if (child != mainChild && child instanceof class_1792 shape) {
                            shapes.add(shape);
                            //? if >1.21.4 {
                            /*if (Platform.INSTANCE.isModLoaded("eiv"))
                                EIVCompat.hide(shape);
                            *///?}
                        }
                    });
                }
            }


            if (!shapes.isEmpty()) SHAPES_DATAMAP.put(item, shapes);
        }

        for (Map.Entry<class_1792, List<class_1792>> entry : new HashSet<>(SHAPES_DATAMAP.entrySet())) {
            class_1792 item = entry.getKey();
            List<class_1792> shapes = entry.getValue();

            for (class_1792 shape : shapes) {
                INVERSE_SHAPES_DATAMAP.put(shape, item);
                //? if >1.21.4 {
                /*if (Platform.INSTANCE.isModLoaded("eiv"))
                    EIVCompat.hide(shape);
                *///?}
            }
        }

        for (Map.Entry<class_1792, class_1792> entry : new HashSet<>(INVERSE_SHAPES_DATAMAP.entrySet())) {
            if (!hasShapes(entry.getValue())) {
                INVERSE_SHAPES_DATAMAP.remove(entry.getKey());
            }
        }
    }

    public static void sendShapeMap(class_3222 serverPlayer) {
        if (serverPlayer == null) return;
        final Map<class_1799, List<class_1799>> shapes = new HashMap<>();
        SHAPES_DATAMAP.forEach(((item, items) -> {
            ArrayList<class_1799> objects = new ArrayList<>();
            items.forEach((stack -> objects.add(stack.method_7854())));
            shapes.put(item.method_7854(), objects);
        }));
        final Map<class_1799, class_1799> inverseShapes = new HashMap<>();
        INVERSE_SHAPES_DATAMAP.forEach(((item, items) -> {
            inverseShapes.put(item.method_7854(), items.method_7854());
        }));
        //? if fabric
        ServerPlayNetworking.send(serverPlayer, new ShapeMapPayload(shapes, inverseShapes));
        //? if neoforge
        /*PacketDistributor.sendToPlayer(serverPlayer, new ShapeMapPayload(shapes, inverseShapes));*/
        //? if forge
        /*ForgeNetworking.sendToPlayer(serverPlayer, new ShapeMapPacket(shapes, inverseShapes));*/
    }
}
